/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.L1cScienceSmosFile;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.BTValueProvider;
import org.esa.smos.dataio.smos.provider.SnapshotValueProvider;

public class L1cScienceValueProvider
extends AbstractValueProvider {
    private final L1cScienceSmosFile smosFile;
    private final int memberIndex;
    private final int polarisation;
    private volatile long snapshotId;
    private AbstractValueProvider valueProviderImpl;

    L1cScienceValueProvider(L1cScienceSmosFile smosFile, int memberIndex, int polarization) {
        this.smosFile = smosFile;
        this.memberIndex = memberIndex;
        this.polarisation = polarization;
        this.snapshotId = -1L;
        this.valueProviderImpl = new BTValueProvider(smosFile, memberIndex, this.polarisation);
    }

    public final long getSnapshotId() {
        return this.snapshotId;
    }

    public final void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
        this.valueProviderImpl = snapshotId < 0L ? new BTValueProvider(this.smosFile, this.memberIndex, this.polarisation) : new SnapshotValueProvider(this.smosFile, this.memberIndex, this.polarisation, snapshotId);
    }

    @Override
    public Area getArea() {
        return this.valueProviderImpl.getArea();
    }

    @Override
    public int getGridPointIndex(int seqnum) {
        return this.smosFile.getGridPointIndex(seqnum);
    }

    @Override
    public byte getByte(int gridPointIndex) throws IOException {
        return this.valueProviderImpl.getByte(gridPointIndex);
    }

    @Override
    public short getShort(int gridPointIndex) throws IOException {
        return this.valueProviderImpl.getShort(gridPointIndex);
    }

    @Override
    public int getInt(int gridPointIndex) throws IOException {
        return this.valueProviderImpl.getInt(gridPointIndex);
    }

    @Override
    public float getFloat(int gridPointIndex) throws IOException {
        return this.valueProviderImpl.getFloat(gridPointIndex);
    }
}

