/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.esa.smos.EEFilePair;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.GridPointList;
import org.esa.smos.dataio.smos.L1cScienceValueProvider;
import org.esa.smos.dataio.smos.L1cSmosFile;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.DP;
import org.esa.smos.dataio.smos.provider.DPH;
import org.esa.smos.dataio.smos.provider.DPV;
import org.esa.smos.dataio.smos.provider.FP;
import org.esa.smos.dataio.smos.provider.FPH;
import org.esa.smos.dataio.smos.provider.FPHVR;
import org.esa.smos.dataio.smos.provider.FPV;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;

public class L1cScienceSmosFile
extends L1cSmosFile {
    private static final String INCIDENCE_ANGLE_NAME = "Incidence_Angle";
    private final Map<String, AbstractValueProvider> valueProviderMap = new HashMap<String, AbstractValueProvider>(17);
    private final int flagsIndex;
    private final int incidenceAngleIndex;
    private final int snapshotIdOfPixelIndex;
    private final double incidenceAngleScalingFactor;
    private final SequenceData snapshotList;
    private final CompoundType snapshotType;
    private final Future<SnapshotInfo> snapshotInfoFuture;

    L1cScienceSmosFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext);
        String formatName = dataContext.getFormat().getName();
        this.flagsIndex = this.getBtDataType().getMemberIndex("Flags");
        this.incidenceAngleIndex = this.getBtDataType().getMemberIndex(INCIDENCE_ANGLE_NAME);
        Family<BandDescriptor> bandDescriptors = Dddb.getInstance().getBandDescriptors(formatName);
        if (bandDescriptors == null) {
            throw new IOException(MessageFormat.format("No band descriptors found for format ''{0}''.", formatName));
        }
        this.incidenceAngleScalingFactor = this.getIncidenceAngleScalingFactor(bandDescriptors);
        this.snapshotIdOfPixelIndex = this.getBtDataType().getMemberIndex("Snapshot_ID_of_Pixel");
        this.snapshotList = this.getDataBlock().getSequence("Swath_Snapshot_List");
        if (this.snapshotList == null) {
            throw new IOException("Data block does not include snapshot list.");
        }
        this.snapshotType = (CompoundType)this.snapshotList.getType().getElementType();
        this.snapshotInfoFuture = Executors.newSingleThreadExecutor().submit(() -> this.createSnapshotInfo());
    }

    private double getIncidenceAngleScalingFactor(Family<BandDescriptor> descriptors) {
        for (BandDescriptor descriptor : descriptors.asList()) {
            if (!INCIDENCE_ANGLE_NAME.equals(descriptor.getMemberName())) continue;
            return descriptor.getScalingFactor();
        }
        throw new IllegalStateException("No incidence angle scaling factor found.");
    }

    @Override
    public void close() {
        this.valueProviderMap.clear();
        super.close();
    }

    @Override
    protected void addBands(Product product) {
        super.addBands(product);
        if (SmosUtils.isDualPolScienceFormat((String)this.getDataFormat().getName())) {
            this.addRotatedDualPolBands(product, this.valueProviderMap);
        } else {
            this.addRotatedFullPolBands(product, this.valueProviderMap);
        }
    }

    @Override
    protected final void addBand(Product product, BandDescriptor descriptor) {
        if (descriptor.getPolarization() < 0) {
            super.addBand(product, descriptor);
        } else {
            this.addBand(product, descriptor, this.getBtDataType());
        }
    }

    @Override
    protected final AbstractValueProvider createValueProvider(BandDescriptor descriptor) {
        int polarization = descriptor.getPolarization();
        if (polarization < 0) {
            return super.createValueProvider(descriptor);
        }
        int memberIndex = this.getBtDataType().getMemberIndex(descriptor.getMemberName());
        L1cScienceValueProvider valueProvider = new L1cScienceValueProvider(this, memberIndex, polarization);
        this.valueProviderMap.put(descriptor.getBandName(), valueProvider);
        return valueProvider;
    }

    @Override
    protected final MultiLevelImage createSourceImage(Band band, ValueProvider valueProvider) {
        return super.createSourceImage(band, valueProvider);
    }

    public final CompoundData getSnapshotData(int snapshotIndex) throws IOException {
        return this.snapshotList.getCompound(snapshotIndex);
    }

    public boolean hasSnapshotInfo() {
        return this.snapshotInfoFuture.isDone();
    }

    public SnapshotInfo getSnapshotInfo() {
        try {
            return this.snapshotInfoFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public int getSnapshotCount() {
        return this.snapshotList.getElementCount();
    }

    public byte getBrowseBtDataValueByte(int gridPointIndex, int memberIndex, int polarization) throws IOException {
        if (memberIndex == this.flagsIndex) {
            return (byte)this.getCombinedFlags(gridPointIndex, polarization);
        }
        return (byte)this.getInterpolatedValue(gridPointIndex, memberIndex, polarization);
    }

    public short getBrowseBtDataValueShort(int gridPointIndex, int memberIndex, int polarization) throws IOException {
        if (memberIndex == this.flagsIndex) {
            return (short)this.getCombinedFlags(gridPointIndex, polarization);
        }
        return (short)this.getInterpolatedValue(gridPointIndex, memberIndex, polarization);
    }

    public int getBrowseBtDataValueInt(int gridPointIndex, int memberIndex, int polarization) throws IOException {
        if (memberIndex == this.flagsIndex) {
            return this.getCombinedFlags(gridPointIndex, polarization);
        }
        return (int)this.getInterpolatedValue(gridPointIndex, memberIndex, polarization);
    }

    public float getBrowseBtDataValueFloat(int gridPointIndex, int memberIndex, int polarization) throws IOException {
        return (float)this.getInterpolatedValue(gridPointIndex, memberIndex, polarization);
    }

    public CompoundData getSnapshotBtData(int gridPointIndex, int polarization, long snapshotId) throws IOException {
        SequenceData btDataList = this.getBtDataList(gridPointIndex);
        int elementCount = btDataList.getElementCount();
        if (elementCount > 0) {
            CompoundData btData = btDataList.getCompound(0);
            if (btData.getLong(this.snapshotIdOfPixelIndex) > snapshotId) {
                return null;
            }
            btData = btDataList.getCompound(elementCount - 1);
            if (btData.getLong(this.snapshotIdOfPixelIndex) < snapshotId) {
                return null;
            }
            for (int i = 0; i < elementCount; ++i) {
                btData = btDataList.getCompound(i);
                if (btData.getLong(this.snapshotIdOfPixelIndex) != snapshotId) continue;
                int flags = btData.getInt(this.flagsIndex);
                if (polarization != 4 && polarization != (flags & 1) && (polarization & flags & 2) == 0) continue;
                return btData;
            }
        }
        return null;
    }

    private double getInterpolatedValue(int gridPointIndex, int memberIndex, int polarization) throws IOException {
        SequenceData btDataList = this.getBtDataList(gridPointIndex);
        int elementCount = btDataList.getElementCount();
        int count = 0;
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        boolean hasLower = false;
        boolean hasUpper = false;
        for (int i = 0; i < elementCount; ++i) {
            double incidenceAngle;
            CompoundData btData = btDataList.getCompound(i);
            int flags = btData.getInt(this.flagsIndex);
            if (polarization != 4 && polarization != (flags & 3) && (polarization & flags & 2) == 0 || !((incidenceAngle = this.incidenceAngleScalingFactor * (double)btData.getInt(this.incidenceAngleIndex)) >= 37.5) || !(incidenceAngle <= 52.5)) continue;
            float value = btData.getFloat(memberIndex);
            sx += incidenceAngle;
            sy += (double)value;
            sxx += incidenceAngle * incidenceAngle;
            sxy += incidenceAngle * (double)value;
            ++count;
            if (!hasLower) {
                boolean bl = hasLower = incidenceAngle <= 42.5;
            }
            if (hasUpper) continue;
            hasUpper = incidenceAngle > 42.5;
        }
        if (hasLower && hasUpper) {
            double a = ((double)count * sxy - sx * sy) / ((double)count * sxx - sx * sx);
            double b = (sy - a * sx) / (double)count;
            return a * 42.5 + b;
        }
        throw new IOException(MessageFormat.format("No data found for grid point ''{0}'' and polarisation ''{1}''.", gridPointIndex, polarization));
    }

    private int getCombinedFlags(int gridPointIndex, int polarization) throws IOException {
        SequenceData btDataList = this.getBtDataList(gridPointIndex);
        int elementCount = btDataList.getElementCount();
        int combinedFlags = 0;
        boolean hasLower = false;
        boolean hasUpper = false;
        for (int i = 0; i < elementCount; ++i) {
            double incidenceAngle;
            CompoundData btData = btDataList.getCompound(i);
            int flags = btData.getInt(this.flagsIndex);
            if (polarization != 4 && polarization != (flags & 3) && (polarization & flags & 2) == 0 || !((incidenceAngle = this.incidenceAngleScalingFactor * (double)btData.getInt(this.incidenceAngleIndex)) >= 37.5) || !(incidenceAngle <= 52.5)) continue;
            combinedFlags |= flags;
            if (!hasLower) {
                boolean bl = hasLower = incidenceAngle <= 42.5;
            }
            if (hasUpper) continue;
            hasUpper = incidenceAngle > 42.5;
        }
        if (hasLower && hasUpper) {
            return combinedFlags;
        }
        throw new IOException(MessageFormat.format("No data found for grid point ''{0}'' and polarisation ''{1}''.", gridPointIndex, polarization));
    }

    private SnapshotInfo createSnapshotInfo() throws IOException {
        TreeSet<Long> all = new TreeSet<Long>();
        TreeSet<Long> x = new TreeSet<Long>();
        TreeSet<Long> y = new TreeSet<Long>();
        TreeSet<Long> xy = new TreeSet<Long>();
        TreeMap<Long, Rectangle2D> snapshotAreaMap = new TreeMap<Long, Rectangle2D>();
        int latIndex = this.getGridPointType().getMemberIndex("Latitude");
        int lonIndex = this.getGridPointType().getMemberIndex("Longitude");
        GridPointList gridPointList = this.getGridPointList();
        int gridPointCount = this.getGridPointCount();
        for (int i = 0; i < gridPointCount; ++i) {
            SequenceData btList = this.getBtDataList(i);
            int btCount = btList.getElementCount();
            if (btCount <= 0) continue;
            CompoundData gridData = gridPointList.getCompound(i);
            double lon = gridData.getDouble(lonIndex);
            double lat = gridData.getDouble(latIndex);
            if (lon > 180.0) {
                lon -= 360.0;
            }
            Rectangle2D rectangle = DggUtils.createGridPointRectangle(lon, lat);
            long lastId = -1L;
            block6: for (int j = 0; j < btCount; ++j) {
                CompoundData btData = btList.getCompound(j);
                long id = btData.getLong(this.snapshotIdOfPixelIndex);
                if (lastId != id) {
                    all.add(id);
                    if (snapshotAreaMap.containsKey(id)) {
                        ((Rectangle2D)snapshotAreaMap.get(id)).add(rectangle);
                    } else {
                        snapshotAreaMap.put(id, rectangle);
                    }
                    lastId = id;
                }
                int flags = btData.getInt(this.flagsIndex);
                switch (flags & 3) {
                    case 0: {
                        x.add(id);
                        continue block6;
                    }
                    case 1: {
                        y.add(id);
                        continue block6;
                    }
                    case 2: 
                    case 3: {
                        xy.add(id);
                    }
                }
            }
        }
        TreeMap<Long, Integer> snapshotIndexMap = new TreeMap<Long, Integer>();
        int snapshotIdIndex = this.snapshotType.getMemberIndex("Snapshot_ID");
        int snapshotCount = this.snapshotList.getElementCount();
        for (int i = 0; i < snapshotCount; ++i) {
            long id = this.getSnapshotData(i).getLong(snapshotIdIndex);
            if (!all.contains(id)) continue;
            snapshotIndexMap.put(id, i);
        }
        String dataFormatName = this.getDataFormat().getName();
        Family<BandDescriptor> bandDescriptors = Dddb.getInstance().getBandDescriptors(dataFormatName);
        List<BandDescriptor> bandDescriptorsList = bandDescriptors.asList();
        List<FlagDescriptor> flagDescriptorList = null;
        for (BandDescriptor descriptor : bandDescriptorsList) {
            if (!descriptor.getBandName().equals("RFI_Flags")) continue;
            Family<FlagDescriptor> flagDescriptors = descriptor.getFlagDescriptors();
            flagDescriptorList = flagDescriptors.asList();
            break;
        }
        return new SnapshotInfo(snapshotIndexMap, all, x, y, xy, snapshotAreaMap, flagDescriptorList);
    }

    private void addRotatedDualPolBands(Product product, Map<String, AbstractValueProvider> valueProviderMap) {
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(this.getDataFormat().getName());
        DP vp = new DPH(product, valueProviderMap, false);
        BandDescriptor descriptor = descriptors.getMember("BT_Value_H");
        this.addRotatedBand(product, descriptor, vp);
        vp = new DPV(product, valueProviderMap, false);
        descriptor = descriptors.getMember("BT_Value_V");
        this.addRotatedBand(product, descriptor, vp);
        vp = new DPH(product, valueProviderMap, true);
        descriptor = descriptors.getMember("Pixel_Radiometric_Accuracy_H");
        this.addRotatedBand(product, descriptor, vp);
        vp = new DPV(product, valueProviderMap, true);
        descriptor = descriptors.getMember("Pixel_Radiometric_Accuracy_V");
        this.addRotatedBand(product, descriptor, vp);
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_1"), "(BT_Value_X + BT_Value_Y) / 2.0");
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_2"), "(BT_Value_H - BT_Value_V) / 2.0");
    }

    private void addRotatedFullPolBands(Product product, Map<String, AbstractValueProvider> valueProviderMap) {
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(this.getDataFormat().getName());
        FP vp = new FPH(product, valueProviderMap, false);
        BandDescriptor descriptor = descriptors.getMember("BT_Value_H");
        this.addRotatedBand(product, descriptor, vp);
        vp = new FPV(product, valueProviderMap, false);
        descriptor = descriptors.getMember("BT_Value_V");
        this.addRotatedBand(product, descriptor, vp);
        vp = new FPHVR(product, valueProviderMap, false);
        descriptor = descriptors.getMember("BT_Value_HV_Real");
        this.addRotatedBand(product, descriptor, vp);
        ProductHelper.addVirtualBand(product, descriptors.getMember("BT_Value_HV_Imag"), "BT_Value_XY_Imag");
        vp = new FPH(product, valueProviderMap, true);
        descriptor = descriptors.getMember("Pixel_Radiometric_Accuracy_H");
        this.addRotatedBand(product, descriptor, vp);
        vp = new FPV(product, valueProviderMap, true);
        descriptor = descriptors.getMember("Pixel_Radiometric_Accuracy_V");
        this.addRotatedBand(product, descriptor, vp);
        vp = new FPHVR(product, valueProviderMap, true);
        descriptor = descriptors.getMember("Pixel_Radiometric_Accuracy_HV");
        this.addRotatedBand(product, descriptor, vp);
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_1"), "(BT_Value_X + BT_Value_Y) / 2.0");
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_2"), "(BT_Value_H - BT_Value_V) / 2.0");
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_3"), "BT_Value_HV_Real");
        ProductHelper.addVirtualBand(product, descriptors.getMember("Stokes_4"), "BT_Value_XY_Imag");
    }

    private void addRotatedBand(Product product, BandDescriptor descriptor, ValueProvider valueProvider) {
        if (!descriptor.isVisible()) {
            return;
        }
        Band band = product.addBand(descriptor.getBandName(), 30);
        band.setUnit(descriptor.getUnit());
        band.setDescription(descriptor.getDescription());
        if (descriptor.hasFillValue()) {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(descriptor.getFillValue());
        }
        band.setSourceImage(this.createSourceImage(band, valueProvider));
        band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
    }
}

