/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.L1cBrowseSmosFile;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;

class L1cBrowseValueProvider
extends AbstractValueProvider {
    private final L1cBrowseSmosFile smosFile;
    private final int memberIndex;
    private final int polarisation;

    L1cBrowseValueProvider(L1cBrowseSmosFile smosFile, int memberIndex, int polarization) {
        this.smosFile = smosFile;
        this.memberIndex = memberIndex;
        this.polarisation = polarization;
    }

    @Override
    public final Area getArea() {
        return this.smosFile.getArea();
    }

    @Override
    public final int getGridPointIndex(int seqnum) {
        return this.smosFile.getGridPointIndex(seqnum);
    }

    @Override
    public byte getByte(int gridPointIndex) throws IOException {
        return this.smosFile.getBtDataList(gridPointIndex).getCompound(this.polarisation).getByte(this.memberIndex);
    }

    @Override
    public short getShort(int gridPointIndex) throws IOException {
        return this.smosFile.getBtDataList(gridPointIndex).getCompound(this.polarisation).getShort(this.memberIndex);
    }

    @Override
    public int getInt(int gridPointIndex) throws IOException {
        return this.smosFile.getBtDataList(gridPointIndex).getCompound(this.polarisation).getInt(this.memberIndex);
    }

    @Override
    public float getFloat(int gridPointIndex) throws IOException {
        return this.smosFile.getBtDataList(gridPointIndex).getCompound(this.polarisation).getFloat(this.memberIndex);
    }
}

