/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.util.Arrays;

public class GridPointInfo {
    private final int minSeqnum;
    private final int maxSeqnum;
    private final int[] indexes;

    public GridPointInfo(int minSeqnum, int maxSeqnum) {
        this.minSeqnum = minSeqnum;
        this.maxSeqnum = maxSeqnum;
        this.indexes = new int[maxSeqnum - minSeqnum + 1];
        Arrays.fill(this.indexes, -1);
    }

    public void setSequenceNumbers(int[] sequenceNumbers) {
        for (int i = 0; i < sequenceNumbers.length; ++i) {
            this.indexes[sequenceNumbers[i] - this.minSeqnum] = i;
        }
    }

    public int getGridPointIndex(int seqnum) {
        if (seqnum < this.minSeqnum || seqnum > this.maxSeqnum) {
            return -1;
        }
        return this.indexes[seqnum - this.minSeqnum];
    }
}

