/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.util.HashMap;

public class GridPointBtDataset {
    private final HashMap<String, Integer> memberNamesMap;
    private final Class[] columnClasses;
    private Number[][] data;
    private int flagBandIndex;
    private int incidenceAngleBandIndex;
    private int radiometricAccuracyBandIndex;
    private int btValueRealBandIndex;
    private int btValueImaginaryBandIndex;
    private int polarisationFlagBandIndex;

    public GridPointBtDataset(HashMap<String, Integer> memberNamesMap, Class[] columnClasses, Number[][] data) {
        this(memberNamesMap, columnClasses);
        this.data = data;
    }

    public GridPointBtDataset(HashMap<String, Integer> memberNamesMap, Class[] columnClasses) {
        this.memberNamesMap = memberNamesMap;
        this.columnClasses = columnClasses;
        this.data = new Number[0][0];
        this.flagBandIndex = -1;
        this.incidenceAngleBandIndex = -1;
        this.radiometricAccuracyBandIndex = -1;
        this.btValueRealBandIndex = -1;
        this.btValueImaginaryBandIndex = -1;
        this.polarisationFlagBandIndex = -1;
    }

    public int getColumnIndex(String name) {
        Integer index = this.memberNamesMap.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public Number[][] getData() {
        return this.data;
    }

    public void setData(Number[][] data) {
        this.data = data;
    }

    public Class[] getColumnClasses() {
        return this.columnClasses;
    }

    public void setFlagBandIndex(int flagBandIndex) {
        this.flagBandIndex = flagBandIndex;
    }

    public int getFlagBandIndex() {
        return this.flagBandIndex;
    }

    public void setIncidenceAngleBandIndex(int incidenceAngleBandIndex) {
        this.incidenceAngleBandIndex = incidenceAngleBandIndex;
    }

    public int getIncidenceAngleBandIndex() {
        return this.incidenceAngleBandIndex;
    }

    public void setRadiometricAccuracyBandIndex(int radiometricAccuracyBandIndex) {
        this.radiometricAccuracyBandIndex = radiometricAccuracyBandIndex;
    }

    public int getRadiometricAccuracyBandIndex() {
        return this.radiometricAccuracyBandIndex;
    }

    public void setBTValueRealBandIndex(int BTValueRealBandIndex) {
        this.btValueRealBandIndex = BTValueRealBandIndex;
    }

    public int getBTValueRealBandIndex() {
        return this.btValueRealBandIndex;
    }

    public void setBTValueImaginaryBandIndex(int BTValueImaginaryBandIndex) {
        this.btValueImaginaryBandIndex = BTValueImaginaryBandIndex;
    }

    public int getBTValueImaginaryBandIndex() {
        return this.btValueImaginaryBandIndex;
    }

    public void setPolarisationFlagBandIndex(int polarisationFlagBandIndex) {
        this.polarisationFlagBandIndex = polarisationFlagBandIndex;
    }

    public int getPolarisationFlagBandIndex() {
        return this.polarisationFlagBandIndex;
    }
}

