/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.binning.PlanetaryGrid;

public class Grid {
    private final PlanetaryGrid grid;
    private final MultiLevelModel model;

    public Grid(PlanetaryGrid grid) {
        this.grid = grid;
        this.model = SmosDgg.getInstance().getMultiLevelImage().getModel();
    }

    public int getCellIndex(double lon, double lat) {
        return (int)this.grid.getBinIndex(lat, lon);
    }

    public int getCellIndex(int levelPixelX, int levelPixelY, int currentLevel) {
        AffineTransform i2m = this.model.getImageToModelTransform(currentLevel);
        Point2D.Double point = new Point2D.Double();
        ((Point2D)point).setLocation(levelPixelX, levelPixelY);
        i2m.transform(point, point);
        return (int)this.grid.getBinIndex(((Point2D)point).getY(), ((Point2D)point).getX());
    }

    public Rectangle2D getGridRect(double lon, double lat) {
        long binIndex = this.grid.getBinIndex(lat, lon);
        int rowIndex = this.grid.getRowIndex(binIndex);
        int numCols = this.grid.getNumCols(rowIndex);
        double height = 180.0 / (double)this.grid.getNumRows();
        double width = 360.0 / (double)numCols;
        return new Rectangle2D.Double(lon - 0.5 * width, lat - 0.5 * height, width, height);
    }
}

