/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Dimension;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.ExplorerFile;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosMultiLevelSource;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.io.FileUtils;

class GlobalSmosFile
extends ExplorerFile {
    private final SequenceData[] zones;

    protected GlobalSmosFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext);
        SequenceData zoneSequence = this.getDataBlock().getSequence(0);
        this.zones = new SequenceData[zoneSequence.getElementCount()];
        for (int i = 0; i < this.zones.length; ++i) {
            this.zones[i] = zoneSequence.getCompound(i).getSequence(1);
        }
    }

    @Override
    public final Area getArea() {
        return new Area(new Rectangle2D.Double(-180.0, -88.59375, 360.0, 177.1875));
    }

    @Override
    public Product createProduct() throws IOException {
        String productName = FileUtils.getFilenameWithoutExtension((File)this.getDataFile());
        String productType = this.getProductType();
        Dimension dimension = ProductHelper.getSceneRasterDimension();
        Product product = new Product(productName, productType, dimension.width, dimension.height);
        product.setFileLocation(this.getDataFile());
        product.setPreferredTileSize(512, 504);
        ProductHelper.addMetadata(product.getMetadataRoot(), this);
        product.setSceneGeoCoding(ProductHelper.createGeoCoding(dimension));
        CompoundType compoundType = (CompoundType)this.zones[0].getType().getElementType();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(this.getDataFormat().getName());
        if (descriptors != null) {
            for (BandDescriptor descriptor : descriptors.asList()) {
                this.addBand(product, descriptor, compoundType);
            }
        }
        this.addAncilliaryBands(product);
        return product;
    }

    private void addBand(Product product, BandDescriptor descriptor, CompoundType compoundType) {
        if (!descriptor.isVisible()) {
            return;
        }
        int memberIndex = compoundType.getMemberIndex(descriptor.getMemberName());
        if (memberIndex >= 0) {
            CompoundMember member = compoundType.getMember(memberIndex);
            int dataType = ProductHelper.getDataType(member.getType());
            Band band = product.addBand(descriptor.getBandName(), dataType);
            band.setScalingOffset(descriptor.getScalingOffset());
            band.setScalingFactor(descriptor.getScalingFactor());
            if (descriptor.hasFillValue()) {
                band.setNoDataValueUsed(true);
                band.setNoDataValue(descriptor.getFillValue());
            }
            if (!descriptor.getValidPixelExpression().isEmpty()) {
                band.setValidPixelExpression(descriptor.getValidPixelExpression());
            }
            if (!descriptor.getUnit().isEmpty()) {
                band.setUnit(descriptor.getUnit());
            }
            if (!descriptor.getDescription().isEmpty()) {
                band.setDescription(descriptor.getDescription());
            }
            if (descriptor.getFlagDescriptors() != null) {
                ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
            }
            ValueProvider valueProvider = this.createValueProvider(descriptor);
            band.setSourceImage(this.createSourceImage(band, valueProvider));
            band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
        }
    }

    private ValueProvider createValueProvider(final BandDescriptor descriptor) {
        return new ValueProvider(){

            @Override
            public final Area getArea() {
                return GlobalSmosFile.this.getArea();
            }

            @Override
            public final byte getValue(int seqnum, byte noDataValue) {
                int zoneIndex = SmosDgg.seqnumToZoneId((int)seqnum) - 1;
                int gridIndex = SmosDgg.seqnumToSeqnumInZone((int)seqnum) - 1;
                try {
                    return GlobalSmosFile.this.zones[zoneIndex].getCompound(gridIndex).getByte(descriptor.getMemberName());
                }
                catch (IOException e) {
                    return noDataValue;
                }
            }

            @Override
            public final short getValue(int seqnum, short noDataValue) {
                int zoneIndex = SmosDgg.seqnumToZoneId((int)seqnum) - 1;
                int gridIndex = SmosDgg.seqnumToSeqnumInZone((int)seqnum) - 1;
                try {
                    return GlobalSmosFile.this.zones[zoneIndex].getCompound(gridIndex).getShort(descriptor.getMemberName());
                }
                catch (IOException e) {
                    return noDataValue;
                }
            }

            @Override
            public final int getValue(int seqnum, int noDataValue) {
                int zoneIndex = SmosDgg.seqnumToZoneId((int)seqnum) - 1;
                int gridIndex = SmosDgg.seqnumToSeqnumInZone((int)seqnum) - 1;
                try {
                    return GlobalSmosFile.this.zones[zoneIndex].getCompound(gridIndex).getInt(descriptor.getMemberName());
                }
                catch (IOException e) {
                    return noDataValue;
                }
            }

            @Override
            public final float getValue(int gridPointId, float noDataValue) {
                int zoneIndex = SmosDgg.seqnumToZoneId((int)gridPointId) - 1;
                int gridIndex = SmosDgg.seqnumToSeqnumInZone((int)gridPointId) - 1;
                try {
                    return GlobalSmosFile.this.zones[zoneIndex].getCompound(gridIndex).getFloat(descriptor.getMemberName());
                }
                catch (IOException e) {
                    return noDataValue;
                }
            }
        };
    }

    private MultiLevelImage createSourceImage(Band band, ValueProvider valueProvider) {
        return new DefaultMultiLevelImage(this.createMultiLevelSource(band, valueProvider));
    }

    private MultiLevelSource createMultiLevelSource(Band band, ValueProvider valueProvider) {
        return new SmosMultiLevelSource((RasterDataNode)band, valueProvider);
    }
}

