/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.ProductFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.util.IteratorIterable;

public abstract class ExplorerFile
implements ProductFile {
    protected static final String TAG_SPECIFIC_PRODUCT_HEADER = "Specific_Product_Header";
    private final EEFilePair eeFilePair;
    private final DataFormat dataFormat;
    private final DataContext dataContext;

    protected ExplorerFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        this.eeFilePair = eeFilePair;
        this.dataFormat = Dddb.getInstance().getDataFormat(eeFilePair.getHdrFile());
        this.dataContext = dataContext;
    }

    public final File getHeaderFile() {
        return this.eeFilePair.getHdrFile();
    }

    @Override
    public final File getDataFile() {
        return this.eeFilePair.getDblFile();
    }

    public final DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public final CompoundData getDataBlock() {
        return this.dataContext.getData();
    }

    @Override
    public void close() {
        this.dataContext.dispose();
    }

    protected String getProductType() {
        return this.dataFormat.getName().substring(12, 22);
    }

    protected final Document getDocument() throws IOException {
        Document document;
        try {
            document = new SAXBuilder().build(this.eeFilePair.getHdrFile());
        }
        catch (JDOMException e) {
            throw new IOException(MessageFormat.format("File ''{0}'': Invalid document", this.eeFilePair.getHdrFile().getPath()), e);
        }
        return document;
    }

    protected Element getElement(Element parent, String name) throws IOException {
        IteratorIterable descendants = parent.getDescendants();
        while (descendants.hasNext()) {
            Element e;
            Object o = descendants.next();
            if (!(o instanceof Element) || !name.equals((e = (Element)o).getName())) continue;
            return e;
        }
        throw new IOException(MessageFormat.format("File ''{0}'': Missing element ''{1}''.", this.getHeaderFile().getPath(), name));
    }

    protected void addAncilliaryBands(Product product) {
        String formatName = this.getDataFormat().getName();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(formatName);
        if (descriptors == null) {
            return;
        }
        for (BandDescriptor descriptor : descriptors.asList()) {
            String ancilliaryBandName = descriptor.getAncilliaryBandName();
            if (!StringUtils.isNotNullAndNotEmpty((String)ancilliaryBandName)) continue;
            Band dataBand = product.getBand(descriptor.getBandName());
            Band ancilliaryBand = product.getBand(ancilliaryBandName);
            String bandRole = ExplorerFile.getAncilliaryBandRole(ancilliaryBandName);
            dataBand.addAncillaryVariable((RasterDataNode)ancilliaryBand, new String[]{bandRole});
        }
    }

    static String getAncilliaryBandRole(String ancilliaryBandName) {
        if (ancilliaryBandName.contains("DQX")) {
            return "standard_deviation";
        }
        if (ancilliaryBandName.contains("Accuracy")) {
            return "uncertainty";
        }
        return "error";
    }
}

