/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Dimension;
import java.awt.geom.Area;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.ExplorerFile;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.GridPointList;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosMultiLevelSource;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.DefaultValueProvider;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class DggFile
extends ExplorerFile {
    private final GridPointList gridPointList;
    private final int gridPointIdIndex;
    private final Area area;
    private final GridPointInfo gridPointInfo;

    protected DggFile(EEFilePair eeFilePair, DataContext dataContext, boolean fromZones, Area suppliedArea) throws IOException {
        super(eeFilePair, dataContext);
        try {
            this.gridPointList = fromZones ? this.createGridPointListFromZones(this.getDataBlock().getSequence(0)) : this.createGridPointList(this.getDataBlock().getSequence("Grid_Point_List"));
            this.gridPointIdIndex = this.gridPointList.getCompoundType().getMemberIndex("Grid_Point_ID");
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format("Unable to read SMOS File ''{0}'': {1}.", eeFilePair.getDblFile().getPath(), e.getMessage()), e);
        }
        this.gridPointInfo = this.createGridPointInfo();
        this.area = suppliedArea == null ? DggUtils.computeArea(this.getGridPointList()) : suppliedArea;
    }

    protected DggFile(EEFilePair eeFilePair, DataContext dataContext, boolean fromZones) throws IOException {
        this(eeFilePair, dataContext, fromZones, null);
    }

    private GridPointList createGridPointList(SequenceData sequence) {
        return new PlainGridPointList(sequence);
    }

    private GridPointList createGridPointListFromZones(SequenceData zoneSequence) throws IOException {
        SequenceData[] zones = new SequenceData[zoneSequence.getElementCount()];
        for (int i = 0; i < zones.length; ++i) {
            zones[i] = zoneSequence.getCompound(i).getSequence(1);
        }
        return new ZoneGridPointList(zones);
    }

    public final int getGridPointCount() {
        return this.gridPointList.getElementCount();
    }

    public final int getGridPointSeqnum(int i) throws IOException {
        return SmosDgg.gridPointIdToSeqnum((int)this.getGridPointId(i));
    }

    private int getGridPointId(int i) throws IOException {
        int gridPointId = this.gridPointList.getCompound(i).getInt(this.gridPointIdIndex);
        if (gridPointId < 1 || gridPointId > 9262145) {
            throw new IOException(MessageFormat.format("Invalid Grid Point ID {0} at index {1}.", gridPointId, i));
        }
        return gridPointId;
    }

    public final GridPointList getGridPointList() {
        return this.gridPointList;
    }

    public int getGridPointIndex(int seqnum) {
        return this.gridPointInfo.getGridPointIndex(seqnum);
    }

    public final CompoundType getGridPointType() {
        return this.gridPointList.getCompoundType();
    }

    public CompoundData getGridPointData(int gridPointIndex) throws IOException {
        return this.gridPointList.getCompound(gridPointIndex);
    }

    @Override
    public Area getArea() {
        return new Area(this.area);
    }

    @Override
    public final Product createProduct() throws IOException {
        String productName = FileUtils.getFilenameWithoutExtension((File)this.getDataFile());
        String productType = this.getProductType();
        Dimension dimension = ProductHelper.getSceneRasterDimension();
        Product product = new Product(productName, productType, dimension.width, dimension.height);
        product.setFileLocation(this.getDataFile());
        product.setPreferredTileSize(512, 504);
        ProductHelper.addMetadata(product.getMetadataRoot(), this);
        product.setSceneGeoCoding(ProductHelper.createGeoCoding(dimension));
        this.addBands(product);
        this.addAncilliaryBands(product);
        this.setTimes(product);
        return product;
    }

    protected void addBands(Product product) {
        String formatName = this.getDataFormat().getName();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(formatName);
        if (descriptors != null) {
            for (BandDescriptor descriptor : descriptors.asList()) {
                this.addBand(product, descriptor);
            }
        }
    }

    protected void addBand(Product product, BandDescriptor descriptor) {
        this.addBand(product, descriptor, this.getGridPointType());
    }

    protected final void addBand(Product product, BandDescriptor descriptor, CompoundType compoundType) {
        if (!descriptor.isVisible()) {
            return;
        }
        int memberIndex = compoundType.getMemberIndex(descriptor.getMemberName());
        if (memberIndex >= 0) {
            CompoundMember member = compoundType.getMember(memberIndex);
            int dataType = ProductHelper.getDataType(member.getType());
            Band band = product.addBand(descriptor.getBandName(), dataType);
            band.setScalingOffset(descriptor.getScalingOffset());
            this.setScaling(band, descriptor);
            if (descriptor.hasFillValue()) {
                band.setNoDataValueUsed(true);
                band.setNoDataValue(descriptor.getFillValue());
            }
            if (!descriptor.getValidPixelExpression().isEmpty()) {
                band.setValidPixelExpression(descriptor.getValidPixelExpression());
            }
            if (!descriptor.getUnit().isEmpty()) {
                band.setUnit(descriptor.getUnit());
            }
            if (!descriptor.getDescription().isEmpty()) {
                band.setDescription(descriptor.getDescription());
            }
            if (descriptor.getFlagDescriptors() != null) {
                ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
            }
            AbstractValueProvider valueProvider = this.createValueProvider(descriptor);
            band.setSourceImage(this.createSourceImage(band, valueProvider));
            band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
        }
    }

    protected void setScaling(Band band, BandDescriptor descriptor) {
        band.setScalingFactor(descriptor.getScalingFactor());
    }

    protected AbstractValueProvider createValueProvider(BandDescriptor descriptor) {
        final int memberIndex = this.getGridPointType().getMemberIndex(descriptor.getMemberName());
        switch (descriptor.getSampleModel()) {
            case 1: {
                return new DefaultValueProvider(this, memberIndex){

                    @Override
                    public int getInt(int gridPointIndex) throws IOException {
                        return (int)(this.getLong(memberIndex) & 0xFFFFFFFFL);
                    }
                };
            }
            case 2: {
                return new DefaultValueProvider(this, memberIndex){

                    @Override
                    public int getInt(int gridPointIndex) throws IOException {
                        return (int)(this.getLong(memberIndex) >>> 32);
                    }
                };
            }
        }
        return new DefaultValueProvider(this, memberIndex);
    }

    protected MultiLevelImage createSourceImage(Band band, ValueProvider valueProvider) {
        return new DefaultMultiLevelImage(this.createMultiLevelSource(band, valueProvider));
    }

    private MultiLevelSource createMultiLevelSource(Band band, ValueProvider valueProvider) {
        return new SmosMultiLevelSource((RasterDataNode)band, valueProvider);
    }

    private GridPointInfo createGridPointInfo() throws IOException {
        int minSeqnum;
        int maxSeqnum = minSeqnum = this.getGridPointSeqnum(0);
        int gridPointCount = this.getGridPointCount();
        int[] seqNumbers = new int[gridPointCount];
        seqNumbers[0] = minSeqnum;
        for (int i = 1; i < gridPointCount; ++i) {
            int seqnum;
            seqNumbers[i] = seqnum = this.getGridPointSeqnum(i);
            if (seqnum < minSeqnum) {
                minSeqnum = seqnum;
            }
            if (seqnum <= maxSeqnum) continue;
            maxSeqnum = seqnum;
        }
        GridPointInfo gridPointInfo = new GridPointInfo(minSeqnum, maxSeqnum);
        gridPointInfo.setSequenceNumbers(seqNumbers);
        return gridPointInfo;
    }

    private void setTimes(Product product) {
        String pattern = "'UTC='yyyy-MM-dd'T'HH:mm:ss";
        try {
            Document document = this.getDocument();
            Namespace namespace = document.getRootElement().getNamespace();
            Element validityPeriod = this.getElement(document.getRootElement(), "Validity_Period");
            String validityStart = validityPeriod.getChildText("Validity_Start", namespace);
            String validityStop = validityPeriod.getChildText("Validity_Stop", namespace);
            product.setStartTime(ProductData.UTC.parse((String)validityStart, (String)"'UTC='yyyy-MM-dd'T'HH:mm:ss"));
            product.setEndTime(ProductData.UTC.parse((String)validityStop, (String)"'UTC='yyyy-MM-dd'T'HH:mm:ss"));
        }
        catch (Exception e) {
            System.out.println("e.getMessage() = " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static final class ZoneGridPointList
    implements GridPointList {
        private final SequenceData[] zones;
        private final int lonIndex;
        private final int latIndex;

        public ZoneGridPointList(SequenceData[] zones) {
            this.zones = zones;
            this.lonIndex = this.getCompoundType().getMemberIndex("Longitude");
            this.latIndex = this.getCompoundType().getMemberIndex("Latitude");
        }

        public final int getElementCount() {
            int elementCount = 0;
            for (SequenceData zone : this.zones) {
                elementCount += zone.getElementCount();
            }
            return elementCount;
        }

        @Override
        public final CompoundData getCompound(int i) throws IOException {
            int counts = 0;
            int offset = 0;
            int zonesLength = this.zones.length;
            for (int z = 0; z < zonesLength; ++z) {
                if (i < (counts += this.zones[z].getElementCount())) {
                    return this.zones[z].getCompound(i - offset);
                }
                offset = counts;
            }
            throw new IOException(MessageFormat.format("Cannot read compound data for index {0}", i));
        }

        @Override
        public final CompoundType getCompoundType() {
            return (CompoundType)this.zones[0].getType().getElementType();
        }

        public double getLon(int i) throws IOException {
            return this.getCompound(i).getFloat(this.lonIndex);
        }

        public double getLat(int i) throws IOException {
            return this.getCompound(i).getFloat(this.latIndex);
        }
    }

    private static final class PlainGridPointList
    implements GridPointList {
        private final SequenceData sequence;
        private final int latIndex;
        private final int lonIndex;

        public PlainGridPointList(SequenceData sequence) {
            this.sequence = sequence;
            this.lonIndex = this.getCompoundType().getMemberIndex("Longitude");
            this.latIndex = this.getCompoundType().getMemberIndex("Latitude");
        }

        public final int getElementCount() {
            return this.sequence.getElementCount();
        }

        @Override
        public final CompoundData getCompound(int i) throws IOException {
            return this.sequence.getCompound(i);
        }

        @Override
        public final CompoundType getCompoundType() {
            return (CompoundType)this.sequence.getType().getElementType();
        }

        public final double getLon(int i) throws IOException {
            return this.getCompound(i).getFloat(this.lonIndex);
        }

        public final double getLat(int i) throws IOException {
            return this.getCompound(i).getFloat(this.latIndex);
        }
    }
}

