/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.jai.NoDataRaster;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.UnpackedImageData;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;

public class CellGridOpImage
extends SingleBandedOpImage {
    private final CellValueProvider valueProvider;
    private final MultiLevelModel model;
    private final double noDataValue;
    private volatile Area area;
    private volatile NoDataRaster noDataRaster;

    public CellGridOpImage(CellValueProvider valueProvider, RasterDataNode rasterDataNode, MultiLevelModel model, ResolutionLevel level) {
        super(ImageManager.getDataBufferType((int)rasterDataNode.getDataType()), rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), rasterDataNode.getProduct().getPreferredTileSize(), null, level);
        this.valueProvider = valueProvider;
        this.model = model;
        this.noDataValue = rasterDataNode.getNoDataValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Area getArea() {
        if (this.area == null) {
            CellGridOpImage cellGridOpImage = this;
            synchronized (cellGridOpImage) {
                if (this.area == null) {
                    Area modelArea = this.valueProvider.getArea();
                    this.area = modelArea.createTransformedArea(this.model.getModelToImageTransform(this.getLevel()));
                }
            }
        }
        return this.area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Rectangle tileRect = this.getTileRect(tileX, tileY);
        Area area_local = this.getArea();
        if (area_local.intersects(tileRect)) {
            return super.computeTile(tileX, tileY);
        }
        if (this.noDataRaster == null) {
            CellGridOpImage cellGridOpImage = this;
            synchronized (cellGridOpImage) {
                if (this.noDataRaster == null) {
                    this.noDataRaster = this.createNoDataRaster(this.noDataValue);
                }
            }
        }
        return this.noDataRaster.createTranslatedChild(this.tileXToX(tileX), this.tileYToY(tileY));
    }

    protected final void computeRect(PlanarImage[] planarImages, WritableRaster targetRaster, Rectangle rectangle) {
        PixelAccessor targetAccessor = new PixelAccessor(targetRaster.getSampleModel(), null);
        UnpackedImageData targetData = targetAccessor.getPixels((Raster)targetRaster, rectangle, targetRaster.getSampleModel().getTransferType(), true);
        PixelCounter pixelCounter = new PixelCounter(rectangle, this.getArea());
        switch (targetData.type) {
            case 0: {
                this.byteLoop(targetData, pixelCounter, (byte)this.noDataValue);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(targetData, pixelCounter, (short)this.noDataValue);
                break;
            }
            case 3: {
                this.intLoop(targetData, pixelCounter, (int)this.noDataValue);
                break;
            }
            case 4: {
                this.floatLoop(targetData, pixelCounter, (float)this.noDataValue);
                break;
            }
        }
        targetAccessor.setPixels(targetData);
    }

    private void byteLoop(UnpackedImageData targetData, PixelCounter pixelCounter, byte noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        byte[] targetDataArray = targetData.getByteData(0);
        long[] indexCache = new long[w];
        byte[] valueCache = new byte[w];
        int targetLineOffset = targetData.getOffset(0);
        AffineTransform i2m = this.model.getImageToModelTransform(this.getLevel());
        Point2D.Double point = new Point2D.Double();
        for (int y = 0; y < h; ++y) {
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
            }
            if (pixelCounter.valid > 0) {
                ((Point2D)point).setLocation(0.0, targetData.rect.y + y);
                i2m.transform(point, point);
                double lat = ((Point2D)point).getY();
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    ((Point2D)point).setLocation(targetData.rect.x + x, 0.0);
                    i2m.transform(point, point);
                    double lon = ((Point2D)point).getX();
                    long index = this.valueProvider.getCellIndex(lon, lat);
                    byte value = x > 0 && indexCache[x - 1] == index ? valueCache[x - 1] : (y > 0 && indexCache[x] == index ? valueCache[x] : (x + 1 < w && y > 0 && indexCache[x + 1] == index ? valueCache[x + 1] : (index != -1L ? this.valueProvider.getValue(index, noDataValue) : noDataValue)));
                    indexCache[x] = index;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            targetLineOffset += targetLineStride;
        }
    }

    private void shortLoop(UnpackedImageData targetData, PixelCounter pixelCounter, short noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        short[] targetDataArray = targetData.getShortData(0);
        long[] indexCache = new long[w];
        short[] valueCache = new short[w];
        int targetLineOffset = targetData.getOffset(0);
        AffineTransform i2m = this.model.getImageToModelTransform(this.getLevel());
        Point2D.Double point = new Point2D.Double();
        for (int y = 0; y < h; ++y) {
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
            }
            if (pixelCounter.valid > 0) {
                ((Point2D)point).setLocation(0.0, targetData.rect.y + y);
                i2m.transform(point, point);
                double lat = ((Point2D)point).getY();
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    ((Point2D)point).setLocation(targetData.rect.x + x, 0.0);
                    i2m.transform(point, point);
                    double lon = ((Point2D)point).getX();
                    long index = this.valueProvider.getCellIndex(lon, lat);
                    short value = x > 0 && indexCache[x - 1] == index ? valueCache[x - 1] : (y > 0 && indexCache[x] == index ? valueCache[x] : (x + 1 < w && y > 0 && indexCache[x + 1] == index ? valueCache[x + 1] : (index != -1L ? this.valueProvider.getValue(index, noDataValue) : noDataValue)));
                    indexCache[x] = index;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            targetLineOffset += targetLineStride;
        }
    }

    private void intLoop(UnpackedImageData targetData, PixelCounter pixelCounter, int noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        int[] targetDataArray = targetData.getIntData(0);
        long[] indexCache = new long[w];
        int[] valueCache = new int[w];
        int targetLineOffset = targetData.getOffset(0);
        AffineTransform i2m = this.model.getImageToModelTransform(this.getLevel());
        Point2D.Double point = new Point2D.Double();
        for (int y = 0; y < h; ++y) {
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
            }
            if (pixelCounter.valid > 0) {
                ((Point2D)point).setLocation(0.0, targetData.rect.y + y);
                i2m.transform(point, point);
                double lat = ((Point2D)point).getY();
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    ((Point2D)point).setLocation(targetData.rect.x + x, 0.0);
                    i2m.transform(point, point);
                    double lon = ((Point2D)point).getX();
                    long index = this.valueProvider.getCellIndex(lon, lat);
                    int value = x > 0 && indexCache[x - 1] == index ? valueCache[x - 1] : (y > 0 && indexCache[x] == index ? valueCache[x] : (x + 1 < w && y > 0 && indexCache[x + 1] == index ? valueCache[x + 1] : (index != -1L ? this.valueProvider.getValue(index, noDataValue) : noDataValue)));
                    indexCache[x] = index;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            targetLineOffset += targetLineStride;
        }
    }

    private void floatLoop(UnpackedImageData targetData, PixelCounter pixelCounter, float noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        float[] targetDataArray = targetData.getFloatData(0);
        long[] indexCache = new long[w];
        float[] valueCache = new float[w];
        int targetLineOffset = targetData.getOffset(0);
        AffineTransform i2m = this.model.getImageToModelTransform(this.getLevel());
        Point2D.Double point = new Point2D.Double();
        for (int y = 0; y < h; ++y) {
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
            }
            if (pixelCounter.valid > 0) {
                ((Point2D)point).setLocation(0.0, targetData.rect.y + y);
                i2m.transform(point, point);
                double lat = ((Point2D)point).getY();
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    ((Point2D)point).setLocation(targetData.rect.x + x, 0.0);
                    i2m.transform(point, point);
                    double lon = ((Point2D)point).getX();
                    long index = this.valueProvider.getCellIndex(lon, lat);
                    float value = x > 0 && indexCache[x - 1] == index ? valueCache[x - 1] : (y > 0 && indexCache[x] == index ? valueCache[x] : (x + 1 < w && y > 0 && indexCache[x + 1] == index ? valueCache[x + 1] : (index != -1L ? this.valueProvider.getValue(index, noDataValue) : noDataValue)));
                    indexCache[x] = index;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            targetLineOffset += targetLineStride;
        }
    }

    private static class PixelCounter {
        private final Rectangle effectiveBounds;
        private final Rectangle targetRectangle;
        private int leading;
        private int valid;
        private int trailing;

        PixelCounter(Rectangle targetRectangle, Area envelope) {
            Area effectiveEnvelope = new Area(targetRectangle);
            effectiveEnvelope.intersect(envelope);
            this.effectiveBounds = effectiveEnvelope.getBounds();
            this.targetRectangle = targetRectangle;
        }

        void countPixels(int y) {
            if (y < this.effectiveBounds.y || y > this.effectiveBounds.y + this.effectiveBounds.height) {
                this.leading = this.targetRectangle.width;
                this.valid = 0;
                this.trailing = 0;
            } else {
                this.leading = this.effectiveBounds.x - this.targetRectangle.x;
                this.valid = this.effectiveBounds.width;
                this.trailing = this.targetRectangle.width - this.leading - this.valid;
            }
        }
    }
}

