/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.swift;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.esa.snap.vfs.remote.AbstractRemoteWalker;
import org.esa.snap.vfs.remote.HttpUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.swift.SwiftResponseHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SwiftWalker
extends AbstractRemoteWalker {
    private String address;
    private String container;
    private String delimiter;
    private String root;

    SwiftWalker(String address, String container, String delimiter, String root, IRemoteConnectionBuilder remoteConnectionBuilder) {
        super(remoteConnectionBuilder);
        this.address = address;
        this.container = container;
        this.delimiter = delimiter;
        this.root = root;
    }

    private static void addParam(StringBuilder params, String name, String value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (params.length() > 0) {
            params.append("&");
        }
        params.append(name).append("=").append(URLEncoder.encode(value, "UTF8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<BasicFileAttributes> walk(VFSPath dir) throws IOException {
        SwiftResponseHandler handler;
        String dirPath;
        String swiftPrefix = this.buildPrefix(dirPath + ((dirPath = dir.toString()).endsWith("/") ? "" : "/"));
        String fileSystemRoot = dir.getFileSystem().getRoot().getPath();
        ArrayList<BasicFileAttributes> items = new ArrayList<BasicFileAttributes>();
        String marker = "";
        do {
            block18: {
                handler = new SwiftResponseHandler(this.root + this.delimiter + swiftPrefix, items, this.delimiter);
                String swiftURL = this.buildSwiftURL(swiftPrefix, marker);
                URL url = new URL(swiftURL);
                HttpURLConnection connection = this.remoteConnectionBuilder.buildConnection(fileSystemRoot, url, "GET", null);
                try {
                    int responseCode = connection.getResponseCode();
                    if (HttpUtils.isValidResponseCode(responseCode)) {
                        try (InputStream inputStream = connection.getInputStream();
                             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 10240);){
                            try {
                                SAXParserFactory spf = SAXParserFactory.newInstance();
                                spf.setNamespaceAware(true);
                                SAXParser saxParser = spf.newSAXParser();
                                XMLReader xmlReader = saxParser.getXMLReader();
                                xmlReader.setContentHandler(handler);
                                xmlReader.parse(new InputSource(bufferedInputStream));
                                break block18;
                            }
                            catch (ParserConfigurationException | SAXException ex) {
                                throw new IOException(ex);
                            }
                        }
                    }
                    Logger.getLogger(HttpUtils.class.getName()).warning("HTTP error response:");
                    Logger.getLogger(HttpUtils.class.getName()).warning(() -> {
                        try {
                            return IOUtils.toString((InputStream)connection.getErrorStream(), (String)"UTF-8").replaceAll("<AWSAccessKeyId>.*</AWSAccessKeyId>", "<AWSAccessKeyId>***</AWSAccessKeyId>");
                        }
                        catch (IOException iOException) {
                            return "";
                        }
                    });
                    throw new IOException(url.toString() + ": response code " + responseCode + ": " + connection.getResponseMessage());
                }
                finally {
                    connection.disconnect();
                }
            }
            marker = handler.getMarker();
        } while (handler.getIsTruncated());
        return items;
    }

    private String buildPrefix(String prefix) {
        prefix = prefix.replace(this.root, "");
        prefix = prefix.replaceAll("^/", "");
        return prefix;
    }

    private String buildSwiftURL(String prefix, String marker) throws IOException {
        String currentContainer = this.container;
        currentContainer = currentContainer != null && !currentContainer.isEmpty() ? currentContainer + this.delimiter : "";
        StringBuilder paramBase = new StringBuilder();
        SwiftWalker.addParam(paramBase, "format", "xml");
        SwiftWalker.addParam(paramBase, "limit", "1000");
        SwiftWalker.addParam(paramBase, "prefix", prefix);
        SwiftWalker.addParam(paramBase, "delimiter", this.delimiter);
        StringBuilder params = new StringBuilder(paramBase);
        SwiftWalker.addParam(params, "marker", marker);
        String swiftURL = this.address + (this.address.endsWith(this.delimiter) ? "" : this.delimiter) + currentContainer;
        if (params.length() > 0) {
            swiftURL = swiftURL + "?" + params;
        }
        return swiftURL;
    }
}

