/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.swift;

import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.vfs.remote.VFSFileAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SwiftResponseHandler
extends DefaultHandler {
    private static final String NAME_ELEMENT = "name";
    private static final String BYTES_ELEMENT = "bytes";
    private static final String OBJECT_ELEMENT = "object";
    private static final String LAST_MODIFIED_ELEMENT = "last_modified";
    private static final String SUBDIRECTORY_ELEMENT = "subdir";
    private static final String CONTAINER_ELEMENT = "container";
    private static Logger logger = Logger.getLogger(SwiftResponseHandler.class.getName());
    private LinkedList<String> elementStack = new LinkedList();
    private List<BasicFileAttributes> items;
    private String name;
    private long size;
    private String lastModified;
    private String marker;
    private boolean isTruncated;
    private String prefix;
    private String delimiter;

    SwiftResponseHandler(String prefix, List<BasicFileAttributes> items, String delimiter) {
        this.prefix = prefix;
        this.items = items;
        this.delimiter = delimiter;
    }

    private static String getTextValue(char[] ch, int start, int length) {
        return new String(ch, start, length).trim();
    }

    String getMarker() {
        return this.marker;
    }

    boolean getIsTruncated() {
        return this.isTruncated;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String currentElement = localName.intern();
            this.elementStack.addLast(currentElement);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to mark starting of the new XML element by adding it to the stack of XML elements, for OpenStack Swift VFS. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String currentElement = this.elementStack.removeLast();
            if (currentElement != null && currentElement.equals(localName)) {
                if (currentElement.equals(NAME_ELEMENT) && this.elementStack.size() == 2 && (this.elementStack.get(1).equals(SUBDIRECTORY_ELEMENT) || this.elementStack.get(1).equals(CONTAINER_ELEMENT)) && !this.prefix.endsWith(this.name)) {
                    this.items.add(VFSFileAttributes.newDir(this.prefix + this.name));
                    this.isTruncated = true;
                } else if (currentElement.equals(NAME_ELEMENT) && this.elementStack.size() == 2 && this.elementStack.get(1).equals(OBJECT_ELEMENT) && !this.prefix.endsWith(this.name)) {
                    this.items.add(VFSFileAttributes.newFile(this.prefix + this.name, this.size, this.lastModified));
                    this.isTruncated = true;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to add the new path of OpenStack Swift object to the list of OpenStack Swift VFS paths for files and directories. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String currentElement;
            switch (currentElement = this.elementStack.getLast()) {
                case "name": {
                    this.marker = SwiftResponseHandler.getTextValue(ch, start, length);
                    String[] nameParts = this.marker.split(this.delimiter);
                    this.name = this.marker.endsWith(this.delimiter) ? nameParts[nameParts.length - 1] + this.delimiter : nameParts[nameParts.length - 1];
                    break;
                }
                case "bytes": {
                    this.size = this.getLongValue(ch, start, length);
                    break;
                }
                case "last_modified": {
                    this.lastModified = SwiftResponseHandler.getTextValue(ch, start, length);
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to create the OpenStack Swift VFS path and file attributes. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    private long getLongValue(char[] ch, int start, int length) {
        return Long.parseLong(SwiftResponseHandler.getTextValue(ch, start, length));
    }
}

