/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.swift;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;
import org.esa.snap.vfs.remote.swift.SwiftFileSystem;
import org.esa.snap.vfs.remote.swift.SwiftFileSystemProviderHelper;
import org.esa.snap.vfs.remote.swift.SwiftWalker;

public final class SwiftFileSystemProvider
extends AbstractRemoteFileSystemProvider {
    private static final String SCHEME = "oss";
    private final Map<String, SwiftFileSystemProviderHelper> swiftFileSystemProviderList = new HashMap<String, SwiftFileSystemProviderHelper>();

    @Override
    public void setConnectionData(String fileSystemRoot, String serviceAddress, Map<String, ?> connectionData) {
        SwiftFileSystemProviderHelper swiftFileSystemProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        swiftFileSystemProviderHelper.setConnectionData(serviceAddress, connectionData);
    }

    @Override
    protected SwiftFileSystem newFileSystem(String fileSystemRoot, Map<String, ?> env) {
        return new SwiftFileSystem(this, fileSystemRoot);
    }

    @Override
    protected SwiftWalker newObjectStorageWalker(String fileSystemRoot) {
        SwiftFileSystemProviderHelper swiftFileSystemProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return swiftFileSystemProviderHelper.newObjectStorageWalker(this);
    }

    @Override
    public String getProviderAddress(String fileSystemRoot) {
        SwiftFileSystemProviderHelper swiftFileSystemProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return swiftFileSystemProviderHelper.getProviderAddress();
    }

    @Override
    public String getProviderFileSeparator(String fileSystemRoot) {
        SwiftFileSystemProviderHelper swiftFileSystemProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return swiftFileSystemProviderHelper.getProviderFileSeparator();
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    private SwiftFileSystemProviderHelper getProviderHelperOrCreate(String fileSystemRoot) {
        return this.swiftFileSystemProviderList.computeIfAbsent(fileSystemRoot, provider -> new SwiftFileSystemProviderHelper(fileSystemRoot));
    }

    @Override
    public HttpURLConnection buildConnection(String fileSystemRoot, URL url, String method, Map<String, String> requestProperties) throws IOException {
        SwiftFileSystemProviderHelper swiftFileSystemProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return swiftFileSystemProviderHelper.buildConnection(url, method, requestProperties);
    }
}

