/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.swift;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class SwiftAuthenticationV3 {
    private static final DateTimeFormatter ISO_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
    private static final String DOMAIN_NAME = "%domain%";
    private static final String PROJECT_ID_NAME = "%projectId%";
    private static final String USER_NAME = "%user%";
    private static final String CREDENTIAL_NAME = "%password%";
    private static final String API_REQUEST = "{\n    \"auth\": {\n        \"identity\": {\n            \"methods\": [\n                \"password\"\n            ],\n            \"password\": {\n                \"user\": {\n                    \"domain\": {\n                        \"name\": \"%domain%\"\n                    },\n                    \"name\": \"%user%\",\n                    \"password\": \"%password%\"\n                }\n            }\n        },\n        \"scope\": {\n            \"project\": {\n                \"id\": \"%projectId%\"\n            }\n        }\n    }\n}";
    private LocalDateTime expirationDate = null;
    private String authAddress;
    private String domain;
    private String projectId;
    private String user;
    private String password;
    private String authorizationToken;

    SwiftAuthenticationV3(String authAddress, String domain, String projectId, String user, String password) {
        this.authAddress = authAddress;
        this.domain = domain;
        this.projectId = projectId;
        this.user = user;
        this.password = password;
        this.authorizationToken = null;
    }

    boolean isValid() {
        return this.expirationDate != null && this.expirationDate.isAfter(LocalDateTime.now(ZoneOffset.UTC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestNewAuthorizationToken() {
        HttpURLConnection connection = null;
        try {
            URL authUrl = new URL(this.authAddress);
            connection = (HttpURLConnection)authUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("user-agent", "SNAP Virtual File System");
            try (OutputStream outputStream = connection.getOutputStream();
                 PrintWriter out = new PrintWriter(outputStream);){
                String apiRequest = API_REQUEST;
                apiRequest = apiRequest.replace(DOMAIN_NAME, this.domain);
                apiRequest = apiRequest.replace(PROJECT_ID_NAME, this.projectId);
                apiRequest = apiRequest.replace(USER_NAME, this.user);
                apiRequest = apiRequest.replace(CREDENTIAL_NAME, this.password);
                out.print(apiRequest);
                out.flush();
                if (connection.getResponseCode() == 201) {
                    String newAuthorizationToken = connection.getHeaderField("X-Subject-Token");
                    InputStreamReader inputStreamReader = new InputStreamReader(connection.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String result = bufferedReader.lines().collect(Collectors.joining("\n"));
                    String newExpirationDate = result.replaceAll("[\\s\\S]*\"expires_at\": \"(.*?)\",[\\s\\S]*", "$1");
                    this.expirationDate = LocalDateTime.parse(newExpirationDate, ISO_DATE_TIME);
                    this.expirationDate = this.expirationDate.minusMinutes(1L);
                    String string = newAuthorizationToken;
                    return string;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    String getAuthorizationToken() {
        if (this.domain == null || this.domain.isEmpty() || this.projectId == null || this.projectId.isEmpty() || this.user == null || this.user.isEmpty() || this.password == null || this.password.isEmpty()) {
            Logger.getLogger(SwiftAuthenticationV3.class.getName()).info("missing credentials (sa1)");
            return null;
        }
        if (!this.isValid()) {
            this.authorizationToken = this.requestNewAuthorizationToken();
        }
        Logger.getLogger(SwiftAuthenticationV3.class.getName()).info("authorizationToken=" + this.authorizationToken + " (sa2)");
        return this.authorizationToken;
    }
}

