/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.s3;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.esa.snap.vfs.remote.AbstractRemoteWalker;
import org.esa.snap.vfs.remote.HttpUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.s3.S3ResponseHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class S3Walker
extends AbstractRemoteWalker {
    private String address;
    private String bucket;
    private String delimiter;
    private String root;

    S3Walker(String address, String bucket, String delimiter, String root, IRemoteConnectionBuilder remoteConnectionBuilder) {
        super(remoteConnectionBuilder);
        this.address = address;
        this.bucket = bucket;
        this.delimiter = delimiter;
        this.root = root;
    }

    private static void addParam(StringBuilder params, String name, String value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (params.length() > 0) {
            params.append("&");
        }
        params.append(name).append("=").append(URLEncoder.encode(value, "UTF8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<BasicFileAttributes> walk(VFSPath dir) throws IOException {
        S3ResponseHandler handler;
        String dirPath;
        String s3Prefix = this.buildPrefix(dirPath + ((dirPath = dir.toString()).endsWith("/") ? "" : "/"));
        String fileSystemRoot = dir.getFileSystem().getRoot().getPath();
        ArrayList<BasicFileAttributes> items = new ArrayList<BasicFileAttributes>();
        String nextContinuationToken = "";
        do {
            block18: {
                handler = new S3ResponseHandler(this.root + this.delimiter + s3Prefix, items, this.delimiter);
                String s3URL = this.buildS3URL(s3Prefix, nextContinuationToken);
                URL url = new URL(s3URL);
                HttpURLConnection connection = this.remoteConnectionBuilder.buildConnection(fileSystemRoot, url, "GET", null);
                try {
                    int responseCode = connection.getResponseCode();
                    if (HttpUtils.isValidResponseCode(responseCode)) {
                        try (InputStream inputStream = connection.getInputStream();
                             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 10240);){
                            try {
                                SAXParserFactory spf = SAXParserFactory.newInstance();
                                spf.setNamespaceAware(true);
                                SAXParser saxParser = spf.newSAXParser();
                                XMLReader xmlReader = saxParser.getXMLReader();
                                xmlReader.setContentHandler(handler);
                                xmlReader.parse(new InputSource(bufferedInputStream));
                                break block18;
                            }
                            catch (ParserConfigurationException | SAXException ex) {
                                throw new IOException(ex);
                            }
                        }
                    }
                    Logger.getLogger(HttpUtils.class.getName()).warning("HTTP error response:");
                    Logger.getLogger(HttpUtils.class.getName()).warning(() -> {
                        try {
                            return IOUtils.toString((InputStream)connection.getErrorStream(), (String)"UTF-8").replaceAll("<AWSAccessKeyId>.*</AWSAccessKeyId>", "<AWSAccessKeyId>***</AWSAccessKeyId>");
                        }
                        catch (IOException iOException) {
                            return "";
                        }
                    });
                    throw new IOException(url.toString() + ": response code " + responseCode + ": " + connection.getResponseMessage());
                }
                finally {
                    connection.disconnect();
                }
            }
            nextContinuationToken = handler.getNextContinuationToken();
        } while (handler.getIsTruncated());
        return items;
    }

    private String buildPrefix(String prefix) {
        prefix = prefix.replace(this.root, "");
        prefix = prefix.replaceAll("^/", "");
        return prefix;
    }

    private String buildS3URL(String prefix, String nextContinuationToken) throws IOException {
        String currentBucket = this.bucket;
        currentBucket = currentBucket != null && !currentBucket.isEmpty() ? currentBucket + this.delimiter : "";
        StringBuilder paramBase = new StringBuilder();
        S3Walker.addParam(paramBase, "prefix", prefix);
        S3Walker.addParam(paramBase, "delimiter", this.delimiter);
        StringBuilder params = new StringBuilder(paramBase);
        S3Walker.addParam(params, "continuation-token", nextContinuationToken);
        String s3URL = this.address + (this.address.endsWith(this.delimiter) ? "" : this.delimiter) + currentBucket;
        if (params.length() > 0) {
            s3URL = s3URL + "?" + params;
        }
        return s3URL;
    }
}

