/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.s3;

import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.vfs.remote.VFSFileAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class S3ResponseHandler
extends DefaultHandler {
    private static final String KEY_ELEMENT = "Key";
    private static final String SIZE_ELEMENT = "Size";
    private static final String CONTENTS_ELEMENT = "Contents";
    private static final String LAST_MODIFIED_ELEMENT = "LastModified";
    private static final String NEXT_CONTINUATION_TOKEN_ELEMENT = "NextContinuationToken";
    private static final String IS_TRUNCATED_ELEMENT = "IsTruncated";
    private static final String COMMON_PREFIXES_ELEMENT = "CommonPrefixes";
    private static final String PREFIX_ELEMENT = "Prefix";
    private static Logger logger = Logger.getLogger(S3ResponseHandler.class.getName());
    private LinkedList<String> elementStack = new LinkedList();
    private List<BasicFileAttributes> items;
    private String key;
    private long size;
    private String lastModified;
    private String nextContinuationToken;
    private boolean isTruncated;
    private String prefix;
    private String delimiter;

    S3ResponseHandler(String prefix, List<BasicFileAttributes> items, String delimiter) {
        this.prefix = prefix;
        this.items = items;
        this.delimiter = delimiter;
    }

    private static String getTextValue(char[] ch, int start, int length) {
        return new String(ch, start, length).trim();
    }

    String getNextContinuationToken() {
        return this.nextContinuationToken;
    }

    boolean getIsTruncated() {
        return this.isTruncated;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String currentElement = localName.intern();
            this.elementStack.addLast(currentElement);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to mark starting of the new XML element by adding it to the stack of XML elements, for S3 VFS. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String currentElement = this.elementStack.removeLast();
            if (currentElement != null && currentElement.equals(localName)) {
                if (currentElement.equals(PREFIX_ELEMENT) && this.elementStack.size() == 2 && this.elementStack.get(1).equals(COMMON_PREFIXES_ELEMENT)) {
                    this.items.add(VFSFileAttributes.newDir(this.prefix + this.key));
                } else if (currentElement.equals(CONTENTS_ELEMENT) && this.elementStack.size() == 1) {
                    this.items.add(VFSFileAttributes.newFile(this.prefix + this.key, this.size, this.lastModified));
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to add the new path of S3 object to the list of S3 VFS paths for files and directories. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String currentElement;
            switch (currentElement = this.elementStack.getLast()) {
                case "Key": {
                    this.key = S3ResponseHandler.getTextValue(ch, start, length);
                    String[] keyParts = this.key.split(this.delimiter);
                    this.key = this.key.endsWith(this.delimiter) ? keyParts[keyParts.length - 1] + this.delimiter : keyParts[keyParts.length - 1];
                    break;
                }
                case "Size": {
                    this.size = this.getLongValue(ch, start, length);
                    break;
                }
                case "LastModified": {
                    this.lastModified = S3ResponseHandler.getTextValue(ch, start, length);
                    break;
                }
                case "IsTruncated": {
                    this.isTruncated = this.getBooleanValue(ch, start, length);
                    break;
                }
                case "NextContinuationToken": {
                    this.nextContinuationToken = S3ResponseHandler.getTextValue(ch, start, length);
                    break;
                }
                case "Prefix": {
                    this.key = S3ResponseHandler.getTextValue(ch, start, length);
                    String[] keyParts = this.key.split(this.delimiter);
                    this.key = this.key.endsWith(this.delimiter) ? keyParts[keyParts.length - 1] + this.delimiter : keyParts[keyParts.length - 1];
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to create the S3 VFS path and file attributes. Details: " + ex.getMessage());
            throw new SAXException(ex);
        }
    }

    private boolean getBooleanValue(char[] ch, int start, int length) {
        return Boolean.parseBoolean(S3ResponseHandler.getTextValue(ch, start, length));
    }

    private long getLongValue(char[] ch, int start, int length) {
        return Long.parseLong(S3ResponseHandler.getTextValue(ch, start, length));
    }
}

