/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.s3;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;
import org.esa.snap.vfs.remote.VFSWalker;
import org.esa.snap.vfs.remote.s3.S3FileSystem;
import org.esa.snap.vfs.remote.s3.S3FileSystemProviderHelper;

public final class S3FileSystemProvider
extends AbstractRemoteFileSystemProvider {
    private static final String SCHEME = "s3";
    private final Map<String, S3FileSystemProviderHelper> s3FileSystemProviderList = new HashMap<String, S3FileSystemProviderHelper>();

    @Override
    public void setConnectionData(String fileSystemRoot, String serviceAddress, Map<String, ?> connectionData) {
        S3FileSystemProviderHelper s3ProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        s3ProviderHelper.setConnectionData(serviceAddress, connectionData);
    }

    @Override
    protected S3FileSystem newFileSystem(String fileSystemRoot, Map<String, ?> env) {
        return new S3FileSystem(this, fileSystemRoot);
    }

    @Override
    protected VFSWalker newObjectStorageWalker(String fileSystemRoot) {
        S3FileSystemProviderHelper s3ProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return s3ProviderHelper.newObjectStorageWalker(this);
    }

    @Override
    public String getProviderAddress(String fileSystemRoot) {
        S3FileSystemProviderHelper s3ProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return s3ProviderHelper.getProviderAddress();
    }

    @Override
    public String getProviderFileSeparator(String fileSystemRoot) {
        S3FileSystemProviderHelper s3ProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return s3ProviderHelper.getProviderFileSeparator();
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    private S3FileSystemProviderHelper getProviderHelperOrCreate(String fileSystemRoot) {
        return this.s3FileSystemProviderList.computeIfAbsent(fileSystemRoot, provider -> new S3FileSystemProviderHelper(fileSystemRoot));
    }

    @Override
    public HttpURLConnection buildConnection(String fileSystemRoot, URL url, String method, Map<String, String> requestProperties) throws IOException {
        S3FileSystemProviderHelper s3ProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return s3ProviderHelper.buildConnection(url, method, requestProperties);
    }
}

