/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.http;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.vfs.NioPaths;
import org.esa.snap.vfs.remote.AbstractRemoteWalker;
import org.esa.snap.vfs.remote.HttpUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.VFSFileAttributes;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.http.RegularFileMetadataCallback;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class HttpWalker
extends AbstractRemoteWalker {
    private final String address;
    private final String delimiter;
    private final String root;
    private final String servicePath;

    HttpWalker(String address, String delimiter, String root, IRemoteConnectionBuilder remoteConnectionBuilder) {
        super(remoteConnectionBuilder);
        this.address = address;
        this.delimiter = delimiter;
        this.root = root;
        this.servicePath = address.replaceAll(".*//.*?(" + delimiter + ".*)", "$1");
    }

    @Override
    public synchronized List<BasicFileAttributes> walk(VFSPath dir) throws IOException {
        StringBuilder urlAsString = new StringBuilder();
        if (this.address.endsWith(this.delimiter)) {
            int endIndex = this.address.length() - this.delimiter.length();
            urlAsString.append(this.address, 0, endIndex);
        } else {
            urlAsString.append(this.address);
        }
        Object dirPathAsString = dir.toString();
        String urlPathAsString = dirPathAsString;
        if (urlPathAsString.startsWith(this.root)) {
            urlPathAsString = urlPathAsString.substring(this.root.length());
        }
        if (!urlPathAsString.startsWith(this.delimiter)) {
            urlAsString.append(this.delimiter);
        }
        urlAsString.append(urlPathAsString);
        String urlAddress = urlAsString.toString();
        String htmlResponse = HttpUtils.readResponse(urlAddress, this.remoteConnectionBuilder, this.root);
        Document document = Jsoup.parse((String)htmlResponse, (String)urlAddress);
        if (!((String)dirPathAsString).endsWith(this.delimiter)) {
            dirPathAsString = (String)dirPathAsString + this.delimiter;
        }
        return this.parseElements(document, (String)dirPathAsString);
    }

    private List<BasicFileAttributes> parseElements(Document document, String prefix) {
        LinkedHashSet<BasicFileAttributes> items = new LinkedHashSet<BasicFileAttributes>();
        Pattern p = Pattern.compile("<a href=\"(.*?)\">.*?</a>");
        Elements htmlTables = document.select("table");
        if (htmlTables.isEmpty() || htmlTables.size() > 1) {
            throw new IllegalArgumentException("Unsupported HTTP VFS service.\nReason: invalid/unknown VFS structure.");
        }
        Element htmlTable = htmlTables.first();
        Matcher m = p.matcher(htmlTable.html());
        boolean externalDirs = false;
        while (m.find()) {
            String filePath;
            String fileUrl;
            String name = m.group(1);
            if (!(name = name.replaceAll("^" + this.servicePath, "")).startsWith(this.delimiter)) {
                name = this.delimiter.concat(name);
            }
            String parent = prefix.replaceAll("^" + this.root, "");
            if (name.isEmpty() || name.contains("?") || name.contains("#") || name.equals("/") || !this.isValidPath(name, prefix)) continue;
            if (!parent.contentEquals(name)) {
                name = name.replaceAll("^" + parent, "");
            }
            if ((name = name.replaceAll("^/", "")).endsWith("/")) {
                if (name.startsWith("http://") || name.startsWith("https://")) {
                    externalDirs = true;
                    continue;
                }
                items.add(VFSFileAttributes.newDir(prefix + name));
                continue;
            }
            if (name.startsWith("http://") || name.startsWith("https://")) {
                fileUrl = name;
                name = name.replaceAll(".*/(.*)", "$1");
                filePath = prefix.concat(name);
            } else {
                String filePathUrl;
                fileUrl = this.address;
                if (name.contains("/")) {
                    filePathUrl = name = name.startsWith("/") ? name.substring(1) : name;
                    name = name.replaceAll(".*/(.*)", "$1");
                    filePath = prefix.concat(name);
                } else {
                    filePath = prefix.concat(name);
                    filePathUrl = filePath.replaceAll(this.root + "/?", "");
                }
                if (!fileUrl.endsWith("/")) {
                    fileUrl = fileUrl.concat("/");
                }
                fileUrl = fileUrl.concat(filePathUrl);
            }
            RegularFileMetadataCallback fileSizeQueryCallback = new RegularFileMetadataCallback(fileUrl, this.remoteConnectionBuilder, this.root);
            BasicFileAttributes regularFileAttributes = VFSFileAttributes.newFile(filePath, fileSizeQueryCallback);
            items.add(regularFileAttributes);
        }
        if (externalDirs && items.isEmpty()) {
            throw new IllegalArgumentException("Unsupported HTTP VFS service.\nReason: External directories unsupported. ");
        }
        return new ArrayList<BasicFileAttributes>(items);
    }

    private boolean isValidPath(String target, String current) {
        if (target != null && !target.isEmpty() && current != null && !current.isEmpty()) {
            Path currentPath = NioPaths.get(current, new String[0]);
            Path parentPath = currentPath.getParent();
            if (parentPath != null) {
                Object parent = parentPath.toString();
                if (target.endsWith(this.delimiter)) {
                    parent = (String)parent + this.delimiter;
                }
                if (((String)parent).endsWith(target)) {
                    Path newPath = currentPath.resolve(target);
                    return Files.exists(newPath, new LinkOption[0]);
                }
            }
            return true;
        }
        return false;
    }
}

