/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.VFSWalker;
import org.esa.snap.vfs.remote.http.HttpWalker;

public class HttpFileSystemProviderHelper {
    private static final String DELIMITER_PROPERTY_DEFAULT_VALUE = "/";
    private static final String USERNAME_PROPERTY_NAME = "username";
    private static final String CREDENTIAL_PROPERTY_NAME = "password";
    private String fileSystemRoot;
    private String address;
    private String username;
    private String password;
    private String delimiter;
    private String authorizationToken;

    HttpFileSystemProviderHelper(String fileSystemRoot) {
        this.fileSystemRoot = fileSystemRoot;
        this.address = "";
        this.username = "";
        this.password = "";
        this.delimiter = DELIMITER_PROPERTY_DEFAULT_VALUE;
    }

    private static String getAuthorizationToken(String username, String password) {
        return !StringUtils.isNotNullAndNotEmpty((String)username) && !StringUtils.isNotNullAndNotEmpty((String)password) ? Base64.getEncoder().encodeToString((username + ":" + password).getBytes()) : "";
    }

    private static HttpURLConnection buildConnection(URL url, String method, Map<String, String> requestProperties, String authorizationToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        if (method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("DELETE")) {
            connection.setDoOutput(true);
        }
        connection.setRequestProperty("accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        if (authorizationToken != null && !authorizationToken.isEmpty()) {
            connection.setRequestProperty("authorization", "Basic " + authorizationToken);
        }
        if (requestProperties != null && requestProperties.size() > 0) {
            Set<Map.Entry<String, String>> requestPropertiesSet = requestProperties.entrySet();
            for (Map.Entry<String, String> requestProperty : requestPropertiesSet) {
                connection.setRequestProperty(requestProperty.getKey(), requestProperty.getValue());
            }
        }
        connection.setRequestProperty("user-agent", "SNAP Virtual File System");
        return connection;
    }

    private void setupConnectionData(String address, String username, String password) {
        this.address = address != null ? address : this.address;
        this.username = username != null ? username : this.address;
        this.password = password != null ? password : this.address;
    }

    public void setConnectionData(String serviceAddress, Map<String, ?> connectionData) {
        String newUsername = (String)connectionData.get(USERNAME_PROPERTY_NAME);
        String newCredential = (String)connectionData.get(CREDENTIAL_PROPERTY_NAME);
        this.setupConnectionData(serviceAddress, newUsername, newCredential);
    }

    VFSWalker newObjectStorageWalker(IRemoteConnectionBuilder remoteConnectionBuilder) {
        return new HttpWalker(this.address, this.delimiter, this.fileSystemRoot, remoteConnectionBuilder);
    }

    String getProviderAddress() {
        return this.address;
    }

    String getProviderFileSeparator() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection buildConnection(URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpFileSystemProviderHelper httpFileSystemProviderHelper = this;
        synchronized (httpFileSystemProviderHelper) {
            if (this.authorizationToken == null) {
                this.authorizationToken = HttpFileSystemProviderHelper.getAuthorizationToken(this.username, this.password);
                if (this.authorizationToken == null) {
                    this.authorizationToken = "";
                }
            }
        }
        return HttpFileSystemProviderHelper.buildConnection(url, method, requestProperties, this.authorizationToken);
    }
}

