/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;
import org.esa.snap.vfs.remote.VFSWalker;
import org.esa.snap.vfs.remote.http.HttpFileSystem;
import org.esa.snap.vfs.remote.http.HttpFileSystemProviderHelper;

public final class HttpFileSystemProvider
extends AbstractRemoteFileSystemProvider {
    private static final String SCHEME = "http";
    private final Map<String, HttpFileSystemProviderHelper> httpFileSystemProviderList = new HashMap<String, HttpFileSystemProviderHelper>();

    @Override
    public void setConnectionData(String fileSystemRoot, String serviceAddress, Map<String, ?> connectionData) {
        HttpFileSystemProviderHelper httpProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        httpProviderHelper.setConnectionData(serviceAddress, connectionData);
    }

    @Override
    protected HttpFileSystem newFileSystem(String fileSystemRoot, Map<String, ?> env) {
        return new HttpFileSystem(this, fileSystemRoot);
    }

    @Override
    protected final VFSWalker newObjectStorageWalker(String fileSystemRoot) {
        HttpFileSystemProviderHelper httpProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return httpProviderHelper.newObjectStorageWalker(this);
    }

    @Override
    public String getProviderAddress(String fileSystemRoot) {
        HttpFileSystemProviderHelper httpProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return httpProviderHelper.getProviderAddress();
    }

    @Override
    public String getProviderFileSeparator(String fileSystemRoot) {
        HttpFileSystemProviderHelper httpProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return httpProviderHelper.getProviderFileSeparator();
    }

    @Override
    public final String getScheme() {
        return SCHEME;
    }

    private HttpFileSystemProviderHelper getProviderHelperOrCreate(String fileSystemRoot) {
        return this.httpFileSystemProviderList.computeIfAbsent(fileSystemRoot, provider -> new HttpFileSystemProviderHelper(fileSystemRoot));
    }

    @Override
    public HttpURLConnection buildConnection(String fileSystemRoot, URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpFileSystemProviderHelper httpProviderHelper = this.getProviderHelperOrCreate(fileSystemRoot);
        return httpProviderHelper.buildConnection(url, method, requestProperties);
    }
}

