/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.esa.snap.vfs.NioFile;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystem;
import org.esa.snap.vfs.remote.VFSFileAttributes;

public class VFSPath
implements Path {
    private static final String OTHER_MISSING_ERROR_MESSAGE = "other is missing.";
    private final AbstractRemoteFileSystem fileSystem;
    private final boolean absolute;
    private final String path;
    private final String[] names;
    private BasicFileAttributes fileAttributes;

    VFSPath(AbstractRemoteFileSystem fileSystem, boolean absolute, String path, BasicFileAttributes fileAttributes) {
        if (fileSystem == null) {
            throw new NullPointerException("The filesystem is null.");
        }
        if (path == null) {
            throw new NullPointerException("The path is null.");
        }
        this.fileSystem = fileSystem;
        this.absolute = absolute;
        String tempPath = VFSPath.replaceFileSeparator(path, this.fileSystem.getSeparator());
        if (tempPath.endsWith(this.fileSystem.getSeparator())) {
            int lastIndex = tempPath.length() - this.fileSystem.getSeparator().length();
            tempPath = tempPath.substring(0, lastIndex);
        }
        this.path = tempPath;
        this.fileAttributes = fileAttributes;
        this.names = this.path.isEmpty() ? new String[0] : path.split(this.fileSystem.getSeparator());
    }

    public static VFSPath toRemotePath(Object path) {
        if (path == null) {
            throw new NullPointerException("The path is null.");
        }
        if (path instanceof VFSPath) {
            return (VFSPath)path;
        }
        throw new ProviderMismatchException("The path type '" + path.getClass().getName() + "' is incorrect. The allowed type is '" + VFSPath.class.getName() + "'.");
    }

    static VFSPath fromFileAttributes(AbstractRemoteFileSystem fileSystem, BasicFileAttributes fileAttributes) {
        String rootPathAsString = fileSystem.getRoot().getPath();
        String pathName = fileAttributes.fileKey().toString();
        if (pathName.equals(rootPathAsString)) {
            Class<?> rootFileAttributesType = fileSystem.getRoot().getFileAttributes().getClass();
            if (fileAttributes.getClass().equals(rootFileAttributesType)) {
                return fileSystem.getRoot();
            }
            throw new IllegalArgumentException("The file attributes type '" + fileAttributes.getClass().getName() + "' does not match with the file system root type '" + rootFileAttributesType + "'.");
        }
        boolean absolute = pathName.startsWith(rootPathAsString);
        return new VFSPath(fileSystem, absolute, pathName, fileAttributes);
    }

    static VFSPath parsePath(AbstractRemoteFileSystem fileSystem, String pathName) {
        String rootPathAsString = fileSystem.getRoot().getPath();
        if (pathName.equals(rootPathAsString)) {
            return fileSystem.getRoot();
        }
        boolean absolute = pathName.startsWith(rootPathAsString);
        return new VFSPath(fileSystem, absolute, pathName, null);
    }

    private static String buildPath(String parentPath, String childPath, String fileSystemSeparator) {
        StringBuilder pathAsString = new StringBuilder();
        if (parentPath.endsWith(fileSystemSeparator)) {
            int endIndex = parentPath.length() - fileSystemSeparator.length();
            pathAsString.append(parentPath, 0, endIndex);
        } else {
            pathAsString.append(parentPath);
        }
        if (!childPath.startsWith(fileSystemSeparator)) {
            pathAsString.append(fileSystemSeparator);
        }
        pathAsString.append(childPath);
        return pathAsString.toString();
    }

    private static String replaceFileSeparator(String path, String fileSystemSeparator) {
        return path.replace("\\", fileSystemSeparator).replace("/", fileSystemSeparator);
    }

    public String getPath() {
        return this.path;
    }

    URL buildURL() throws MalformedURLException {
        String urlAsString = null;
        if (this.fileAttributes instanceof VFSFileAttributes) {
            VFSFileAttributes vfsFileAttributes = (VFSFileAttributes)this.fileAttributes;
            urlAsString = vfsFileAttributes.fileURL();
        }
        if (urlAsString == null) {
            String fileSystemRootAsString = this.fileSystem.getRoot().getPath();
            String providerAddress = this.fileSystem.provider().getProviderAddress(fileSystemRootAsString);
            String fileSystemSeparator = this.fileSystem.getSeparator();
            String pathAsString = this.path;
            if (pathAsString.startsWith(fileSystemRootAsString)) {
                pathAsString = pathAsString.substring(fileSystemRootAsString.length());
            }
            urlAsString = VFSPath.buildPath(providerAddress, pathAsString, fileSystemSeparator);
        }
        return new URL(urlAsString.replaceAll(" ", "%20"));
    }

    private String[] getNames() {
        return this.names;
    }

    private VFSPath parsePath(String pathName) {
        return VFSPath.parsePath(this.fileSystem, pathName);
    }

    @Override
    public AbstractRemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    BasicFileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    void setFileAttributes(BasicFileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    @Override
    public Path getRoot() {
        return this.isAbsolute() ? this.fileSystem.getRoot() : null;
    }

    @Override
    public Path getFileName() {
        int nameCount = this.getNameCount();
        if (nameCount == 0) {
            return null;
        }
        String name = this.getNames()[nameCount - 1];
        return new VFSPath(this.fileSystem, false, name, null);
    }

    @Override
    public Path getParent() {
        int nameCount = this.getNameCount();
        if (nameCount <= 1) {
            return null;
        }
        return this.subpath(0, nameCount - 1);
    }

    @Override
    public int getNameCount() {
        return this.getNames().length;
    }

    @Override
    public Path getName(int index) {
        return new VFSPath(this.fileSystem, false, this.getNames()[index], null);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        CharSequence[] subPath = Arrays.copyOfRange(this.names, beginIndex, endIndex);
        String subPathName = String.join((CharSequence)this.fileSystem.getSeparator(), subPath);
        return new VFSPath(this.fileSystem, beginIndex == 0 && this.absolute, subPathName, null);
    }

    @Override
    public boolean startsWith(Path other) {
        VFSPath remotePath = VFSPath.toRemotePath(other);
        return this.path.startsWith(remotePath.path);
    }

    @Override
    public boolean startsWith(String other) {
        if (other == null) {
            throw new NullPointerException(OTHER_MISSING_ERROR_MESSAGE);
        }
        return this.startsWith(this.parsePath(other));
    }

    @Override
    public boolean endsWith(Path other) {
        VFSPath remotePath = VFSPath.toRemotePath(other);
        return this.path.endsWith(remotePath.path);
    }

    @Override
    public boolean endsWith(String other) {
        if (other == null) {
            throw new NullPointerException(OTHER_MISSING_ERROR_MESSAGE);
        }
        return this.endsWith(this.parsePath(other));
    }

    @Override
    public Path normalize() {
        String separator = this.fileSystem.getSeparator();
        String currentDirectory = ".";
        String parentDirectory = "..";
        ArrayList<String> pathFrames = new ArrayList<String>(Arrays.asList(this.names));
        for (int pathFrameIndex = 0; pathFrameIndex < pathFrames.size(); ++pathFrameIndex) {
            String currentPathFrame = (String)pathFrames.get(pathFrameIndex);
            if (currentPathFrame.equals(currentDirectory)) {
                pathFrames.remove(pathFrameIndex);
                --pathFrameIndex;
                continue;
            }
            if (!currentPathFrame.equals(parentDirectory)) continue;
            if (pathFrameIndex > 0) {
                pathFrames.remove(pathFrameIndex);
                pathFrames.remove(pathFrameIndex - 1);
                pathFrameIndex -= 2;
                continue;
            }
            throw new IllegalStateException("The path: " + this.path + " invalid. It cannot contains '" + parentDirectory + "' on the first position.");
        }
        StringBuilder normalizedPath = new StringBuilder();
        for (int i = 0; i < pathFrames.size(); ++i) {
            if (i > 0) {
                normalizedPath.append(separator);
            }
            normalizedPath.append((String)pathFrames.get(i));
        }
        return this.parsePath(normalizedPath.toString());
    }

    private boolean isEmpty() {
        return this.path.length() == 0;
    }

    @Override
    public Path resolve(Path other) {
        VFSPath remotePath = VFSPath.toRemotePath(other);
        if (remotePath.isEmpty()) {
            return this;
        }
        if (remotePath.isAbsolute()) {
            return remotePath;
        }
        String fileSeparator = this.fileSystem.getSeparator();
        String pathName = VFSPath.buildPath(this.path, remotePath.path, fileSeparator);
        return this.parsePath(pathName);
    }

    @Override
    public Path resolve(String other) {
        if (other == null) {
            throw new NullPointerException(OTHER_MISSING_ERROR_MESSAGE);
        }
        return this.resolve(this.parsePath(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        VFSPath remotePath = VFSPath.toRemotePath(other);
        if (remotePath.toString().isEmpty()) {
            return this;
        }
        Path parent = this.getParent();
        if (parent == null || remotePath.isAbsolute()) {
            return remotePath;
        }
        return parent.resolve(remotePath);
    }

    @Override
    public Path resolveSibling(String other) {
        if (other == null) {
            throw new NullPointerException(OTHER_MISSING_ERROR_MESSAGE);
        }
        return this.resolveSibling(this.parsePath(other));
    }

    @Override
    public Path relativize(Path other) {
        VFSPath remotePath = VFSPath.toRemotePath(other);
        if (this.isAbsolute() != remotePath.isAbsolute()) {
            throw new IllegalArgumentException(OTHER_MISSING_ERROR_MESSAGE);
        }
        String[] names1 = this.getNames();
        String[] names2 = remotePath.getNames();
        for (int i = 0; i < names1.length; ++i) {
            if (i < names2.length && names1[i].equals(names2[i])) continue;
            return remotePath;
        }
        return remotePath.subpath(names1.length, remotePath.getNameCount());
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider().getScheme(), this.path, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        throw new IllegalStateException("The path '" + this.path + "' cannot be converted as an absolute path.");
    }

    @Override
    public Path toRealPath(LinkOption ... options) {
        return this.toAbsolutePath();
    }

    @Override
    public File toFile() {
        return new NioFile(this);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        ArrayList<Path> list = new ArrayList<Path>();
        int nameCount = this.getNameCount();
        for (int i = 0; i < nameCount; ++i) {
            list.add(this.getName(i));
        }
        return list.iterator();
    }

    @Override
    public int compareTo(Path other) {
        String name2;
        VFSPath remotePath = VFSPath.toRemotePath(other);
        int n = Math.min(this.getNameCount(), remotePath.getNameCount());
        for (int i = 0; i < n; ++i) {
            String name22;
            String name1 = this.getNames()[i];
            int delta = name1.compareTo(name22 = remotePath.getNames()[i]);
            if (delta == 0) continue;
            return delta;
        }
        String name1 = n < this.getNameCount() ? this.getNames()[n] : null;
        String string = name2 = n < remotePath.getNameCount() ? remotePath.getNames()[n] : null;
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 != null) {
            return name1.compareTo("");
        }
        return "".compareTo(name2);
    }

    @Override
    public String toString() {
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VFSPath)) {
            return false;
        }
        VFSPath other = VFSPath.toRemotePath(o);
        return this.absolute == other.absolute && this.fileSystem == other.fileSystem && this.path.equals(other.path);
    }

    @Override
    public int hashCode() {
        int result = this.fileSystem.hashCode();
        result = 31 * result + (this.absolute ? 1 : 0);
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

