/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;
import org.esa.snap.vfs.remote.HttpUtils;
import org.esa.snap.vfs.remote.VFSByteChannel;
import org.esa.snap.vfs.remote.VFSPath;

public class VFSFileChannel
extends FileChannel {
    private static final String NEGATIVE_POSITION_ERROR_MESSAGE = "position must be non-negative.";
    private final VFSByteChannel byteChannel;
    private final VFSPath path;
    private final Set<? extends OpenOption> options;
    private final FileAttribute<?>[] attrs;

    VFSFileChannel(VFSPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        AbstractRemoteFileSystemProvider fileSystemProvider = path.getFileSystem().provider();
        this.byteChannel = fileSystemProvider.newByteChannel((Path)path, (Set)options, (FileAttribute[])attrs);
        this.path = path;
        this.options = options;
        this.attrs = attrs;
    }

    static HttpURLConnection buildProviderConnectionChannel(VFSPath path, long position, String httpMethod) throws IOException {
        URL url = path.buildURL();
        LinkedHashMap<String, String> requestProperties = new LinkedHashMap<String, String>();
        String rangeSpec = "bytes=" + position + "-";
        requestProperties.put("Range", rangeSpec);
        AbstractRemoteFileSystemProvider fileSystemProvider = path.getFileSystem().provider();
        String fileSystemRoot = path.getFileSystem().getRoot().getPath();
        boolean success = true;
        HttpURLConnection connection = fileSystemProvider.buildConnection(fileSystemRoot, url, httpMethod, requestProperties);
        try {
            int responseCode = connection.getResponseCode();
            if (HttpUtils.isValidResponseCode(responseCode)) {
                HttpURLConnection httpURLConnection = connection;
                return httpURLConnection;
            }
            success = false;
            Logger.getLogger(HttpUtils.class.getName()).warning("HTTP error response:");
            Logger.getLogger(HttpUtils.class.getName()).warning(() -> {
                try {
                    return IOUtils.toString((InputStream)connection.getErrorStream(), (String)"UTF-8").replaceAll("<AWSAccessKeyId>.*</AWSAccessKeyId>", "<AWSAccessKeyId>***</AWSAccessKeyId>");
                }
                catch (IOException iOException) {
                    return "";
                }
            });
            throw new IOException(url.toString() + ": response code " + responseCode + ": " + connection.getResponseMessage());
        }
        finally {
            if (!success) {
                connection.disconnect();
            }
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.byteChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.byteChannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.byteChannel.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.byteChannel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.byteChannel.size();
    }

    @Override
    public FileChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force(boolean metaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long bytesTransferred;
        if (position < 0L) {
            throw new IllegalArgumentException(NEGATIVE_POSITION_ERROR_MESSAGE);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count must be non-negative.");
        }
        int maximumBufferSize = 0x100000;
        if (target instanceof FileChannel) {
            FileChannel fileChannel = (FileChannel)target;
            for (bytesTransferred = 0L; bytesTransferred < count; bytesTransferred += this.transferToFileChannel(position + bytesTransferred, maximumBufferSize, fileChannel)) {
            }
        } else {
            while (bytesTransferred < count) {
                bytesTransferred += this.transferToByteChannel(position + bytesTransferred, maximumBufferSize, target);
            }
        }
        return bytesTransferred;
    }

    /*
     * Exception decompiling
     */
    private long transferToByteChannel(long position, int maximumBufferSize, WritableByteChannel destinationByteChannel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long transferToFileChannel(long position, int maximumBufferSize, FileChannel destinationFileChannel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        long bytesTransferred;
        if (position < 0L) {
            throw new IllegalArgumentException(NEGATIVE_POSITION_ERROR_MESSAGE);
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count must be non-negative.");
        }
        try (SeekableByteChannel dstByteChannel = this.path.getFileSystem().provider().newByteChannel((Path)this.path, (Set)this.options, (FileAttribute[])this.attrs);){
            if (position > dstByteChannel.size()) {
                long l = 0L;
                return l;
            }
            dstByteChannel.position(position);
            int length = count > Integer.MAX_VALUE ? 0x7FFFFFFE : (int)count;
            ByteBuffer dst = ByteBuffer.allocate(length);
            src.read(dst);
            length = dstByteChannel.write(dst);
            bytesTransferred = length;
        }
        return bytesTransferred;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException(NEGATIVE_POSITION_ERROR_MESSAGE);
        }
        try (SeekableByteChannel srcByteChannel = this.path.getFileSystem().provider().newByteChannel((Path)this.path, (Set)this.options, (FileAttribute[])this.attrs);){
            if (position > srcByteChannel.size()) {
                int n = 0;
                return n;
            }
            srcByteChannel.position(position);
            int n = srcByteChannel.read(dst);
            return n;
        }
    }

    @Override
    public int write(ByteBuffer src, long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.byteChannel.close();
    }
}

