/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.vfs.remote.RegularFileMetadata;
import org.esa.snap.vfs.remote.http.RegularFileMetadataCallback;

public abstract class VFSFileAttributes
implements BasicFileAttributes {
    static final FileTime UNKNOWN_FILE_TIME = FileTime.from(Instant.EPOCH);
    static final DateTimeFormatter ISO_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    private static final Logger logger = Logger.getLogger(VFSFileAttributes.class.getName());

    public static BasicFileAttributes newFile(String fileKey, long size, String lastModified) {
        return VFSFileAttributes.newFile(fileKey, new RegularFileMetadata(lastModified, size));
    }

    public static BasicFileAttributes newFile(String fileKey, RegularFileMetadata regularFileMetadata) {
        if (fileKey == null) {
            throw new NullPointerException("fileKey is null");
        }
        if (regularFileMetadata == null) {
            throw new NullPointerException("regularFileMetadata is null");
        }
        return new RegularFileAttributes(fileKey, regularFileMetadata, null);
    }

    public static BasicFileAttributes newFile(String fileKey, RegularFileMetadataCallback regularFileMetadataCallback) {
        if (fileKey == null) {
            throw new NullPointerException("fileKey is null");
        }
        if (regularFileMetadataCallback == null) {
            throw new NullPointerException("regularFileMetadataCallback is null");
        }
        return new RegularFileAttributes(fileKey, null, regularFileMetadataCallback);
    }

    public static BasicFileAttributes newDir(String prefix) {
        return new DirAttributes(prefix);
    }

    static BasicFileAttributes getRoot(String rootPath) {
        return new DirAttributes(rootPath);
    }

    @Override
    public FileTime lastModifiedTime() {
        return UNKNOWN_FILE_TIME;
    }

    @Override
    public FileTime lastAccessTime() {
        return UNKNOWN_FILE_TIME;
    }

    @Override
    public FileTime creationTime() {
        return UNKNOWN_FILE_TIME;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    public String fileURL() {
        return null;
    }

    private static class DirAttributes
    extends VFSFileAttributes {
        private final String fileKey;

        DirAttributes(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public String fileKey() {
            return this.fileKey;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public long size() {
            return 0L;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DirAttributes) {
                return this.fileKey.contentEquals(((DirAttributes)obj).fileKey);
            }
            return false;
        }

        public int hashCode() {
            return this.fileKey.hashCode();
        }
    }

    public static class RegularFileAttributes
    extends VFSFileAttributes {
        private final String fileKey;
        private final RegularFileMetadataCallback fileSizeQueryCallback;
        private FileTime lastModifiedTime;
        private RegularFileMetadata regularFileMetadata;

        RegularFileAttributes(String fileKey, RegularFileMetadata regularFileMetadata, RegularFileMetadataCallback fileSizeQueryCallback) {
            this.fileKey = fileKey;
            this.regularFileMetadata = regularFileMetadata;
            this.fileSizeQueryCallback = fileSizeQueryCallback;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public String fileKey() {
            return this.fileKey;
        }

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public synchronized long size() {
            this.readMetadataIfNeeded();
            return this.regularFileMetadata.getSize();
        }

        @Override
        public synchronized FileTime lastModifiedTime() {
            this.readMetadataIfNeeded();
            if (this.lastModifiedTime == null) {
                this.lastModifiedTime = UNKNOWN_FILE_TIME;
                String lastModified = this.regularFileMetadata.getLastModified();
                if (lastModified != null) {
                    try {
                        LocalDateTime dateTime = LocalDateTime.parse(lastModified, ISO_DATE_TIME);
                        this.lastModifiedTime = FileTime.from(dateTime.toInstant(ZoneOffset.UTC));
                    }
                    catch (DateTimeParseException ex) {
                        logger.log(Level.FINE, "Unable to convert the string: " + lastModified + " to LocalDateTime. Details: " + ex.getMessage());
                    }
                }
            }
            return this.lastModifiedTime;
        }

        private void readMetadataIfNeeded() {
            if (this.regularFileMetadata == null) {
                try {
                    this.regularFileMetadata = this.fileSizeQueryCallback.readFileMetadata();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read the metadata for file '" + this.fileKey + "'.", e);
                }
            }
        }

        @Override
        public String fileURL() {
            this.readMetadataIfNeeded();
            if (this.regularFileMetadata != null) {
                return this.regularFileMetadata.getFileURL();
            }
            return super.fileURL();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegularFileAttributes) {
                return this.fileKey.contentEquals(((RegularFileAttributes)obj).fileKey);
            }
            return false;
        }

        public int hashCode() {
            return this.fileKey.hashCode();
        }
    }
}

