/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import org.esa.snap.vfs.remote.VFSFileChannel;
import org.esa.snap.vfs.remote.VFSPath;

class VFSByteChannel
implements SeekableByteChannel {
    private final VFSPath path;
    private final long contentLength;
    private HttpURLConnection connection;
    private long position;
    private boolean canCreateConnection;

    VFSByteChannel(VFSPath path) throws IOException {
        this.path = path;
        this.position = 0L;
        this.canCreateConnection = true;
        this.createConnectionIfNeeded();
        this.contentLength = this.connection.getContentLengthLong();
    }

    @Override
    public long size() throws IOException {
        this.assertOpen();
        return this.contentLength;
    }

    @Override
    public long position() throws ClosedChannelException {
        this.assertOpen();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.assertOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition is negative");
        }
        if (newPosition >= this.contentLength) {
            throw new EOFException(this.path.toString());
        }
        if (this.position != newPosition) {
            this.canCreateConnection = true;
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.connection != null;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.path.getFileSystem().removeByteChannel(this);
    }

    @Override
    public int read(ByteBuffer destinationBuffer) throws IOException {
        int offset;
        byte[] bytes;
        this.assertOpen();
        if (this.position >= this.contentLength) {
            return -1;
        }
        int bytesToRead = destinationBuffer.remaining();
        if (destinationBuffer.hasArray()) {
            bytes = destinationBuffer.array();
            offset = destinationBuffer.arrayOffset();
        } else {
            bytes = new byte[bytesToRead];
            offset = 0;
        }
        int bytesTransferred = this.readBytes(bytes, offset, bytesToRead);
        destinationBuffer.put(bytes, offset, bytesTransferred);
        return bytesTransferred;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    private void assertOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    long read(ByteBuffer[] destinationBuffers, int offset, int length) throws IOException {
        this.assertOpen();
        if (this.position >= this.contentLength) {
            return -1L;
        }
        long bytesRead = 0L;
        for (ByteBuffer buffer : destinationBuffers) {
            byte[] bytes;
            int numRemaining = buffer.remaining();
            if (buffer.hasArray()) {
                bytes = buffer.array();
                numRemaining = this.readBytes(bytes, offset, length);
                buffer.put(bytes, buffer.arrayOffset(), numRemaining);
            } else {
                bytes = new byte[numRemaining];
                numRemaining = this.readBytes(bytes, offset, length);
                buffer.put(bytes, 0, numRemaining);
            }
            bytesRead += (long)numRemaining;
        }
        return bytesRead;
    }

    private int readBytes(byte[] array, int offset, int length) throws IOException {
        int bytesReadNow;
        this.createConnectionIfNeeded();
        InputStream inputStream = this.connection.getInputStream();
        int bytesTransferred = 0;
        while (length > 0 && (bytesReadNow = inputStream.read(array, offset, length)) > 0) {
            length -= bytesReadNow;
            offset += bytesReadNow;
            bytesTransferred += bytesReadNow;
            this.position += (long)bytesReadNow;
        }
        return bytesTransferred;
    }

    private void createConnectionIfNeeded() throws IOException {
        if (this.canCreateConnection) {
            this.canCreateConnection = false;
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
            this.connection = VFSFileChannel.buildProviderConnectionChannel(this.path, this.position, "GET");
        }
    }
}

