/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.RegularFileMetadata;

public class HttpUtils {
    private HttpUtils() {
    }

    public static boolean isValidResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    public static RegularFileMetadata readRegularFileMetadata(String urlAddress, IRemoteConnectionBuilder remoteConnectionBuilder, String fileSystemRoot) throws IOException {
        URL fileURL = new URL(urlAddress);
        HttpURLConnection connection = remoteConnectionBuilder.buildConnection(fileSystemRoot, fileURL, "GET", null);
        try {
            int responseCode = connection.getResponseCode();
            if (HttpUtils.isValidResponseCode(responseCode)) {
                String sizeString = connection.getHeaderField("content-length");
                String lastModified = connection.getHeaderField("last-modified");
                if (!StringUtils.isNotNullAndNotEmpty((String)sizeString) || !StringUtils.isNotNullAndNotEmpty((String)lastModified)) {
                    if (!connection.getURL().toString().contentEquals(urlAddress)) {
                        throw new IOException("Invalid VFS service.\nReason: Redirect from: " + urlAddress + " to: " + connection.getURL().toString());
                    }
                    throw new IOException("filePath is not a file '" + urlAddress + "'.");
                }
                long size = Long.parseLong(sizeString);
                RegularFileMetadata regularFileMetadata = new RegularFileMetadata(urlAddress, lastModified, size);
                return regularFileMetadata;
            }
            Logger.getLogger(HttpUtils.class.getName()).warning("HTTP error response:");
            Logger.getLogger(HttpUtils.class.getName()).warning(() -> {
                try {
                    return IOUtils.toString((InputStream)connection.getErrorStream(), (String)"UTF-8");
                }
                catch (IOException iOException) {
                    return "";
                }
            });
            throw new IOException(urlAddress + ": response code " + responseCode + ": " + connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }

    public static String readResponse(String urlAddress, IRemoteConnectionBuilder remoteConnectionBuilder, String fileSystemRoot) throws IOException {
        URL pageURL = new URL(urlAddress);
        HttpURLConnection connection = remoteConnectionBuilder.buildConnection(fileSystemRoot, pageURL, "GET", null);
        try {
            int responseCode = connection.getResponseCode();
            if (HttpUtils.isValidResponseCode(responseCode)) {
                try (InputStream inputStream = connection.getInputStream();){
                    String string;
                    try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) != -1) {
                            result.write(buffer, 0, length);
                        }
                        string = result.toString("UTF-8");
                    }
                    return string;
                }
            }
            Logger.getLogger(HttpUtils.class.getName()).warning("HTTP error response:");
            Logger.getLogger(HttpUtils.class.getName()).warning(() -> {
                try {
                    return IOUtils.toString((InputStream)connection.getErrorStream(), (String)"UTF-8").replaceAll("<AWSAccessKeyId>.*</AWSAccessKeyId>", "<AWSAccessKeyId>***</AWSAccessKeyId>");
                }
                catch (IOException iOException) {
                    return "";
                }
            });
            throw new IOException(urlAddress + ": response code " + responseCode + ": " + connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }
}

