/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.attribute.BasicFileAttributes;
import org.esa.snap.vfs.remote.HttpUtils;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.RegularFileMetadata;
import org.esa.snap.vfs.remote.VFSFileAttributes;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.VFSWalker;

public abstract class AbstractRemoteWalker
implements VFSWalker {
    protected final IRemoteConnectionBuilder remoteConnectionBuilder;

    protected AbstractRemoteWalker(IRemoteConnectionBuilder remoteConnectionBuilder) {
        this.remoteConnectionBuilder = remoteConnectionBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicFileAttributes readBasicFileAttributes(VFSPath path) throws IOException {
        String address = path.buildURL().toString();
        String fileSystemSeparator = path.getFileSystem().getSeparator();
        String fileSystemRoot = path.getFileSystem().getRoot().getPath();
        URL directoryURL = new URL(address + (address.endsWith(fileSystemSeparator) ? "" : fileSystemSeparator));
        HttpURLConnection connection = this.remoteConnectionBuilder.buildConnection(fileSystemRoot, directoryURL, "GET", null);
        try {
            int responseCode = connection.getResponseCode();
            if (HttpUtils.isValidResponseCode(responseCode)) {
                BasicFileAttributes basicFileAttributes = VFSFileAttributes.newDir(path.toString());
                return basicFileAttributes;
            }
        }
        finally {
            connection.disconnect();
        }
        return this.readFileAttributes(address, path.toString(), fileSystemRoot);
    }

    private BasicFileAttributes readFileAttributes(String urlAddress, String filePath, String fileSystemRoot) throws IOException {
        RegularFileMetadata regularFileMetadata = HttpUtils.readRegularFileMetadata(urlAddress, this.remoteConnectionBuilder, fileSystemRoot);
        return VFSFileAttributes.newFile(filePath, regularFileMetadata);
    }
}

