/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystem;
import org.esa.snap.vfs.remote.IRemoteConnectionBuilder;
import org.esa.snap.vfs.remote.VFSByteChannel;
import org.esa.snap.vfs.remote.VFSFileChannel;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.VFSWalker;

public abstract class AbstractRemoteFileSystemProvider
extends FileSystemProvider
implements IRemoteConnectionBuilder {
    private final Map<String, AbstractRemoteFileSystem> fileSystems = new HashMap<String, AbstractRemoteFileSystem>();

    protected AbstractRemoteFileSystemProvider() {
    }

    private static String extractFileSystemRoot(URI uri) {
        String substring;
        String resourcePathAsString = AbstractRemoteFileSystemProvider.extractSchemeSpecificPart(uri);
        int index = resourcePathAsString.indexOf(substring = ":");
        if (index < 0) {
            throw new IllegalArgumentException("The scheme specific part '" + resourcePathAsString + "' does not start with the file system root.");
        }
        return resourcePathAsString.substring(0, index + substring.length());
    }

    private static String extractSchemeSpecificPart(URI uri) {
        String resourcePathAsString = uri.getSchemeSpecificPart();
        if (resourcePathAsString.startsWith("/")) {
            resourcePathAsString = resourcePathAsString.substring(1);
        }
        return resourcePathAsString;
    }

    public abstract void setConnectionData(String var1, String var2, Map<String, ?> var3);

    protected abstract VFSWalker newObjectStorageWalker(String var1);

    public abstract String getProviderAddress(String var1);

    public abstract String getProviderFileSeparator(String var1);

    protected abstract AbstractRemoteFileSystem newFileSystem(String var1, Map<String, ?> var2);

    @Override
    public final AbstractRemoteFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.validateScheme(uri);
        String fileSystemRoot = AbstractRemoteFileSystemProvider.extractFileSystemRoot(uri);
        this.validateProviderAddress(fileSystemRoot);
        AbstractRemoteFileSystem fileSystem = this.fileSystems.get(fileSystemRoot);
        if (fileSystem != null) {
            throw new FileSystemAlreadyExistsException(uri.toString());
        }
        fileSystem = this.newFileSystem(fileSystemRoot, env);
        this.fileSystems.put(fileSystemRoot, fileSystem);
        return fileSystem;
    }

    @Override
    public final AbstractRemoteFileSystem getFileSystem(URI uri) {
        this.validateScheme(uri);
        String fileSystemRoot = AbstractRemoteFileSystemProvider.extractFileSystemRoot(uri);
        this.validateProviderAddress(fileSystemRoot);
        AbstractRemoteFileSystem fileSystem = this.fileSystems.get(fileSystemRoot);
        if (fileSystem == null) {
            throw new FileSystemNotFoundException(uri.toString());
        }
        return fileSystem;
    }

    @Override
    public final Path getPath(URI uri) {
        this.validateScheme(uri);
        String fileSystemRoot = AbstractRemoteFileSystemProvider.extractFileSystemRoot(uri);
        this.validateProviderAddress(fileSystemRoot);
        AbstractRemoteFileSystem fileSystem = this.fileSystems.computeIfAbsent(fileSystemRoot, fsr -> this.newFileSystem((String)fsr, (Map<String, ?>)Collections.emptyMap()));
        String resourcePathAsString = AbstractRemoteFileSystemProvider.extractSchemeSpecificPart(uri);
        return VFSPath.parsePath(fileSystem, resourcePathAsString);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        VFSPath remotePath = VFSPath.toRemotePath(path);
        return new VFSFileChannel(remotePath, options, attrs);
    }

    @Override
    public VFSByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        VFSPath remotePath = VFSPath.toRemotePath(path);
        AbstractRemoteFileSystem fileSystem = remotePath.getFileSystem();
        return fileSystem.openByteChannel(remotePath, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        VFSPath remoteDir = VFSPath.toRemotePath(dir);
        AbstractRemoteFileSystem fileSystem = remoteDir.getFileSystem();
        final Iterable<Path> directories = fileSystem.walkDir(remoteDir, filter);
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return directories.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?>[] attrs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) {
        VFSPath remotePath1 = VFSPath.toRemotePath(path1);
        VFSPath remotePath2 = VFSPath.toRemotePath(path2);
        return remotePath1.equals(remotePath2);
    }

    @Override
    public boolean isHidden(Path path) {
        VFSPath.toRemotePath(path);
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModes) throws IOException {
        VFSPath remotePath = VFSPath.toRemotePath(path);
        if (accessModes.length == 0) {
            AbstractRemoteFileSystemProvider.checkRead(remotePath);
        } else {
            for (AccessMode mode : accessModes) {
                if (mode != AccessMode.READ) {
                    throw new IOException("The access mode '" + mode + "' is not allowed.");
                }
                AbstractRemoteFileSystemProvider.checkRead(remotePath);
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... linkOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... linkOptions) throws IOException {
        if (linkOptions.length == 0 || linkOptions.length == 1 && linkOptions[0] == LinkOption.NOFOLLOW_LINKS) {
            VFSPath remotePath = VFSPath.toRemotePath(path);
            BasicFileAttributes fileAttributes = AbstractRemoteFileSystemProvider.checkRead(remotePath);
            return (A)((BasicFileAttributes)type.cast(fileAttributes));
        }
        throw new IOException("The link options must be empty or only '" + LinkOption.NOFOLLOW_LINKS + "' is allowed.");
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    public Path getPathIfFileSystemRootMatches(String first, String ... more) {
        for (Map.Entry<String, AbstractRemoteFileSystem> entry : this.fileSystems.entrySet()) {
            String fileSystemRoot = entry.getKey();
            if (!first.startsWith(fileSystemRoot)) continue;
            AbstractRemoteFileSystem remoteFileSystem = entry.getValue();
            return remoteFileSystem.getPath(first, more);
        }
        return null;
    }

    public final AbstractRemoteFileSystem getFileSystemOrCreate(URI uri, Map<String, ?> env) {
        this.validateScheme(uri);
        String fileSystemRoot = AbstractRemoteFileSystemProvider.extractFileSystemRoot(uri);
        this.validateProviderAddress(fileSystemRoot);
        return this.fileSystems.computeIfAbsent(fileSystemRoot, fsr -> this.newFileSystem((String)fsr, env));
    }

    void unlinkFileSystem(AbstractRemoteFileSystem fileSystem) {
        for (Map.Entry<String, AbstractRemoteFileSystem> entry : this.fileSystems.entrySet()) {
            if (entry.getValue() != fileSystem) continue;
            this.fileSystems.remove(entry.getKey());
            return;
        }
    }

    private void validateScheme(URI uri) {
        if (!this.getScheme().equals(uri.getScheme())) {
            throw new IllegalArgumentException("The provider scheme '" + this.getScheme() + "' is not the same with the uri scheme '" + uri.getScheme() + "'.");
        }
    }

    private void validateProviderAddress(String fileSystemRoot) {
        if (this.getProviderAddress(fileSystemRoot).isEmpty()) {
            throw new IllegalStateException("The VFS with scheme: " + this.getScheme() + " is not initialized.");
        }
    }

    private static BasicFileAttributes checkRead(VFSPath path) throws IOException {
        BasicFileAttributes fileAttributes = path.getFileAttributes();
        if (fileAttributes == null) {
            AbstractRemoteFileSystem fileSystem = path.getFileSystem();
            fileAttributes = fileSystem.newObjectStorageWalker().readBasicFileAttributes(path);
            path.setFileAttributes(fileAttributes);
        }
        return fileAttributes;
    }
}

