/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.remote;

import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;
import org.esa.snap.vfs.remote.VFSByteChannel;
import org.esa.snap.vfs.remote.VFSFileAttributes;
import org.esa.snap.vfs.remote.VFSPath;
import org.esa.snap.vfs.remote.VFSWalker;

public abstract class AbstractRemoteFileSystem
extends FileSystem {
    private final AbstractRemoteFileSystemProvider provider;
    private final List<VFSByteChannel> openChannels;
    private VFSPath rootPath;
    private boolean closed;
    private VFSWalker walker;

    protected AbstractRemoteFileSystem(AbstractRemoteFileSystemProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.provider = provider;
        this.closed = false;
        this.openChannels = new ArrayList<VFSByteChannel>();
    }

    protected abstract String getFileSystemRoot();

    final VFSWalker newObjectStorageWalker() {
        return this.provider.newObjectStorageWalker(this.getRoot().getPath());
    }

    @Override
    public AbstractRemoteFileSystemProvider provider() {
        return this.provider;
    }

    public VFSPath getRoot() {
        return this.getRootOrCreate();
    }

    private VFSPath getRootOrCreate() {
        if (this.rootPath == null) {
            BasicFileAttributes rootVFSFileAttributes = VFSFileAttributes.getRoot(this.getFileSystemRoot());
            this.rootPath = new VFSPath(this, true, (String)rootVFSFileAttributes.fileKey(), rootVFSFileAttributes);
        }
        return this.rootPath;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (int i = this.openChannels.size() - 1; i >= 0; --i) {
                this.openChannels.get(i).close();
            }
            this.provider.unlinkFileSystem(this);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return this.provider.getProviderFileSeparator(this.getFileSystemRoot());
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        DirectoryStream.Filter<Path> filter = entry -> {
            VFSPath remotePath = VFSPath.toRemotePath(entry);
            return remotePath.getFileAttributes().isDirectory();
        };
        try {
            return this.walkDir(this.getRoot(), filter);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to get the root directories.", ex);
        }
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path getPath(String first, String ... more) {
        this.assertOpen();
        Object pathName = first;
        if (more.length > 0) {
            String pathSeparator = this.getSeparator();
            pathName = (String)pathName + pathSeparator + String.join((CharSequence)pathSeparator, more);
        }
        return VFSPath.parsePath(this, (String)pathName);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    private void assertOpen() {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
    }

    VFSByteChannel openByteChannel(VFSPath path, Set<? extends OpenOption> options, FileAttribute<?>[] attrs) throws IOException {
        boolean noCreateAttributes;
        boolean plainReadWriteMode = options.isEmpty() || options.size() == 1 && (options.contains(StandardOpenOption.READ) || options.contains(StandardOpenOption.WRITE));
        boolean bl = noCreateAttributes = attrs.length == 0;
        if (plainReadWriteMode && noCreateAttributes) {
            VFSByteChannel channel = new VFSByteChannel(path);
            this.openChannels.add(channel);
            return channel;
        }
        throw new UnsupportedOperationException();
    }

    void removeByteChannel(VFSByteChannel channel) {
        this.openChannels.remove(channel);
    }

    Iterable<Path> walkDir(VFSPath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.assertOpen();
        VFSPath path = VFSPath.toRemotePath(dir.toAbsolutePath());
        if (this.walker == null) {
            this.walker = this.newObjectStorageWalker();
        }
        List<BasicFileAttributes> files = this.walker.walk(path);
        return files.stream().map(f -> VFSPath.fromFileAttributes(this, f)).filter(p -> this.filterPath((VFSPath)p, filter)).collect(Collectors.toList());
    }

    private boolean filterPath(VFSPath path, DirectoryStream.Filter<? super Path> filter) {
        try {
            return filter.accept(path);
        }
        catch (IOException ex) {
            return false;
        }
    }
}

