/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.preferences.validators;

import java.util.regex.Pattern;

public class RepositorySchemaValidator {
    private static final String REPOSITORY_SCHEMA_VALIDATOR_PATTERN = "^([a-z0-9]+)$";

    public void validateValue(Object value) {
        if (!this.isValid((String)value)) {
            throw new IllegalArgumentException("Invalid VFS repository schema! Please check if it meets following requirements:\n- It must contains only lowercase alphanumeric characters.");
        }
    }

    public boolean isValid(String repositorySchema) {
        return Pattern.compile(REPOSITORY_SCHEMA_VALIDATOR_PATTERN).matcher(repositorySchema).matches();
    }
}

