/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.preferences.validators;

import java.util.regex.Pattern;

public class RepositoryNameValidator {
    private static final String REPOSITORY_NAME_VALIDATOR_PATTERN = "^([\\w\\-]{3,25})$";

    public void validateValue(Object value) {
        if (!this.isValid((String)value)) {
            throw new IllegalArgumentException("Invalid VFS repository name! Please check if it meets following requirements:\n- It must be alphanumeric.\n- Underscores and hyphens are allowed.\n- Length is between 3 and 25 characters.");
        }
    }

    public boolean isValid(String repositoryName) {
        return Pattern.compile(REPOSITORY_NAME_VALIDATOR_PATTERN).matcher(repositoryName).matches();
    }
}

