/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.preferences.validators;

import java.util.regex.Pattern;

public class RepositoryAddressValidator {
    private static final String REPOSITORY_ADDRESS_VALIDATOR_PATTERN = "^([a-z0-9/\\\\:.#$%&\\-]+)$";

    public void validateValue(Object value) {
        if (!this.isValid((String)value)) {
            throw new IllegalArgumentException("Invalid VFS repository address! Please check if it meets following requirements:\n- It must contains URL specific characters");
        }
    }

    public boolean isValid(String repositoryAddress) {
        return Pattern.compile(REPOSITORY_ADDRESS_VALIDATOR_PATTERN).matcher(repositoryAddress).matches();
    }
}

