/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs.preferences.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.vfs.NioPaths;
import org.esa.snap.vfs.preferences.model.Property;
import org.esa.snap.vfs.preferences.model.VFSRemoteFileRepository;
import org.esa.snap.vfs.preferences.validators.RepositoryAddressValidator;
import org.esa.snap.vfs.preferences.validators.RepositoryNameValidator;
import org.esa.snap.vfs.preferences.validators.RepositorySchemaValidator;

public final class VFSRemoteFileRepositoriesController {
    public static final String LIST_ITEM_SEPARATOR = ";";
    public static final String PREFERENCE_KEY_VFS_REPOSITORIES = "vfs.repositories";
    public static final String CREDENTIAL_PROPERTY_NAME_REGEX = "((.*)((key)|(password)|(secret))(.*))";
    private static final int MODE_ADD = 0;
    private static final int MODE_REMOVE = 1;
    private static final String REPO_ID_KEY = "%repo_id%";
    private static final String PROP_ID_KEY = "%prop_id%";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY = "vfs.repositories.repository_%repo_id%";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_NAME = "vfs.repositories.repository_%repo_id%.name";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_SCHEMA = "vfs.repositories.repository_%repo_id%.schema";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_ADDRESS = "vfs.repositories.repository_%repo_id%.address";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_PROPERTIES = "vfs.repositories.repository_%repo_id%.properties";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY = "vfs.repositories.repository_%repo_id%.properties.property_%prop_id%";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_NAME = "vfs.repositories.repository_%repo_id%.properties.property_%prop_id%.name";
    private static final String PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_VALUE = "vfs.repositories.repository_%repo_id%.properties.property_%prop_id%.value";
    private static Logger logger = Logger.getLogger(VFSRemoteFileRepositoriesController.class.getName());
    private final Path vfsConfigFile;
    private final Properties properties = new Properties();
    private String remoteRepositoriesIds;
    private boolean isChanged = false;

    public VFSRemoteFileRepositoriesController(Path vfsConfigFile) throws IOException {
        this.vfsConfigFile = vfsConfigFile;
        this.loadProperties();
    }

    public static Path getDefaultConfigFilePath() {
        return NioPaths.get(EngineConfig.instance().userDir().toString() + "/config/Preferences/vfs.properties", new String[0]);
    }

    public static List<VFSRemoteFileRepository> getVFSRemoteFileRepositories(Path vfsConfigFile) throws IOException {
        ArrayList<VFSRemoteFileRepository> vfsRemoteFileRepositories = new ArrayList<VFSRemoteFileRepository>();
        VFSRemoteFileRepositoriesController vfsRemoteFileRepositoriesController = new VFSRemoteFileRepositoriesController(vfsConfigFile);
        String remoteRepositoriesIds = vfsRemoteFileRepositoriesController.getRemoteRepositoriesIds().getValue();
        if (remoteRepositoriesIds != null && !remoteRepositoriesIds.isEmpty()) {
            String[] remoteRepositoriesIdsList;
            for (String remoteRepositoryId : remoteRepositoriesIdsList = remoteRepositoriesIds.split(LIST_ITEM_SEPARATOR)) {
                String remoteRepositoryName = vfsRemoteFileRepositoriesController.getRemoteRepositoryName(remoteRepositoryId).getValue();
                String remoteRepositorySchema = vfsRemoteFileRepositoriesController.getRemoteRepositorySchema(remoteRepositoryId).getValue();
                String remoteRepositoryAddress = vfsRemoteFileRepositoriesController.getRemoteRepositoryAddress(remoteRepositoryId).getValue();
                List<Property> vfsRemoteFileRepositoryProperties = vfsRemoteFileRepositoriesController.getVFSRemoteFileRepositoryProperties(remoteRepositoryId);
                vfsRemoteFileRepositories.add(new VFSRemoteFileRepository(remoteRepositoryName, remoteRepositorySchema, remoteRepositoryAddress, vfsRemoteFileRepositoryProperties));
            }
        }
        return vfsRemoteFileRepositories;
    }

    public void loadProperties() throws IOException {
        InputStream inputStream = null;
        try {
            if (Files.exists(this.vfsConfigFile, new LinkOption[0])) {
                inputStream = Files.newInputStream(this.vfsConfigFile, new OpenOption[0]);
                this.properties.load(inputStream);
            }
            this.isChanged = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateConfig() {
        if (StringUtils.isNotNullAndNotEmpty((String)this.remoteRepositoriesIds)) {
            String[] remoteRepositoriesIdsList;
            for (String remoteRepositoryId : remoteRepositoriesIdsList = this.remoteRepositoriesIds.split(LIST_ITEM_SEPARATOR)) {
                String remoteRepositoryName = this.getRemoteRepositoryName(remoteRepositoryId).getValue();
                String remoteRepositorySchema = this.getRemoteRepositorySchema(remoteRepositoryId).getValue();
                String remoteRepositoryAddress = this.getRemoteRepositoryAddress(remoteRepositoryId).getValue();
                if (!StringUtils.isNullOrEmpty((String)remoteRepositoryName) && !StringUtils.isNullOrEmpty((String)remoteRepositorySchema) && !StringUtils.isNullOrEmpty((String)remoteRepositoryAddress)) continue;
                throw new IllegalArgumentException("Empty repository found.");
            }
        }
    }

    public void saveProperties() throws IOException {
        this.validateConfig();
        OutputStream outputStream = null;
        try {
            if (!Files.exists(this.vfsConfigFile, new LinkOption[0])) {
                Files.createDirectories(this.vfsConfigFile.getParent(), new FileAttribute[0]);
                Files.createFile(this.vfsConfigFile, new FileAttribute[0]);
            }
            outputStream = Files.newOutputStream(this.vfsConfigFile, new OpenOption[0]);
            this.properties.store(outputStream, "");
            this.isChanged = false;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    private void writeProperty(Property property) {
        if (property != null) {
            try {
                this.properties.setProperty(property.getName(), property.getValue());
                this.isChanged = true;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to write the property on properties. Details: " + ex.getMessage());
            }
        }
    }

    private Property getProperty(String propertyKey) {
        return new Property(propertyKey, this.properties.getProperty(propertyKey, ""));
    }

    private void removeProperty(Property property) {
        if (property != null) {
            try {
                this.properties.remove(property.getName());
                this.isChanged = true;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to remove the property from SNAP configuration file. Details: " + ex.getMessage());
            }
        }
    }

    public Property getRemoteRepositoriesIds() {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORIES);
    }

    private void updateRemoteRepositoriesIds(String remoteRepositoryId, int mode) {
        Property remoteRepositoryIdsProperty = this.getRemoteRepositoriesIds();
        this.remoteRepositoriesIds = remoteRepositoryIdsProperty.getValue();
        this.remoteRepositoriesIds = this.remoteRepositoriesIds != null ? this.remoteRepositoriesIds : "";
        switch (mode) {
            case 0: {
                this.remoteRepositoriesIds = !this.remoteRepositoriesIds.isEmpty() ? this.remoteRepositoriesIds + LIST_ITEM_SEPARATOR + remoteRepositoryId : remoteRepositoryId;
                break;
            }
            case 1: {
                this.remoteRepositoriesIds = this.remoteRepositoriesIds.replaceAll("((" + remoteRepositoryId + "(;)?)|(;)?" + remoteRepositoryId + ")", "");
                break;
            }
        }
        remoteRepositoryIdsProperty.setValue(this.remoteRepositoriesIds);
        this.writeProperty(remoteRepositoryIdsProperty);
    }

    public Property getRemoteRepositoryPropertiesIds(String remoteRepositoryId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_PROPERTIES.replace(REPO_ID_KEY, remoteRepositoryId));
    }

    private void updateRemoteRepositoryPropertiesIds(String remoteRepositoryId, String remoteRepositoryPropertyId, int mode) {
        Property remoteRepositoryPropertiesIdsProperty = this.getRemoteRepositoryPropertiesIds(remoteRepositoryId);
        String remoteRepositoryPropertiesIds = remoteRepositoryPropertiesIdsProperty.getValue();
        remoteRepositoryPropertiesIds = remoteRepositoryPropertiesIds != null ? remoteRepositoryPropertiesIds : "";
        switch (mode) {
            case 0: {
                remoteRepositoryPropertiesIds = !remoteRepositoryPropertiesIds.isEmpty() ? remoteRepositoryPropertiesIds + LIST_ITEM_SEPARATOR + remoteRepositoryPropertyId : remoteRepositoryPropertyId;
                break;
            }
            case 1: {
                remoteRepositoryPropertiesIds = remoteRepositoryPropertiesIds.replaceAll("((" + remoteRepositoryPropertyId + "(;)?)|(;)?" + remoteRepositoryPropertyId + ")", "");
                break;
            }
        }
        remoteRepositoryPropertiesIdsProperty.setValue(remoteRepositoryPropertiesIds);
        this.writeProperty(remoteRepositoryPropertiesIdsProperty);
    }

    public String registerNewRemoteRepository() {
        String remoteRepositoryId = "" + System.currentTimeMillis();
        this.updateRemoteRepositoriesIds(remoteRepositoryId, 0);
        return remoteRepositoryId;
    }

    public String registerNewRemoteRepositoryProperty(String remoteRepositoryId) {
        String remoteRepositoryPropertyId = "" + System.currentTimeMillis();
        this.updateRemoteRepositoryPropertiesIds(remoteRepositoryId, remoteRepositoryPropertyId, 0);
        return remoteRepositoryPropertyId;
    }

    public Property getRemoteRepositoryName(String remoteRepositoryId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_NAME.replace(REPO_ID_KEY, remoteRepositoryId));
    }

    public void setRemoteRepositoryName(String remoteRepositoryId, String remoteRepositoryName) {
        if (!new RepositoryNameValidator().isValid(remoteRepositoryName) || !this.isUniqueRemoteRepositoryName(remoteRepositoryName)) {
            throw new IllegalArgumentException("Invalid remote file repository name.");
        }
        Property remoteRepositoryNameProperty = new Property(PREFERENCE_KEY_VFS_REPOSITORY_NAME.replace(REPO_ID_KEY, remoteRepositoryId), remoteRepositoryName);
        this.writeProperty(remoteRepositoryNameProperty);
    }

    public Property getRemoteRepositorySchema(String remoteRepositoryId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_SCHEMA.replace(REPO_ID_KEY, remoteRepositoryId));
    }

    public void setRemoteRepositorySchema(String remoteRepositoryId, String remoteRepositorySchema) {
        if (!new RepositorySchemaValidator().isValid(remoteRepositorySchema)) {
            throw new IllegalArgumentException("Invalid remote file repository schema.");
        }
        Property remoteRepositorySchemaProperty = new Property(PREFERENCE_KEY_VFS_REPOSITORY_SCHEMA.replace(REPO_ID_KEY, remoteRepositoryId), remoteRepositorySchema);
        this.writeProperty(remoteRepositorySchemaProperty);
    }

    public Property getRemoteRepositoryAddress(String remoteRepositoryId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_ADDRESS.replace(REPO_ID_KEY, remoteRepositoryId));
    }

    public void setRemoteRepositoryAddress(String remoteRepositoryId, String remoteRepositoryAddress) {
        if (!new RepositoryAddressValidator().isValid(remoteRepositoryAddress)) {
            throw new IllegalArgumentException("Invalid remote file repository address.");
        }
        Property remoteRepositorySchemaProperty = new Property(PREFERENCE_KEY_VFS_REPOSITORY_ADDRESS.replace(REPO_ID_KEY, remoteRepositoryId), remoteRepositoryAddress);
        this.writeProperty(remoteRepositorySchemaProperty);
    }

    public Property getRemoteRepositoryPropertyName(String remoteRepositoryId, String remoteRepositoryPropertyId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_NAME.replace(REPO_ID_KEY, remoteRepositoryId).replace(PROP_ID_KEY, remoteRepositoryPropertyId));
    }

    public void setRemoteRepositoryPropertyName(String remoteRepositoryId, String remoteRepositoryPropertyId, String remoteRepositoryPropertyName) {
        if (!new RepositoryNameValidator().isValid(remoteRepositoryPropertyName) || !this.isUniqueRemoteRepositoryPropertyName(remoteRepositoryId, remoteRepositoryPropertyName)) {
            throw new IllegalArgumentException("Invalid remote file repository property name.");
        }
        Property remoteRepositoryPropertyNameProperty = new Property(PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_NAME.replace(REPO_ID_KEY, remoteRepositoryId).replace(PROP_ID_KEY, remoteRepositoryPropertyId), remoteRepositoryPropertyName);
        this.writeProperty(remoteRepositoryPropertyNameProperty);
    }

    public Property getRemoteRepositoryPropertyValue(String remoteRepositoryId, String remoteRepositoryPropertyId) {
        return this.getProperty(PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_VALUE.replace(REPO_ID_KEY, remoteRepositoryId).replace(PROP_ID_KEY, remoteRepositoryPropertyId));
    }

    public void setRemoteRepositoryPropertyValue(String remoteRepositoryId, String remoteRepositoryPropertyId, String remoteRepositoryPropertyValue) {
        if (remoteRepositoryPropertyValue.isEmpty()) {
            throw new IllegalArgumentException("Invalid remote file repository property value.");
        }
        Property remoteRepositoryPropertyValueProperty = new Property(PREFERENCE_KEY_VFS_REPOSITORY_PROPERTY_VALUE.replace(REPO_ID_KEY, remoteRepositoryId).replace(PROP_ID_KEY, remoteRepositoryPropertyId), remoteRepositoryPropertyValue);
        this.writeProperty(remoteRepositoryPropertyValueProperty);
    }

    public void removeRemoteRepositoryProperty(String remoteRepositoryId, String remoteRepositoryPropertyId) {
        this.removeProperty(this.getRemoteRepositoryPropertyName(remoteRepositoryId, remoteRepositoryPropertyId));
        this.removeProperty(this.getRemoteRepositoryPropertyValue(remoteRepositoryId, remoteRepositoryPropertyId));
        this.updateRemoteRepositoryPropertiesIds(remoteRepositoryId, remoteRepositoryPropertyId, 1);
    }

    public void removeRemoteRepository(String remoteRepositoryId) {
        String[] remoteRepositoriesPropertiesIdsList0;
        this.removeProperty(this.getRemoteRepositoryName(remoteRepositoryId));
        this.removeProperty(this.getRemoteRepositorySchema(remoteRepositoryId));
        this.removeProperty(this.getRemoteRepositoryAddress(remoteRepositoryId));
        Property remoteRepositoryPropertiesIdsProperty = this.getRemoteRepositoryPropertiesIds(remoteRepositoryId);
        String remoteRepositoriesPropertiesIds = remoteRepositoryPropertiesIdsProperty.getValue();
        for (String remoteRepositoriesPropertyId : remoteRepositoriesPropertiesIdsList0 = remoteRepositoriesPropertiesIds.split(LIST_ITEM_SEPARATOR)) {
            this.removeRemoteRepositoryProperty(remoteRepositoryId, remoteRepositoriesPropertyId);
        }
        this.removeProperty(remoteRepositoryPropertiesIdsProperty);
        this.updateRemoteRepositoriesIds(remoteRepositoryId, 1);
    }

    private List<Property> getVFSRemoteFileRepositoryProperties(String remoteRepositoryId) {
        ArrayList<Property> vfsRemoteFileRepositoryProperties = new ArrayList<Property>();
        String remoteRepositoryPropertiesIds = this.getRemoteRepositoryPropertiesIds(remoteRepositoryId).getValue();
        if (remoteRepositoryPropertiesIds != null && !remoteRepositoryPropertiesIds.isEmpty()) {
            String[] remoteRepositoryPropertiesIdsList;
            for (String remoteRepositoryPropertyId : remoteRepositoryPropertiesIdsList = remoteRepositoryPropertiesIds.split(LIST_ITEM_SEPARATOR)) {
                String remoteRepositoryPropertyName = this.getRemoteRepositoryPropertyName(remoteRepositoryId, remoteRepositoryPropertyId).getValue();
                String remoteRepositoryPropertyValue = this.getRemoteRepositoryPropertyValue(remoteRepositoryId, remoteRepositoryPropertyId).getValue();
                if (remoteRepositoryPropertyName == null || remoteRepositoryPropertyName.isEmpty() || remoteRepositoryPropertyValue == null || remoteRepositoryPropertyValue.isEmpty()) continue;
                vfsRemoteFileRepositoryProperties.add(new Property(remoteRepositoryPropertyName, remoteRepositoryPropertyValue));
            }
        }
        return vfsRemoteFileRepositoryProperties;
    }

    private boolean isUniqueRemoteRepositoryName(String newRemoteRepositoryName) {
        this.remoteRepositoriesIds = this.getRemoteRepositoriesIds().getValue();
        if (this.remoteRepositoriesIds != null && !this.remoteRepositoriesIds.isEmpty()) {
            String[] remoteRepositoriesIdsList;
            for (String remoteRepositoryId : remoteRepositoriesIdsList = this.remoteRepositoriesIds.split(LIST_ITEM_SEPARATOR)) {
                String remoteRepositoryName = this.getRemoteRepositoryName(remoteRepositoryId).getValue();
                if (remoteRepositoryName == null || !remoteRepositoryName.contentEquals(newRemoteRepositoryName)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUniqueRemoteRepositoryPropertyName(String remoteRepositoryId, String newRemoteRepositoryPropertyName) {
        String remoteRepositoryPropertiesIds = this.getRemoteRepositoryPropertiesIds(remoteRepositoryId).getValue();
        if (remoteRepositoryPropertiesIds != null && !remoteRepositoryPropertiesIds.isEmpty()) {
            String[] remoteRepositoriesPropertiesIdsList;
            for (String remoteRepositoryPropertyId : remoteRepositoriesPropertiesIdsList = remoteRepositoryPropertiesIds.split(LIST_ITEM_SEPARATOR)) {
                String remoteRepositoryPropertyName = this.getRemoteRepositoryPropertyName(remoteRepositoryId, remoteRepositoryPropertyId).getValue();
                if (remoteRepositoryPropertyName == null || !remoteRepositoryPropertyName.contentEquals(newRemoteRepositoryPropertyName)) continue;
                return false;
            }
        }
        return true;
    }
}

