/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.esa.snap.vfs.preferences.model.Property;
import org.esa.snap.vfs.preferences.model.VFSRemoteFileRepository;
import org.esa.snap.vfs.remote.AbstractRemoteFileSystemProvider;

public class VFS {
    private static final VFS instance = new VFS();
    private List<FileSystemProvider> installedProviders;

    private VFS() {
    }

    public static VFS getInstance() {
        return instance;
    }

    private List<FileSystemProvider> getInstalledProviders() {
        return this.installedProviders;
    }

    public FileSystemProvider getFileSystemProviderByScheme(String scheme) {
        for (FileSystemProvider fileSystemProvider : this.installedProviders) {
            if (!scheme.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
            return fileSystemProvider;
        }
        return null;
    }

    public void initRemoteInstalledProviders(List<VFSRemoteFileRepository> vfsRepositories) {
        for (FileSystemProvider fileSystemProvider : this.installedProviders) {
            if (!(fileSystemProvider instanceof AbstractRemoteFileSystemProvider)) continue;
            AbstractRemoteFileSystemProvider remoteFileSystemProvider = (AbstractRemoteFileSystemProvider)fileSystemProvider;
            for (VFSRemoteFileRepository repository : vfsRepositories) {
                if (!repository.getScheme().equalsIgnoreCase(remoteFileSystemProvider.getScheme())) continue;
                HashMap<String, String> connectionData = new HashMap<String, String>();
                for (Property vfsRemoteFileRepositoryProperty : repository.getProperties()) {
                    connectionData.put(vfsRemoteFileRepositoryProperty.getName(), vfsRemoteFileRepositoryProperty.getValue());
                }
                String fileSystemRoot = repository.getRoot();
                remoteFileSystemProvider.setConnectionData(fileSystemRoot, repository.getAddress(), connectionData);
                try {
                    remoteFileSystemProvider.getFileSystemOrCreate(new URI(repository.getScheme(), fileSystemRoot, null), null);
                }
                catch (URISyntaxException e) {
                    throw new ExceptionInInitializerError("Unable to initialize VFS with scheme: " + remoteFileSystemProvider.getScheme());
                }
            }
        }
    }

    public Path getPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Missing scheme.");
        }
        if (scheme.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uri);
        }
        for (FileSystemProvider provider : this.installedProviders) {
            if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
            return provider.getPath(uri);
        }
        throw new FileSystemNotFoundException("The file system provider with the scheme '" + scheme + "' is not installed.");
    }

    public Path get(String first, String ... more) {
        Path path = this.getVirtualPath(first, more);
        if (path != null) {
            return path;
        }
        return FileSystems.getDefault().getPath(first, more);
    }

    private Path getVirtualPath(String first, String ... more) {
        for (FileSystemProvider provider : VFS.getInstance().getInstalledProviders()) {
            AbstractRemoteFileSystemProvider remoteFileSystemProvider;
            Path path;
            if (!(provider instanceof AbstractRemoteFileSystemProvider) || (path = (remoteFileSystemProvider = (AbstractRemoteFileSystemProvider)provider).getPathIfFileSystemRootMatches(first, more)) == null) continue;
            return path;
        }
        return null;
    }

    private void loadInstalledProviders() {
        this.installedProviders = new ArrayList<FileSystemProvider>();
        HashSet<String> uniqueSchemes = new HashSet<String>();
        ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class);
        for (FileSystemProvider provider : serviceLoader) {
            if (!(provider instanceof AbstractRemoteFileSystemProvider)) continue;
            if (uniqueSchemes.add(provider.getScheme())) {
                this.installedProviders.add(provider);
                continue;
            }
            throw new IllegalStateException("The remote file system provider type '" + provider.getClass() + "' with the scheme '" + provider.getScheme() + "' is not unique.");
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (provider instanceof AbstractRemoteFileSystemProvider) continue;
            if (uniqueSchemes.add(provider.getScheme())) {
                this.installedProviders.add(provider);
                continue;
            }
            throw new IllegalStateException("The default file system provider type '" + provider.getClass() + "' with the scheme '" + provider.getScheme() + "' is not unique.");
        }
    }

    static {
        instance.loadInstalledProviders();
    }
}

