/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.vfs;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.vfs.NioPaths;

public class NioFile
extends File {
    private static final String INVALID_FILE_PATH_ERROR_MESSAGE = "Invalid file path.";
    private static Logger logger = Logger.getLogger(NioFile.class.getName());
    private final Path path;
    private transient PathStatus status;

    public NioFile(Path path) {
        super(path.toString());
        this.path = path;
    }

    public NioFile(String pathname) {
        this(NioPaths.get(pathname, new String[0]));
    }

    private static String slashify(Path path, boolean isDirectory) {
        Object p = path.toString();
        if (!path.getFileSystem().getSeparator().equals("/")) {
            p = ((String)p).replace(path.getFileSystem().getSeparator(), "/");
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (!((String)p).endsWith("/") && isDirectory) {
            p = (String)p + "/";
        }
        return p;
    }

    private boolean isInvalidPath() {
        if (this.status == null) {
            this.status = this.path.toString().indexOf(0) < 0 ? PathStatus.CHECKED : PathStatus.INVALID;
        }
        return this.status == PathStatus.INVALID;
    }

    @Override
    public String getName() {
        Path fileName = this.path.getFileName();
        String name = "";
        if (fileName != null && (name = ((Object)fileName).toString()).endsWith(this.path.getFileSystem().getSeparator())) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public String getParent() {
        Path parent = this.path.getParent();
        return parent != null ? parent.toString() : null;
    }

    @Override
    public File getParentFile() {
        Path p = this.path.getParent();
        if (p != null) {
            try {
                return new NioFile(p);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to get the parent file path of path: " + this.path.toString() + ". Details: " + ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    @Override
    public String getAbsolutePath() {
        return this.path.resolve(this.path).toString();
    }

    private Path _getAbsolutePath() {
        return this.path.resolve(this.path);
    }

    @Override
    public File getAbsoluteFile() {
        Path absPath = this._getAbsolutePath();
        try {
            return new NioFile(absPath);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to get the absolute form of abstract pathname: " + absPath.toString() + ". Details: " + ex.getMessage());
            return new File(absPath.toString());
        }
    }

    @Override
    public String getCanonicalPath() throws IOException {
        if (this.isInvalidPath()) {
            throw new IOException(INVALID_FILE_PATH_ERROR_MESSAGE);
        }
        return this.getAbsoluteFile().toPath().resolve(this.path).toString();
    }

    private Path getCanonicalPath0() throws IOException {
        if (this.isInvalidPath()) {
            throw new IOException(INVALID_FILE_PATH_ERROR_MESSAGE);
        }
        return this.getAbsoluteFile().toPath().resolve(this.path);
    }

    @Override
    public File getCanonicalFile() throws IOException {
        Path canonPath = this.getCanonicalPath0();
        try {
            return new NioFile(canonPath);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to get the canonical form of abstract pathname:" + canonPath.toString() + ". Details: " + ex.getMessage());
            return new File(canonPath.toString());
        }
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        if (this.isInvalidPath()) {
            throw new MalformedURLException(INVALID_FILE_PATH_ERROR_MESSAGE);
        }
        return new URL(this.path.toUri().getScheme(), "", NioFile.slashify(this._getAbsolutePath(), this.isDirectory()));
    }

    @Override
    public URI toURI() {
        return this.path.getFileSystem().getPath(NioFile.slashify(this._getAbsolutePath(), this.isDirectory()), new String[0]).toUri();
    }

    @Override
    public boolean canRead() {
        return !this.isInvalidPath() && Files.isReadable(this.path);
    }

    @Override
    public boolean canWrite() {
        return !this.isInvalidPath() && Files.isWritable(this.path);
    }

    @Override
    public boolean exists() {
        return !this.isInvalidPath() && this.canRead() && Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory() {
        return !this.isInvalidPath() && this.canRead() && Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isFile() {
        return !this.isInvalidPath() && this.canRead() && Files.isRegularFile(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isHidden() {
        try {
            return !this.isInvalidPath() && this.canRead() && Files.isHidden(this.path);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to check if path: " + this.path.toString() + " is hidden. Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public long lastModified() {
        if (this.isInvalidPath()) {
            return 0L;
        }
        try {
            if (!this.canRead()) {
                throw new SecurityException();
            }
            return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to get the time that the file denoted by path: " + this.path.toString() + " was last modified. Details: " + ex.getMessage(), ex);
            return 0L;
        }
    }

    @Override
    public long length() {
        if (this.isInvalidPath()) {
            return 0L;
        }
        try {
            if (!this.canRead()) {
                throw new SecurityException();
            }
            return Files.size(this.path);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to get the length of the file denoted by path: " + this.path.toString() + ". Details: " + ex.getMessage());
            return 0L;
        }
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.isInvalidPath()) {
            throw new IOException(INVALID_FILE_PATH_ERROR_MESSAGE);
        }
        Files.createFile(this.path, new FileAttribute[0]);
        return this.canWrite();
    }

    @Override
    public boolean delete() {
        if (this.isInvalidPath()) {
            return false;
        }
        try {
            return this.canWrite() && Files.deleteIfExists(this.path);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to delete the file or directory denoted by path: " + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public void deleteOnExit() {
        throw new SecurityException(new UnsupportedOperationException());
    }

    public String[] list(DirectoryStream.Filter<Path> filter) {
        if (this.isInvalidPath()) {
            return new String[0];
        }
        ArrayList<String> files = new ArrayList<String>();
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            String[] stringArray;
            block11: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(this.path, filter);
                try {
                    for (Path currentPath : stream) {
                        files.add(currentPath.getFileName().toString());
                    }
                    stringArray = files.toArray(new String[0]);
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Unable to browse the path: " + this.path.toString() + " and get an array of strings naming the files and directories in the directory path. Details: " + ex.getMessage());
                    }
                }
                stream.close();
            }
            return stringArray;
        }
        return new String[0];
    }

    @Override
    public String[] list() {
        DirectoryStream.Filter<Path> newFilter = entry -> true;
        return this.list(newFilter);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        DirectoryStream.Filter<Path> newFilter = entry -> !filter.accept(this, new File(entry.toString()).getName());
        return this.list(newFilter);
    }

    private File[] listFiles(DirectoryStream.Filter<Path> filter) {
        ArrayList<File> files = new ArrayList<File>();
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            File[] fileArray;
            block10: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(this.path, filter);
                try {
                    for (Path currentPath : stream) {
                        files.add(currentPath.toFile());
                    }
                    fileArray = files.toArray(new File[0]);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Unable to browse the path: " + this.path.toString() + " and get an array of path names denoting the files and directories in the directory path. Details: " + ex.getMessage());
                    }
                }
                stream.close();
            }
            return fileArray;
        }
        return new File[0];
    }

    @Override
    public File[] listFiles() {
        DirectoryStream.Filter<Path> newFilter = entry -> true;
        return this.listFiles(newFilter);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        DirectoryStream.Filter<Path> newFilter = entry -> !filter.accept(this, new File(entry.toString()).getName());
        return this.listFiles(newFilter);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        DirectoryStream.Filter<Path> newFilter = entry -> !filter.accept(new File(entry.toString()));
        return this.listFiles(newFilter);
    }

    @Override
    public boolean mkdir() {
        try {
            Files.createDirectory(this.path, new FileAttribute[0]);
            return this.canRead();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to create the directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        File canonFile;
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        try {
            canonFile = this.getCanonicalFile();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to create the directory named by abstract pathname:" + this.path.toString() + ", including any necessary but nonexistent parent directories. Details: " + ex.getMessage());
            return false;
        }
        File parent = canonFile.getParentFile();
        return parent != null && (parent.mkdirs() || parent.exists()) && canonFile.mkdir();
    }

    @Override
    public boolean renameTo(File dest) {
        if (dest == null) {
            throw new NullPointerException();
        }
        try {
            return !this.isInvalidPath() && !((NioFile)dest).isInvalidPath() && !Files.move(this.path, this.path.resolveSibling(dest.toPath()), new CopyOption[0]).toString().isEmpty();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to rename the directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        try {
            Files.setLastModifiedTime(this.path, FileTime.fromMillis(time));
            return !this.isInvalidPath();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to set last-modified time of the file or directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            Files.setPosixFilePermissions(this.path, perms);
            return !this.isInvalidPath();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to mark the file or directory named by abstract pathname:" + this.path.toString() + ", so that only read operations are allowed. Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            if (writable) {
                perms.add(PosixFilePermission.OWNER_WRITE);
                if (!ownerOnly) {
                    perms.add(PosixFilePermission.GROUP_WRITE);
                    perms.add(PosixFilePermission.OTHERS_WRITE);
                }
            }
            Files.setPosixFilePermissions(this.path, perms);
            return !this.isInvalidPath();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable set the owner's or everybody's write permission for the file or directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            if (readable) {
                perms.add(PosixFilePermission.OWNER_READ);
                if (!ownerOnly) {
                    perms.add(PosixFilePermission.GROUP_READ);
                    perms.add(PosixFilePermission.OTHERS_READ);
                }
            }
            Files.setPosixFilePermissions(this.path, perms);
            return !this.isInvalidPath();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable set the owner's or everybody's read permission for the file or directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            if (executable) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                if (!ownerOnly) {
                    perms.add(PosixFilePermission.GROUP_EXECUTE);
                    perms.add(PosixFilePermission.OTHERS_EXECUTE);
                }
            }
            Files.setPosixFilePermissions(this.path, perms);
            return !this.isInvalidPath();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable set the owner's or everybody's execute permission for the file or directory named by abstract pathname:" + this.path.toString() + ". Details: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    @Override
    public boolean canExecute() {
        return !this.isInvalidPath() && Files.isExecutable(this.path);
    }

    @Override
    public long getTotalSpace() {
        if (this.isInvalidPath() || !this.canRead()) {
            return 0L;
        }
        try {
            return this.path.getFileSystem().provider().getFileStore(this.path).getTotalSpace();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to get the size of physical memory unit where file or directory named by abstract pathname:" + this.path.toString() + " exists. Details: " + ex.getMessage());
            return 0L;
        }
    }

    @Override
    public long getFreeSpace() {
        if (this.isInvalidPath() || !this.canRead()) {
            return 0L;
        }
        try {
            return this.path.getFileSystem().provider().getFileStore(this.path).getUnallocatedSpace();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to get the number of unallocated bytes in the physical memory unit where file or directory named by abstract pathname:" + this.path.toString() + " exists. Details: " + ex.getMessage());
            return 0L;
        }
    }

    @Override
    public long getUsableSpace() {
        if (this.isInvalidPath() || !this.canRead()) {
            return 0L;
        }
        try {
            return this.path.getFileSystem().provider().getFileStore(this.path).getUsableSpace();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Unable to get the number of bytes available to this virtual machine in the physical memory unit where file or directory named by abstract pathname:" + this.path.toString() + " exists. Details: " + ex.getMessage());
            return 0L;
        }
    }

    @Override
    public int compareTo(File pathname) {
        return this.path.compareTo(pathname.toPath());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NioFile) {
            return this.path.getClass().equals(((NioFile)obj).path.getClass()) && this.compareTo((File)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public Path toPath() {
        return this.path;
    }

    private static enum PathStatus {
        INVALID,
        CHECKED;

    }
}

