/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.util;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteredListModel<T>
extends AbstractListModel {
    private final ListModel<T> sourceModel;
    private Filter<T> filter;
    private final ArrayList<Integer> indices = new ArrayList();

    public FilteredListModel(ListModel<T> source) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this.sourceModel = source;
        this.sourceModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }
        });
    }

    public void setFilter(Filter<T> f) {
        this.filter = f;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                FilteredListModel.this.doFilter();
                return null;
            }

            @Override
            protected void done() {
                FilteredListModel.this.fireContentsChanged(this, 0, FilteredListModel.this.getSize() - 1);
            }
        };
        worker.execute();
    }

    private void doFilter() {
        this.indices.clear();
        Filter<T> f = this.filter;
        if (f != null) {
            int count = this.sourceModel.getSize();
            for (int i = 0; i < count; ++i) {
                T element = this.sourceModel.getElementAt(i);
                if (!f.accept(element)) continue;
                this.indices.add(i);
            }
        }
    }

    @Override
    public int getSize() {
        return this.filter != null ? this.indices.size() : this.sourceModel.getSize();
    }

    @Override
    public T getElementAt(int index) {
        return this.filter != null ? this.sourceModel.getElementAt(this.indices.get(index)) : this.sourceModel.getElementAt(index);
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

