/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tool;

import com.bc.ceres.swing.BrightBlueImageFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.esa.snap.ui.UIUtils;

public class ToolButtonFactory {
    public static final Color SELECTED_BORDER_COLOR = new Color(8, 36, 107);
    private static final Color SELECTED_BACKGROUND_COLOR = new Color(130, 146, 185);
    private static final Color ROLLOVER_BACKGROUND_COLOR = new Color(181, 190, 214);
    private static final int BUTTON_MIN_SIZE = 16;
    private static ImageIcon _separatorIcon;

    public static AbstractButton createButton(Icon icon, boolean toggle) {
        AbstractButton button = ToolButtonFactory.createButton(toggle);
        button.setIcon(icon);
        ToolButtonFactory.configure(button);
        return button;
    }

    public static AbstractButton createButton(Action action, boolean toggle) {
        AbstractButton button = ToolButtonFactory.createButton(toggle);
        ToolButtonFactory.setButtonName(button, action);
        button.setAction(action);
        ToolButtonFactory.configure(button);
        return button;
    }

    private static AbstractButton createButton(boolean toggle) {
        if (toggle) {
            return new JToggleButton();
        }
        return new JButton();
    }

    private static void configure(AbstractButton button) {
        RolloverButtonEventListener l = new RolloverButtonEventListener();
        button.addMouseListener(l);
        button.addItemListener(l);
        if (button.getAction() != null) {
            Object largeIcon;
            if (button.getIcon() != null) {
                button.putClientProperty("hideActionText", Boolean.TRUE);
            }
            if ((largeIcon = button.getAction().getValue("_largeIcon")) instanceof Icon) {
                button.setIcon((Icon)largeIcon);
            }
        }
        Icon icon = button.getIcon();
        int minWidth = 16;
        int minHeight = 16;
        if (icon != null) {
            button.setText(null);
            minWidth = Math.max(icon.getIconWidth(), 16);
            minHeight = Math.max(icon.getIconHeight(), 16);
            if (icon instanceof ImageIcon) {
                button.setRolloverIcon(ToolButtonFactory.createRolloverIcon((ImageIcon)icon));
            }
        } else {
            button.setText("[?]");
        }
        int space = 3;
        Dimension prefSize = new Dimension(minWidth + 3, minHeight + 3);
        Dimension minSize = new Dimension(minWidth, minHeight);
        Dimension maxSize = new Dimension(minWidth + 3, minHeight + 3);
        button.setPreferredSize(prefSize);
        button.setMaximumSize(maxSize);
        button.setMinimumSize(minSize);
    }

    public static JComponent createToolBarSeparator() {
        if (_separatorIcon == null) {
            _separatorIcon = UIUtils.loadImageIcon("icons/Separator24.gif");
        }
        return new JLabel(_separatorIcon);
    }

    public static ImageIcon createRolloverIcon(ImageIcon imageIcon) {
        return new ImageIcon(ToolButtonFactory.createRolloverImage(imageIcon.getImage()));
    }

    private static Image createRolloverImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), (ImageFilter)new BrightBlueImageFilter()));
    }

    private static void setButtonName(AbstractButton button, Action action) {
        if (button.getName() == null) {
            String name = null;
            Object value = action.getValue("ActionCommandKey");
            if (value != null) {
                name = value.toString();
            } else {
                value = action.getValue("Name");
                if (value != null) {
                    name = value.toString();
                }
            }
            if (name != null) {
                button.setName(name);
            }
        }
    }

    private static class RolloverButtonEventListener
    extends MouseAdapter
    implements ItemListener {
        public AbstractButton getButton(EventObject e) {
            return (AbstractButton)e.getSource();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setSelectedState(this.getButton(e));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setDefaultState(this.getButton(e));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setRolloverStateState(this.getButton(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setDefaultState(this.getButton(e));
        }

        private void setDefaultState(AbstractButton b) {
            if (b.isSelected()) {
                this.setSelectedState(b);
            } else {
                this.setNormalState(b);
            }
        }

        private void setNormalState(AbstractButton b) {
            b.setBorderPainted(false);
            b.setBackground(this.getDefaultBackground());
        }

        private void setSelectedState(AbstractButton b) {
            if (b.isEnabled()) {
                b.setBorderPainted(true);
                b.setBackground(SELECTED_BACKGROUND_COLOR);
            } else {
                b.setBorderPainted(false);
                b.setBackground(this.getDefaultBackground().darker());
            }
        }

        private void setRolloverStateState(AbstractButton b) {
            if (b.isEnabled()) {
                b.setBorderPainted(true);
                b.setBackground(ROLLOVER_BACKGROUND_COLOR);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.setDefaultState((AbstractButton)e.getSource());
        }

        private Color getDefaultBackground() {
            String[] keys;
            Color color = null;
            for (String key : keys = new String[]{"Button.background", "Label.background", "Panel.background"}) {
                color = UIManager.getLookAndFeel().getDefaults().getColor(key);
            }
            if (color == null) {
                color = new Color(238, 238, 238);
            }
            return color;
        }
    }
}

