/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.spectrum;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;

class SpectrumSelectionAdmin {
    private List<List<Boolean>> bandSelectionStates = new ArrayList<List<Boolean>>();
    private List<Integer> numbersOfSelectedBands = new ArrayList<Integer>();
    private List<Integer> currentStates = new ArrayList<Integer>();

    SpectrumSelectionAdmin() {
    }

    void evaluateSpectrumSelections(DisplayableSpectrum spectrum) {
        ArrayList<Boolean> selected = new ArrayList<Boolean>();
        int numberOfSelectedBands = 0;
        for (int i = 0; i < spectrum.getSpectralBands().length; ++i) {
            boolean bandSelected = spectrum.isBandSelected(i);
            selected.add(bandSelected);
            if (!bandSelected) continue;
            ++numberOfSelectedBands;
        }
        this.bandSelectionStates.add(selected);
        this.numbersOfSelectedBands.add(numberOfSelectedBands);
        this.currentStates.add(-1);
        this.evaluateState(this.bandSelectionStates.size() - 1);
    }

    boolean isBandSelected(int row, int i) {
        if (this.currentStates.get(row) == 2) {
            return this.bandSelectionStates.get(row).get(i);
        }
        return this.currentStates.get(row) == 1;
    }

    private void evaluateState(int index) {
        Integer numberOfBands = this.numbersOfSelectedBands.get(index);
        if (numberOfBands == 0) {
            this.currentStates.set(index, 0);
        } else if (numberOfBands.intValue() == this.bandSelectionStates.get(index).size()) {
            this.currentStates.set(index, 1);
        } else {
            this.currentStates.set(index, 2);
        }
    }

    int getState(int index) {
        return this.currentStates.get(index);
    }

    boolean isSpectrumSelected(int row) {
        return this.currentStates.get(row) != 0;
    }

    void setBandSelected(int row, int bandRow, boolean selected) {
        if (this.isBandSelected(row, bandRow) != selected) {
            this.updateBandSelections(row, bandRow, selected);
            this.updateNumberOfSelectedBands(selected, row);
            this.evaluateState(row);
        }
    }

    private void updateBandSelections(int row, int bandRow, boolean selected) {
        this.bandSelectionStates.get(row).set(bandRow, selected);
        if (this.currentStates.get(row) != 2) {
            for (int i = 0; i < this.bandSelectionStates.get(row).size(); ++i) {
                if (i == bandRow) continue;
                this.bandSelectionStates.get(row).set(i, !selected);
            }
        }
    }

    void updateSpectrumSelectionState(int row, int newState) {
        if (newState == 2 && (this.numbersOfSelectedBands.get(row).intValue() == this.bandSelectionStates.get(row).size() || this.numbersOfSelectedBands.get(row) == 0)) {
            newState = 0;
        }
        this.currentStates.set(row, newState);
    }

    private void updateNumberOfSelectedBands(Boolean selected, int row) {
        if (this.currentStates.get(row) == 2) {
            if (selected.booleanValue()) {
                this.numbersOfSelectedBands.set(row, this.numbersOfSelectedBands.get(row) + 1);
            } else {
                this.numbersOfSelectedBands.set(row, this.numbersOfSelectedBands.get(row) - 1);
            }
        } else if (selected.booleanValue()) {
            this.numbersOfSelectedBands.set(row, 1);
        } else {
            this.numbersOfSelectedBands.set(row, this.bandSelectionStates.get(row).size() - 1);
        }
    }
}

