/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.operation.TransformException;

public class TrackLayerType
extends VectorDataLayerType {
    public static boolean isTrackPointNode(VectorDataNode node) {
        Object trackPoints = node.getFeatureType().getUserData().get("trackPoints");
        return trackPoints != null && trackPoints.toString().equals("true");
    }

    @Override
    protected VectorDataLayer createLayer(VectorDataNode vectorDataNode, RasterDataNode rasterDataNode, PropertySet configuration) {
        return new TrackLayer(this, vectorDataNode, (SceneTransformProvider)rasterDataNode, configuration);
    }

    public static class TrackLayer
    extends VectorDataLayer {
        public static final Color STROKE_COLOR = Color.ORANGE;
        public static final double STROKE_OPACITY = 0.8;
        public static final double STROKE_WIDTH = 2.0;
        public static final double FILL_OPACITY = 0.5;
        public static final Color FILL_COLOR = Color.WHITE;
        private final Paint strokePaint;
        private final SceneTransformProvider sceneTransformProvider;

        public TrackLayer(VectorDataLayerType vectorDataLayerType, VectorDataNode vectorDataNode, SceneTransformProvider provider, PropertySet configuration) {
            super(vectorDataLayerType, vectorDataNode, provider, configuration);
            String styleCss = vectorDataNode.getDefaultStyleCss();
            DefaultFigureStyle style = new DefaultFigureStyle(styleCss);
            style.fromCssString(styleCss);
            style.setSymbolName("circle");
            style.setStrokeColor(STROKE_COLOR);
            style.setStrokeWidth(2.0);
            style.setStrokeOpacity(0.8);
            style.setFillColor(FILL_COLOR);
            style.setFillOpacity(0.5);
            this.strokePaint = style.getStrokePaint();
            vectorDataNode.setDefaultStyleCss(style.toCssString());
            this.sceneTransformProvider = provider;
        }

        @Override
        protected void renderLayer(Rendering rendering) {
            this.drawTrackPointConnections(rendering);
            super.renderLayer(rendering);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawTrackPointConnections(Rendering rendering) {
            Graphics2D g = rendering.getGraphics();
            AffineTransform oldTransform = g.getTransform();
            try {
                g.transform(rendering.getViewport().getModelToViewTransform());
                this.drawTrackPointConnections0(rendering);
            }
            finally {
                g.setTransform(oldTransform);
            }
        }

        private void drawTrackPointConnections0(Rendering rendering) {
            rendering.getGraphics().setPaint(this.strokePaint);
            float scalingFactor = (float)rendering.getViewport().getViewToModelTransform().getScaleX();
            float effectiveStrokeWidth = (float)((double)scalingFactor * 2.0);
            float effectiveDash = Math.max(1.0f, scalingFactor * 5.0f);
            float effectiveMeterLimit = Math.max(1.0f, scalingFactor * 10.0f);
            BasicStroke basicStroke = new BasicStroke(effectiveStrokeWidth, 2, 0, effectiveMeterLimit, new float[]{effectiveDash, effectiveDash}, 0.0f);
            rendering.getGraphics().setStroke(basicStroke);
            SimpleFeature[] features = (SimpleFeature[])this.getVectorDataNode().getFeatureCollection().toArray((Object[])new SimpleFeature[0]);
            double lastX = 0.0;
            double lastY = 0.0;
            for (int i = 0; i < features.length; ++i) {
                SimpleFeature feature = features[i];
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                Point centroid = geometry.getCentroid();
                try {
                    Point2D.Double sceneCoords = new Point2D.Double(centroid.getX(), centroid.getY());
                    Point2D.Double modelCoords = new Point2D.Double();
                    this.sceneTransformProvider.getSceneToModelTransform().transform((Point2D)sceneCoords, (Point2D)modelCoords);
                    if (i > 0) {
                        rendering.getGraphics().draw(new Line2D.Double(lastX, lastY, centroid.getX(), centroid.getY()));
                    }
                    lastX = modelCoords.getX();
                    lastY = modelCoords.getY();
                    continue;
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
        }
    }
}

