/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.swing.figure.AbstractShapeFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import java.awt.Shape;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.util.AwtGeomToJtsGeomConverter;
import org.esa.snap.core.util.Debug;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class SimpleFeatureShapeFigure
extends AbstractShapeFigure
implements SimpleFeatureFigure {
    private SimpleFeature simpleFeature;
    private Shape shape;
    private final Class<?> geometryType;
    private SceneTransformProvider sceneTransformProvider;
    private static final Shape EMPTY_SHAPE = new java.awt.Polygon(new int[0], new int[0], 0);

    public SimpleFeatureShapeFigure(SimpleFeature simpleFeature, SceneTransformProvider provider, FigureStyle style) {
        this(simpleFeature, provider, style, style);
    }

    public SimpleFeatureShapeFigure(SimpleFeature simpleFeature, SceneTransformProvider provider, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(SimpleFeatureShapeFigure.getRank(simpleFeature), normalStyle, selectedStyle);
        this.simpleFeature = simpleFeature;
        this.geometryType = simpleFeature.getDefaultGeometry().getClass();
        this.shape = null;
        this.sceneTransformProvider = provider;
    }

    public Object createMemento() {
        return this.getGeometry().clone();
    }

    public void setMemento(Object memento) {
        this.simpleFeature.setDefaultGeometry(memento);
        this.forceRegeneration();
        this.fireFigureChanged();
    }

    @Override
    public SimpleFeature getSimpleFeature() {
        return this.simpleFeature;
    }

    @Override
    public Geometry getGeometry() {
        return (Geometry)this.simpleFeature.getDefaultGeometry();
    }

    @Override
    public void setGeometry(Geometry geometry) {
        if (!this.geometryType.isAssignableFrom(geometry.getClass())) {
            Debug.trace((String)("WARNING: Assigning a geometry of type " + geometry.getClass() + ", should actually be a " + this.geometryType));
        }
        this.simpleFeature.setDefaultGeometry((Object)geometry);
        this.forceRegeneration();
        this.fireFigureChanged();
    }

    public Shape getShape() {
        if (this.shape == null) {
            Geometry featureGeometry = (Geometry)this.simpleFeature.getDefaultGeometry();
            try {
                Geometry modelGeometry = this.sceneTransformProvider.getSceneToModelTransform().transform(featureGeometry);
                this.shape = new LiteShape2(modelGeometry, null, null, true);
            }
            catch (FactoryException | TransformException e) {
                return EMPTY_SHAPE;
            }
        }
        return this.shape;
    }

    @Override
    public void forceRegeneration() {
        this.shape = null;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        Geometry modelGeometry = this.getGeometryFromShape(shape);
        try {
            Geometry sceneGeometry = this.sceneTransformProvider.getModelToSceneTransform().transform(modelGeometry);
            this.simpleFeature.setDefaultGeometry((Object)sceneGeometry);
            this.fireFigureChanged();
        }
        catch (TransformException e) {
            this.shape = null;
        }
    }

    private Geometry getGeometryFromShape(Shape shape) {
        AwtGeomToJtsGeomConverter converter = new AwtGeomToJtsGeomConverter();
        Object geometry = Polygon.class.isAssignableFrom(this.geometryType) ? converter.createPolygon(shape) : (MultiPolygon.class.isAssignableFrom(this.geometryType) ? converter.createMultiPolygon(shape) : (LinearRing.class.isAssignableFrom(this.geometryType) ? (Geometry)converter.createLinearRingList(shape).get(0) : (LineString.class.isAssignableFrom(this.geometryType) ? (Geometry)converter.createLineStringList(shape).get(0) : converter.createMultiLineString(shape))));
        return geometry;
    }

    public Object clone() {
        SimpleFeatureShapeFigure clone = (SimpleFeatureShapeFigure)super.clone();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.simpleFeature.getFeatureType());
        builder.init(this.simpleFeature);
        clone.simpleFeature = builder.buildFeature(null);
        clone.simpleFeature.setDefaultGeometry(this.getGeometry().clone());
        clone.shape = this.getShape();
        return clone;
    }

    static Figure.Rank getRank(SimpleFeature simpleFeature) {
        Object geometry = simpleFeature.getDefaultGeometry();
        if (!(geometry instanceof Geometry)) {
            throw new IllegalArgumentException("simpleFeature: geometry type must be a " + Geometry.class);
        }
        return SimpleFeatureShapeFigure.getRank((Geometry)geometry);
    }

    static Figure.Rank getRank(Geometry geometry) {
        if (geometry instanceof Puntal) {
            return Figure.Rank.POINT;
        }
        if (geometry instanceof Lineal) {
            return Figure.Rank.LINE;
        }
        if (geometry instanceof Polygonal) {
            return Figure.Rank.AREA;
        }
        return Figure.Rank.NOT_SPECIFIED;
    }
}

