/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.PointFigure;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.util.AwtGeomToJtsGeomConverter;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.esa.snap.ui.product.SimpleFeaturePointFigure;
import org.esa.snap.ui.product.SimpleFeatureShapeFigure;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.TransformException;

public class SimpleFeatureFigureFactory
implements FigureFactory {
    private final SimpleFeatureType simpleFeatureType;
    private final AwtGeomToJtsGeomConverter toJtsGeom;
    private long currentFeatureId;
    private SceneTransformProvider sceneTransformProvider;

    public SimpleFeatureFigureFactory(SimpleFeatureType simpleFeatureType, SceneTransformProvider provider) {
        this.simpleFeatureType = simpleFeatureType;
        this.toJtsGeom = new AwtGeomToJtsGeomConverter();
        this.currentFeatureId = System.nanoTime();
        this.sceneTransformProvider = provider;
    }

    public PointFigure createPointFigure(Point2D point, FigureStyle style) {
        Point point1 = this.toJtsGeom.createPoint(point);
        return this.createPointFigure(point1, style);
    }

    public ShapeFigure createLineFigure(Shape shape, FigureStyle style) {
        Geometry geometryInSceneCoords;
        MultiLineString multiLineString;
        MultiLineString geometry = multiLineString = this.toJtsGeom.createMultiLineString(shape);
        if (multiLineString.getNumGeometries() == 1) {
            geometry = multiLineString.getGeometryN(0);
        }
        try {
            geometryInSceneCoords = this.sceneTransformProvider.getModelToSceneTransform().transform((Geometry)geometry);
        }
        catch (TransformException e) {
            return null;
        }
        return this.createShapeFigure(geometryInSceneCoords, style);
    }

    public ShapeFigure createPolygonFigure(Shape shape, FigureStyle style) {
        Polygon geometry = this.toJtsGeom.createPolygon(shape);
        try {
            geometry = this.sceneTransformProvider.getModelToSceneTransform().transform((Geometry)geometry);
        }
        catch (TransformException e) {
            return null;
        }
        return this.createShapeFigure((Geometry)geometry, style);
    }

    private PointFigure createPointFigure(Point geometry, FigureStyle style) {
        return new SimpleFeaturePointFigure(this.createSimpleFeature((Geometry)geometry), this.sceneTransformProvider, style);
    }

    public SimpleFeatureFigure createSimpleFeatureFigure(SimpleFeature simpleFeature, String defaultStyleCss) {
        String css = SimpleFeatureFigureFactory.getStyleCss(simpleFeature, defaultStyleCss);
        FigureStyle normalStyle = DefaultFigureStyle.createFromCss((String)css);
        FigureStyle selectedStyle = this.deriveSelectedStyle(normalStyle);
        Object geometry = simpleFeature.getDefaultGeometry();
        if (geometry instanceof Point) {
            return new SimpleFeaturePointFigure(simpleFeature, this.sceneTransformProvider, normalStyle, selectedStyle);
        }
        return new SimpleFeatureShapeFigure(simpleFeature, this.sceneTransformProvider, normalStyle, selectedStyle);
    }

    static String getStyleCss(SimpleFeature simpleFeature, String defaultStyleCss) {
        String css;
        Object styleAttribute = simpleFeature.getAttribute("style_css");
        if (styleAttribute instanceof String && !(css = (String)styleAttribute).trim().isEmpty()) {
            String[] cssAttributes;
            StringBuilder sb = new StringBuilder(css);
            for (String cssAttribute : cssAttributes = defaultStyleCss.split(";")) {
                if (css.contains(cssAttribute.split(":")[0].trim())) continue;
                sb.append(";");
                sb.append(cssAttribute);
            }
            return sb.toString();
        }
        return defaultStyleCss;
    }

    private ShapeFigure createShapeFigure(Geometry geometry, FigureStyle style) {
        return new SimpleFeatureShapeFigure(this.createSimpleFeature(geometry), this.sceneTransformProvider, style, this.deriveSelectedStyle(style));
    }

    private SimpleFeature createSimpleFeature(Geometry geometry) {
        return PlainFeatureFactory.createPlainFeature((SimpleFeatureType)this.simpleFeatureType, (String)("ID" + Long.toHexString(this.currentFeatureId++)), (Geometry)geometry, null);
    }

    public FigureStyle deriveSelectedStyle(FigureStyle style) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle();
        figureStyle.setFillColor(style.getFillColor());
        figureStyle.setFillOpacity(style.getFillOpacity());
        figureStyle.setStrokeColor(Color.YELLOW);
        figureStyle.setStrokeOpacity(0.75);
        figureStyle.setStrokeWidth(style.getStrokeWidth() + 1.0);
        figureStyle.setSymbolName(style.getSymbolName());
        figureStyle.setSymbolImagePath(style.getSymbolImagePath());
        figureStyle.setSymbolRefX(style.getSymbolRefX());
        figureStyle.setSymbolRefY(style.getSymbolRefY());
        return figureStyle;
    }
}

