/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.BufferedImageRendering;
import com.bc.ceres.grender.support.DefaultViewport;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.image.ColoredBandImageMultiLevelSource;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.param.ParamChangeEvent;
import org.esa.snap.core.param.ParamChangeListener;
import org.esa.snap.core.param.ParamGroup;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.SliderBoxImageDisplay;
import org.esa.snap.ui.UIUtils;

public class ProductSubsetDialog
extends ModalDialog {
    private static final String MEM_LABEL_TEXT = "Estimated, raw storage size: ";
    private static final Color MEM_LABEL_WARN_COLOR = Color.red;
    private static final Color MEM_LABEL_NORM_COLOR = Color.black;
    private static final int MAX_THUMBNAIL_WIDTH = 148;
    private static final int MIN_SUBSET_SIZE = 1;
    private static final Font SMALL_PLAIN_FONT = new Font("SansSerif", 0, 10);
    private static final Font SMALL_ITALIC_FONT = SMALL_PLAIN_FONT.deriveFont(2);
    private Product product;
    private ProductSubsetDef productSubsetDef;
    private ProductSubsetDef givenProductSubsetDef;
    private JLabel memLabel;
    private SpatialSubsetPane spatialSubsetPane;
    private ProductNodeSubsetPane bandSubsetPane;
    private ProductNodeSubsetPane tiePointGridSubsetPane;
    private ProductNodeSubsetPane metadataSubsetPane;
    private double memWarnLimit;
    private static final double DEFAULT_MEM_WARN_LIMIT = 1000.0;
    private AtomicBoolean updatingUI;

    public ProductSubsetDialog(Window window, Product product) {
        this(window, product, 1000.0);
    }

    public ProductSubsetDialog(Window window, Product product, double memWarnLimit) {
        this(window, product, null, memWarnLimit);
    }

    public ProductSubsetDialog(Window window, Product product, ProductSubsetDef productSubsetDef) {
        this(window, product, productSubsetDef, 1000.0);
    }

    public ProductSubsetDialog(Window window, Product product, ProductSubsetDef productSubsetDef, double memWarnLimit) {
        super(window, "Specify Product Subset", 161, "subsetDialog");
        Guardian.assertNotNull((String)"product", (Object)product);
        this.product = product;
        this.givenProductSubsetDef = productSubsetDef;
        this.productSubsetDef = new ProductSubsetDef("undefined");
        this.memWarnLimit = memWarnLimit;
        this.updatingUI = new AtomicBoolean(false);
        this.createUI();
    }

    public Product getProduct() {
        return this.product;
    }

    public ProductSubsetDef getProductSubsetDef() {
        return this.productSubsetDef;
    }

    @Override
    protected void onOK() {
        boolean ok = this.checkReferencedRastersIncluded();
        if (!ok) {
            return;
        }
        ok = this.checkFlagDatasetIncluded();
        if (!ok) {
            return;
        }
        this.spatialSubsetPane.cancelThumbnailLoader();
        if (this.productSubsetDef != null && this.productSubsetDef.isEntireProductSelected()) {
            this.productSubsetDef = null;
        }
        super.onOK();
    }

    private boolean checkReferencedRastersIncluded() {
        TreeSet<String> notIncludedNames = new TreeSet<String>();
        String[] nodeNames = this.productSubsetDef.getNodeNames();
        if (nodeNames != null) {
            List<String> includedNodeNames = Arrays.asList(nodeNames);
            for (String string : includedNodeNames) {
                RasterDataNode rasterDataNode = this.product.getRasterDataNode(string);
                if (rasterDataNode == null) continue;
                this.collectNotIncludedReferences(rasterDataNode, notIncludedNames);
            }
        }
        boolean ok = true;
        if (!notIncludedNames.isEmpty()) {
            StringBuilder nameListText = new StringBuilder();
            for (String notIncludedName : notIncludedNames) {
                nameListText.append("  '").append(notIncludedName).append("'\n");
            }
            String string = "The following dataset(s) are referenced but not included\nin your current subset definition:\n{0}\nIf you do not include these dataset(s) into your selection,\nyou might get unexpected results while working with the\nresulting product.\n\nDo you wish to include the referenced dataset(s) into your\nsubset definition?\n";
            MessageFormat format = new MessageFormat("The following dataset(s) are referenced but not included\nin your current subset definition:\n{0}\nIf you do not include these dataset(s) into your selection,\nyou might get unexpected results while working with the\nresulting product.\n\nDo you wish to include the referenced dataset(s) into your\nsubset definition?\n");
            int status = JOptionPane.showConfirmDialog(this.getJDialog(), format.format(new Object[]{nameListText.toString()}), "Incomplete Subset Definition", 1);
            if (status == 0) {
                String[] nodenames = notIncludedNames.toArray(new String[notIncludedNames.size()]);
                this.productSubsetDef.addNodeNames(nodenames);
                ok = true;
            } else if (status == 1) {
                ok = true;
            } else if (status == 2) {
                ok = false;
            }
        }
        return ok;
    }

    private void collectNotIncludedReferences(RasterDataNode rasterDataNode, Set<String> notIncludedNames) {
        RasterDataNode[] referencedNodes;
        for (RasterDataNode referencedNode : referencedNodes = ProductSubsetDialog.getReferencedNodes(rasterDataNode)) {
            String name = referencedNode.getName();
            if (this.productSubsetDef.isNodeAccepted(name) || notIncludedNames.contains(name)) continue;
            notIncludedNames.add(name);
            this.collectNotIncludedReferences(referencedNode, notIncludedNames);
        }
    }

    private static RasterDataNode[] getReferencedNodes(RasterDataNode node) {
        Product product = node.getProduct();
        if (product != null) {
            ProductNodeGroup overlayMaskGroup;
            ArrayList<String> expressions = new ArrayList<String>(10);
            if (node.getValidPixelExpression() != null) {
                expressions.add(node.getValidPixelExpression());
            }
            if ((overlayMaskGroup = node.getOverlayMaskGroup()).getNodeCount() > 0) {
                Mask[] overlayMasks = (Mask[])overlayMaskGroup.toArray((ProductNode[])new Mask[overlayMaskGroup.getNodeCount()]);
                for (Mask overlayMask : overlayMasks) {
                    String expression = overlayMask.getImageType() == Mask.BandMathsType.INSTANCE ? Mask.BandMathsType.getExpression((Mask)overlayMask) : (overlayMask.getImageType() == Mask.RangeType.INSTANCE ? Mask.RangeType.getExpression((Mask)overlayMask) : null);
                    if (expression == null) continue;
                    expressions.add(expression);
                }
            }
            if (node instanceof VirtualBand) {
                VirtualBand virtualBand = (VirtualBand)node;
                expressions.add(virtualBand.getExpression());
            }
            ArrayList<Term> termList = new ArrayList<Term>(10);
            for (String expression : expressions) {
                try {
                    Term term = product.parseExpression(expression);
                    if (term == null) continue;
                    termList.add(term);
                }
                catch (ParseException e) {
                    Debug.trace((Throwable)e);
                }
            }
            return BandArithmetic.getRefRasters((Term[])termList.toArray(new Term[termList.size()]));
        }
        return new RasterDataNode[0];
    }

    private boolean checkFlagDatasetIncluded() {
        String[] nodeNames = this.productSubsetDef.getNodeNames();
        ArrayList<String> flagDsNameList = new ArrayList<String>(10);
        boolean flagDsInSubset = false;
        for (int i = 0; i < this.product.getNumBands(); ++i) {
            Band band = this.product.getBandAt(i);
            if (band.getFlagCoding() == null) continue;
            flagDsNameList.add(band.getName());
            if (!StringUtils.contains((String[])nodeNames, (String)band.getName())) break;
            flagDsInSubset = true;
            break;
        }
        int numFlagDs = flagDsNameList.size();
        boolean ok = true;
        if (numFlagDs > 0 && !flagDsInSubset) {
            int status = JOptionPane.showConfirmDialog(this.getJDialog(), "No flag dataset selected.\n\nIf you do not include a flag dataset in the subset,\nyou will not be able to create bitmask overlays.\n\nDo you wish to include the available flag dataset(s)\nin the current subset?\n", "No Flag Dataset Selected", 1);
            if (status == 0) {
                this.productSubsetDef.addNodeNames(flagDsNameList.toArray(new String[numFlagDs]));
                ok = true;
            } else if (status == 1) {
                ok = true;
            } else if (status == 2) {
                ok = false;
            }
        }
        return ok;
    }

    @Override
    protected void onCancel() {
        this.spatialSubsetPane.cancelThumbnailLoader();
        super.onCancel();
    }

    private void createUI() {
        this.memLabel = new JLabel("####", 4);
        JTabbedPane tabbedPane = new JTabbedPane();
        ProductSubsetDialog.setComponentName(tabbedPane, "TabbedPane");
        this.spatialSubsetPane = this.createSpatialSubsetPane();
        ProductSubsetDialog.setComponentName(this.spatialSubsetPane, "SpatialSubsetPane");
        if (this.spatialSubsetPane != null) {
            tabbedPane.addTab("Spatial Subset", this.spatialSubsetPane);
        }
        this.bandSubsetPane = this.createBandSubsetPane();
        ProductSubsetDialog.setComponentName(this.bandSubsetPane, "BandSubsetPane");
        if (this.bandSubsetPane != null) {
            tabbedPane.addTab("Band Subset", this.bandSubsetPane);
        }
        this.tiePointGridSubsetPane = this.createTiePointGridSubsetPane();
        ProductSubsetDialog.setComponentName(this.tiePointGridSubsetPane, "TiePointGridSubsetPane");
        if (this.tiePointGridSubsetPane != null) {
            tabbedPane.addTab("Tie-Point Grid Subset", this.tiePointGridSubsetPane);
        }
        this.metadataSubsetPane = this.createAnnotationSubsetPane();
        ProductSubsetDialog.setComponentName(this.metadataSubsetPane, "MetadataSubsetPane");
        if (this.metadataSubsetPane != null) {
            tabbedPane.addTab("Metadata Subset", this.metadataSubsetPane);
        }
        tabbedPane.setPreferredSize(new Dimension(512, 380));
        tabbedPane.setSelectedIndex(0);
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        ProductSubsetDialog.setComponentName(contentPane, "ContentPane");
        contentPane.add((Component)tabbedPane, "Center");
        contentPane.add((Component)this.memLabel, "South");
        this.setContent(contentPane);
        this.updateSubsetDefNodeNameList();
    }

    private SpatialSubsetPane createSpatialSubsetPane() {
        return new SpatialSubsetPane();
    }

    private ProductNodeSubsetPane createBandSubsetPane() {
        Band[] bands = this.product.getBands();
        if (bands.length == 0) {
            return null;
        }
        return new ProductNodeSubsetPane((ProductNode[])this.product.getBands(), true);
    }

    private ProductNodeSubsetPane createTiePointGridSubsetPane() {
        TiePointGrid[] tiePointGrids = this.product.getTiePointGrids();
        if (tiePointGrids.length == 0) {
            return null;
        }
        return new ProductNodeSubsetPane((ProductNode[])this.product.getTiePointGrids(), new String[]{"latitude", "longitude"}, true);
    }

    private ProductNodeSubsetPane createAnnotationSubsetPane() {
        String[] metaNodes;
        MetadataElement metadataRoot = this.product.getMetadataRoot();
        MetadataElement[] metadataElements = metadataRoot.getElements();
        if (metadataElements.length == 0) {
            return null;
        }
        if (this.givenProductSubsetDef != null && !this.givenProductSubsetDef.isIgnoreMetadata()) {
            metaNodes = new String[metadataElements.length];
            for (int i = 0; i < metadataElements.length; ++i) {
                MetadataElement metadataElement = metadataElements[i];
                metaNodes[i] = metadataElement.getName();
            }
        } else {
            metaNodes = new String[]{};
        }
        String[] includeNodes = StringUtils.addToArray((String[])metaNodes, (String)"history");
        return new ProductNodeSubsetPane((ProductNode[])metadataElements, includeNodes, true);
    }

    private static void setComponentName(JComponent component, String name) {
        if (component != null) {
            Container parent = component.getParent();
            if (parent != null) {
                component.setName(parent.getName() + "." + name);
            } else {
                component.setName(name);
            }
        }
    }

    private void updateSubsetDefRegion(int x1, int y1, int x2, int y2, int sx, int sy) {
        this.productSubsetDef.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(x1, y1, x2 - x1 + 1, y2 - y1 + 1, 0));
        this.productSubsetDef.setRegionMap(SubsetOp.computeRegionMap((Rectangle)this.productSubsetDef.getRegion(), (Product)this.product, (String[])this.productSubsetDef.getNodeNames()));
        this.productSubsetDef.setSubSampling(sx, sy);
        this.updateMemDisplay();
    }

    private void updateSubsetDefNodeNameList() {
        this.productSubsetDef.setIgnoreMetadata(false);
        this.productSubsetDef.setNodeNames(null);
        if (this.bandSubsetPane != null) {
            this.productSubsetDef.addNodeNames(this.bandSubsetPane.getSubsetNames());
        }
        if (this.tiePointGridSubsetPane != null) {
            this.productSubsetDef.addNodeNames(this.tiePointGridSubsetPane.getSubsetNames());
        }
        if (this.metadataSubsetPane != null) {
            this.productSubsetDef.addNodeNames(this.metadataSubsetPane.getSubsetNames());
        }
        this.updateMemDisplay();
    }

    private void updateMemDisplay() {
        if (this.product != null) {
            double factor = 9.5367431640625E-7;
            long storageMem = this.product.getRawStorageSize(this.productSubsetDef);
            double megas = MathUtils.round((double)(factor * (double)storageMem), (double)10.0);
            if (megas > this.memWarnLimit) {
                this.memLabel.setForeground(MEM_LABEL_WARN_COLOR);
            } else {
                this.memLabel.setForeground(MEM_LABEL_NORM_COLOR);
            }
            this.memLabel.setText(MEM_LABEL_TEXT + megas + "M");
        } else {
            this.memLabel.setText(" ");
        }
    }

    private class ProductNodeSubsetPane
    extends JPanel {
        private ProductNode[] productNodes;
        private String[] includeAlways;
        private List<JCheckBox> checkers;
        private JCheckBox allCheck;
        private JCheckBox noneCheck;
        private boolean selected;

        private ProductNodeSubsetPane(ProductNode[] productNodes, boolean selected) {
            this(productNodes, null, selected);
        }

        private ProductNodeSubsetPane(ProductNode[] productNodes, String[] includeAlways, boolean selected) {
            this.productNodes = productNodes;
            this.includeAlways = includeAlways;
            this.selected = selected;
            this.createUI();
        }

        private void createUI() {
            ActionListener productNodeCheckListener = e -> this.updateUIState();
            this.checkers = new ArrayList<JCheckBox>(10);
            JPanel checkersPane = GridBagUtils.createPanel();
            ProductSubsetDialog.setComponentName(checkersPane, "CheckersPane");
            GridBagConstraints gbc = GridBagUtils.createConstraints("insets.left=4,anchor=WEST,fill=HORIZONTAL");
            for (int i = 0; i < this.productNodes.length; ++i) {
                ProductNode productNode = this.productNodes[i];
                String name = productNode.getName();
                JCheckBox productNodeCheck = new JCheckBox(name);
                productNodeCheck.setSelected(this.selected);
                productNodeCheck.setFont(SMALL_PLAIN_FONT);
                productNodeCheck.addActionListener(productNodeCheckListener);
                if (this.includeAlways != null && StringUtils.containsIgnoreCase((String[])this.includeAlways, (String)name)) {
                    productNodeCheck.setSelected(true);
                    productNodeCheck.setEnabled(false);
                } else if (ProductSubsetDialog.this.givenProductSubsetDef != null) {
                    productNodeCheck.setSelected(ProductSubsetDialog.this.givenProductSubsetDef.containsNodeName(name));
                }
                this.checkers.add(productNodeCheck);
                String description = productNode.getDescription();
                JLabel productNodeLabel = new JLabel(description != null ? description : " ");
                productNodeLabel.setFont(SMALL_ITALIC_FONT);
                GridBagUtils.addToPanel(checkersPane, productNodeCheck, gbc, "weightx=0,gridx=0,gridy=" + i);
                GridBagUtils.addToPanel(checkersPane, productNodeLabel, gbc, "weightx=1,gridx=1,gridy=" + i);
            }
            GridBagUtils.addToPanel(checkersPane, new JLabel(" "), gbc, "gridwidth=2,weightx=1,weighty=1,gridx=0,gridy=" + this.productNodes.length);
            ActionListener allCheckListener = e -> {
                if (e.getSource() == this.allCheck) {
                    this.checkAllProductNodes(true);
                } else if (e.getSource() == this.noneCheck) {
                    this.checkAllProductNodes(false);
                }
                this.updateUIState();
            };
            this.allCheck = new JCheckBox("Select all");
            this.allCheck.setName("selectAll");
            this.allCheck.setMnemonic('a');
            this.allCheck.addActionListener(allCheckListener);
            this.noneCheck = new JCheckBox("Select none");
            this.noneCheck.setName("SelectNone");
            this.noneCheck.setMnemonic('n');
            this.noneCheck.addActionListener(allCheckListener);
            JScrollPane scrollPane = new JScrollPane(checkersPane);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            JPanel buttonRow = new JPanel(new FlowLayout(0, 4, 4));
            buttonRow.add(this.allCheck);
            buttonRow.add(this.noneCheck);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.add((Component)buttonRow, "South");
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.updateUIState();
        }

        void updateUIState() {
            this.allCheck.setSelected(this.areAllProductNodesChecked(true));
            this.noneCheck.setSelected(this.areAllProductNodesChecked(false));
            ProductSubsetDialog.this.updateSubsetDefNodeNameList();
        }

        String[] getSubsetNames() {
            String[] names = new String[this.countChecked(true)];
            int pos = 0;
            for (int i = 0; i < this.checkers.size(); ++i) {
                JCheckBox checker = this.checkers.get(i);
                if (!checker.isSelected()) continue;
                ProductNode productNode = this.productNodes[i];
                names[pos] = productNode.getName();
                ++pos;
            }
            return names;
        }

        void checkAllProductNodes(boolean checked) {
            for (JCheckBox checker : this.checkers) {
                if (!checker.isEnabled()) continue;
                checker.setSelected(checked);
            }
        }

        boolean areAllProductNodesChecked(boolean checked) {
            return this.countChecked(checked) == this.checkers.size();
        }

        int countChecked(boolean checked) {
            int counter = 0;
            for (JCheckBox checker : this.checkers) {
                if (checker.isSelected() != checked) continue;
                ++counter;
            }
            return counter;
        }
    }

    private class SpatialSubsetPane
    extends JPanel
    implements ActionListener,
    ParamChangeListener,
    SliderBoxImageDisplay.SliderBoxChangeListener {
        private Parameter paramX1;
        private Parameter paramY1;
        private Parameter paramX2;
        private Parameter paramY2;
        private Parameter paramSX;
        private Parameter paramSY;
        private Parameter paramWestLon1;
        private Parameter paramEastLon2;
        private Parameter paramNorthLat1;
        private Parameter paramSouthLat2;
        private SliderBoxImageDisplay imageCanvas;
        private JCheckBox fixSceneWidthCheck;
        private JCheckBox fixSceneHeightCheck;
        private JLabel subsetWidthLabel;
        private JLabel subsetHeightLabel;
        private JLabel sourceWidthLabel;
        private JLabel sourceHeightLabel;
        private int thumbNailSubSampling;
        private JButton setToVisibleButton;
        private JScrollPane imageScrollPane;
        private ProgressMonitorSwingWorker<BufferedImage, Object> thumbnailLoader;
        private JComboBox referenceCombo;
        String _oldReference;

        private SpatialSubsetPane() {
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                this.referenceCombo = new JComboBox();
                for (String bandName : ProductSubsetDialog.this.product.getBandNames()) {
                    this.referenceCombo.addItem(bandName);
                }
                this.referenceCombo.setSelectedItem(ProductSubsetDialog.this.product.getBandAt(0));
                this._oldReference = (String)this.referenceCombo.getSelectedItem();
                this.referenceCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int h;
                        int w;
                        if (ProductSubsetDialog.this.product.isMultiSize()) {
                            w = ProductSubsetDialog.this.product.getBand((String)SpatialSubsetPane.this.referenceCombo.getSelectedItem()).getRasterWidth();
                            h = ProductSubsetDialog.this.product.getBand((String)SpatialSubsetPane.this.referenceCombo.getSelectedItem()).getRasterHeight();
                        } else {
                            w = ProductSubsetDialog.this.product.getSceneRasterWidth();
                            h = ProductSubsetDialog.this.product.getSceneRasterHeight();
                        }
                        boolean wMin = true;
                        boolean hMin = true;
                        SpatialSubsetPane.this.paramX1.getProperties().setMaxValue((Number)(w - 1 - 1 > 0 ? w - 1 - 1 : 0));
                        SpatialSubsetPane.this.paramY1.getProperties().setMaxValue((Number)(h - 1 - 1 > 0 ? h - 1 - 1 : 0));
                        SpatialSubsetPane.this.paramX2.getProperties().setMaxValue((Number)(w - 1));
                        SpatialSubsetPane.this.paramY2.getProperties().setMaxValue((Number)(h - 1));
                        SpatialSubsetPane.this.updateUIState(new ParamChangeEvent((Object)this, new Parameter("geo_"), null));
                        SpatialSubsetPane.this._oldReference = (String)SpatialSubsetPane.this.referenceCombo.getSelectedItem();
                    }
                });
            }
            this.initParameters();
            this.createUI();
        }

        private void createUI() {
            int sceneHeight;
            int sceneWidth;
            this.setThumbnailSubsampling();
            final Dimension imageSize = this.getScaledImageSize();
            this.thumbnailLoader = new ProgressMonitorSwingWorker<BufferedImage, Object>((Component)this, "Loading thumbnail image..."){

                protected BufferedImage doInBackground(ProgressMonitor pm) throws Exception {
                    return SpatialSubsetPane.this.createThumbNailImage(imageSize, pm);
                }

                protected void done() {
                    BufferedImage thumbnail = null;
                    try {
                        thumbnail = (BufferedImage)this.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (thumbnail != null) {
                        SpatialSubsetPane.this.imageCanvas.setImage(thumbnail);
                    }
                }
            };
            this.thumbnailLoader.execute();
            this.imageCanvas = new SliderBoxImageDisplay(imageSize.width, imageSize.height, this);
            this.imageCanvas.setSize(imageSize.width, imageSize.height);
            ProductSubsetDialog.setComponentName(this.imageCanvas, "ImageCanvas");
            this.imageScrollPane = new JScrollPane(this.imageCanvas);
            this.imageScrollPane.setHorizontalScrollBarPolicy(30);
            this.imageScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.imageScrollPane.setVerticalScrollBarPolicy(22);
            this.imageScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.imageScrollPane.getViewport().setExtentSize(new Dimension(148, 296));
            ProductSubsetDialog.setComponentName(this.imageScrollPane, "ImageScrollPane");
            this.subsetWidthLabel = new JLabel("####", 4);
            this.subsetHeightLabel = new JLabel("####", 4);
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                sceneWidth = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth();
                sceneHeight = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight();
            } else {
                sceneWidth = ProductSubsetDialog.this.product.getSceneRasterWidth();
                sceneHeight = ProductSubsetDialog.this.product.getSceneRasterHeight();
            }
            this.sourceWidthLabel = new JLabel(String.valueOf(sceneWidth), 4);
            this.sourceHeightLabel = new JLabel(String.valueOf(sceneHeight), 4);
            this.setToVisibleButton = new JButton("Use Preview");
            this.setToVisibleButton.setMnemonic('v');
            this.setToVisibleButton.setToolTipText("Use coordinates of visible thumbnail area");
            this.setToVisibleButton.addActionListener(this);
            ProductSubsetDialog.setComponentName(this.setToVisibleButton, "UsePreviewButton");
            this.fixSceneWidthCheck = new JCheckBox("Fix full width");
            this.fixSceneWidthCheck.setMnemonic('w');
            this.fixSceneWidthCheck.setToolTipText("Checks whether or not to fix the full scene width");
            this.fixSceneWidthCheck.addActionListener(this);
            ProductSubsetDialog.setComponentName(this.fixSceneWidthCheck, "FixWidthCheck");
            this.fixSceneHeightCheck = new JCheckBox("Fix full height");
            this.fixSceneHeightCheck.setMnemonic('h');
            this.fixSceneHeightCheck.setToolTipText("Checks whether or not to fix the full scene height");
            this.fixSceneHeightCheck.addActionListener(this);
            ProductSubsetDialog.setComponentName(this.fixSceneHeightCheck, "FixHeightCheck");
            JPanel textInputPane = GridBagUtils.createPanel();
            ProductSubsetDialog.setComponentName(textInputPane, "TextInputPane");
            JTabbedPane tabbedPane = new JTabbedPane();
            ProductSubsetDialog.setComponentName(tabbedPane, "coordinatePane");
            tabbedPane.addTab("Pixel Coordinates", this.createPixelCoordinatesPane());
            tabbedPane.addTab("Geo Coordinates", this.createGeoCoordinatesPane());
            tabbedPane.setEnabledAt(1, this.canUseGeoCoordinates(ProductSubsetDialog.this.product));
            GridBagConstraints gbc = GridBagUtils.createConstraints("insets.left=7,anchor=WEST,fill=HORIZONTAL, weightx=1.0");
            GridBagUtils.setAttributes(gbc, "gridwidth=2");
            GridBagUtils.addToPanel(textInputPane, tabbedPane, gbc, "gridx=0,gridy=0");
            GridBagUtils.setAttributes(gbc, "insets.top=7,gridwidth=1");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Scene step X:"), gbc, "gridx=0,gridy=1");
            GridBagUtils.addToPanel(textInputPane, UIUtils.createSpinner(this.paramSX, 1, "#0"), gbc, "gridx=1,gridy=1");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Scene step Y:"), gbc, "gridx=0,gridy=2");
            GridBagUtils.addToPanel(textInputPane, UIUtils.createSpinner(this.paramSY, 1, "#0"), gbc, "gridx=1,gridy=2");
            GridBagUtils.setAttributes(gbc, "insets.top=4");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Subset scene width:"), gbc, "gridx=0,gridy=3");
            GridBagUtils.addToPanel(textInputPane, this.subsetWidthLabel, gbc, "gridx=1,gridy=3");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Subset scene height:"), gbc, "gridx=0,gridy=4");
            GridBagUtils.addToPanel(textInputPane, this.subsetHeightLabel, gbc, "gridx=1,gridy=4");
            GridBagUtils.setAttributes(gbc, "insets.top=4,gridwidth=1");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Source scene width:"), gbc, "gridx=0,gridy=5");
            GridBagUtils.addToPanel(textInputPane, this.sourceWidthLabel, gbc, "gridx=1,gridy=5");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(textInputPane, new JLabel("Source scene height:"), gbc, "gridx=0,gridy=6");
            GridBagUtils.addToPanel(textInputPane, this.sourceHeightLabel, gbc, "gridx=1,gridy=6");
            GridBagUtils.setAttributes(gbc, "insets.top=7,gridwidth=1, gridheight=2");
            GridBagUtils.addToPanel(textInputPane, this.setToVisibleButton, gbc, "gridx=0,gridy=7");
            GridBagUtils.setAttributes(gbc, "insets.top=7,gridwidth=1, gridheight=1");
            GridBagUtils.addToPanel(textInputPane, this.fixSceneWidthCheck, gbc, "gridx=1,gridy=7");
            GridBagUtils.setAttributes(gbc, "insets.top=1,gridwidth=1");
            GridBagUtils.addToPanel(textInputPane, this.fixSceneHeightCheck, gbc, "gridx=1,gridy=8");
            JPanel referencePanel = new JPanel();
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                BoxLayout boxlayoutRef = new BoxLayout(referencePanel, 0);
                referencePanel.setLayout(boxlayoutRef);
                referencePanel.add(new JLabel("Reference Band:"));
                referencePanel.add(this.referenceCombo);
            }
            JPanel centerPanel = new JPanel();
            BoxLayout boxlayout = new BoxLayout(centerPanel, 1);
            centerPanel.setLayout(boxlayout);
            centerPanel.add(referencePanel);
            centerPanel.add(textInputPane);
            this.setLayout(new BorderLayout(4, 4));
            this.add((Component)this.imageScrollPane, "West");
            this.add((Component)centerPanel, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.updateUIState(null);
            this.imageCanvas.scrollRectToVisible(this.imageCanvas.getSliderBoxBounds());
        }

        private boolean canUseGeoCoordinates(Product product) {
            GeoCoding geoCoding = product.getSceneGeoCoding();
            return geoCoding != null && geoCoding.canGetPixelPos() && geoCoding.canGetGeoPos();
        }

        private boolean canUseGeoCoordinates(RasterDataNode rasterDataNode) {
            GeoCoding geoCoding = rasterDataNode.getGeoCoding();
            return geoCoding != null && geoCoding.canGetPixelPos() && geoCoding.canGetGeoPos();
        }

        private JPanel createGeoCoordinatesPane() {
            JPanel geoCoordinatesPane = GridBagUtils.createPanel();
            ProductSubsetDialog.setComponentName(geoCoordinatesPane, "geoCoordinatesPane");
            GridBagConstraints gbc = GridBagUtils.createConstraints("insets.left=3,anchor=WEST,fill=HORIZONTAL, weightx=1.0");
            GridBagUtils.setAttributes(gbc, "insets.top=4");
            GridBagUtils.addToPanel(geoCoordinatesPane, new JLabel("North latitude bound:"), gbc, "gridx=0,gridy=0");
            GridBagUtils.addToPanel(geoCoordinatesPane, UIUtils.createSpinner(this.paramNorthLat1, 1.0, "#0.00#"), gbc, "gridx=1,gridy=0");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(geoCoordinatesPane, new JLabel("West longitude bound:"), gbc, "gridx=0,gridy=1");
            GridBagUtils.addToPanel(geoCoordinatesPane, UIUtils.createSpinner(this.paramWestLon1, 1.0, "#0.00#"), gbc, "gridx=1,gridy=1");
            GridBagUtils.setAttributes(gbc, "insets.top=4");
            GridBagUtils.addToPanel(geoCoordinatesPane, new JLabel("South latitude bound:"), gbc, "gridx=0,gridy=2");
            GridBagUtils.addToPanel(geoCoordinatesPane, UIUtils.createSpinner(this.paramSouthLat2, 1.0, "#0.00#"), gbc, "gridx=1,gridy=2");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(geoCoordinatesPane, new JLabel("East longitude bound:"), gbc, "gridx=0,gridy=3");
            GridBagUtils.addToPanel(geoCoordinatesPane, UIUtils.createSpinner(this.paramEastLon2, 1.0, "#0.00#"), gbc, "gridx=1,gridy=3");
            return geoCoordinatesPane;
        }

        private JPanel createPixelCoordinatesPane() {
            GridBagConstraints gbc = GridBagUtils.createConstraints("insets.left=3,anchor=WEST,fill=HORIZONTAL, weightx=1.0");
            JPanel pixelCoordinatesPane = GridBagUtils.createPanel();
            ProductSubsetDialog.setComponentName(pixelCoordinatesPane, "pixelCoordinatesPane");
            GridBagUtils.setAttributes(gbc, "insets.top=4");
            GridBagUtils.addToPanel(pixelCoordinatesPane, new JLabel("Scene start X:"), gbc, "gridx=0,gridy=0");
            GridBagUtils.addToPanel(pixelCoordinatesPane, UIUtils.createSpinner(this.paramX1, 25, "#0"), gbc, "gridx=1,gridy=0");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(pixelCoordinatesPane, new JLabel("Scene start Y:"), gbc, "gridx=0,gridy=1");
            GridBagUtils.addToPanel(pixelCoordinatesPane, UIUtils.createSpinner(this.paramY1, 25, "#0"), gbc, "gridx=1,gridy=1");
            GridBagUtils.setAttributes(gbc, "insets.top=4");
            GridBagUtils.addToPanel(pixelCoordinatesPane, new JLabel("Scene end X:"), gbc, "gridx=0,gridy=2");
            GridBagUtils.addToPanel(pixelCoordinatesPane, UIUtils.createSpinner(this.paramX2, 25, "#0"), gbc, "gridx=1,gridy=2");
            GridBagUtils.setAttributes(gbc, "insets.top=1");
            GridBagUtils.addToPanel(pixelCoordinatesPane, new JLabel("Scene end Y:"), gbc, "gridx=0,gridy=3");
            GridBagUtils.addToPanel(pixelCoordinatesPane, UIUtils.createSpinner(this.paramY2, 25, "#0"), gbc, "gridx=1,gridy=3");
            return pixelCoordinatesPane;
        }

        private void setThumbnailSubsampling() {
            int w = ProductSubsetDialog.this.product.isMultiSize() ? ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth() : ProductSubsetDialog.this.product.getSceneRasterWidth();
            this.thumbNailSubSampling = w / 148;
            if (this.thumbNailSubSampling <= 1) {
                this.thumbNailSubSampling = 1;
            }
        }

        public void cancelThumbnailLoader() {
            if (this.thumbnailLoader != null) {
                this.thumbnailLoader.cancel(true);
            }
        }

        public boolean isThumbnailLoaderCanceled() {
            return this.thumbnailLoader != null && this.thumbnailLoader.isCancelled();
        }

        @Override
        public void sliderBoxChanged(Rectangle sliderBoxBounds) {
            int x1 = sliderBoxBounds.x * this.thumbNailSubSampling;
            int y1 = sliderBoxBounds.y * this.thumbNailSubSampling;
            int x2 = x1 + sliderBoxBounds.width * this.thumbNailSubSampling;
            int y2 = y1 + sliderBoxBounds.height * this.thumbNailSubSampling;
            int w = ProductSubsetDialog.this.product.getSceneRasterWidth();
            int h = ProductSubsetDialog.this.product.getSceneRasterHeight();
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                w = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth();
                h = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight();
            }
            if (x1 < 0) {
                x1 = 0;
            }
            if (x1 > w - 2) {
                x1 = w - 2;
            }
            if (y1 < 0) {
                y1 = 0;
            }
            if (y1 > h - 2) {
                y1 = h - 2;
            }
            if (x2 < 1) {
                x2 = 1;
            }
            if (x2 > w - 1) {
                x2 = w - 1;
            }
            if (y2 < 1) {
                y2 = 1;
            }
            if (y2 > h - 1) {
                y2 = h - 1;
            }
            this.paramX1.setValue((Object)0, null);
            this.paramY1.setValue((Object)0, null);
            this.paramX2.setValue((Object)(w - 1), null);
            this.paramY2.setValue((Object)(h - 1), null);
            this.paramX1.setValue((Object)x1, null);
            this.paramY1.setValue((Object)y1, null);
            this.paramX2.setValue((Object)x2, null);
            this.paramY2.setValue((Object)y2, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean enable;
            if (e.getSource().equals(this.fixSceneWidthCheck)) {
                this.imageCanvas.setImageWidthFixed(this.fixSceneWidthCheck.isSelected());
                enable = !this.fixSceneWidthCheck.isSelected();
                this.paramX1.setUIEnabled(enable);
                this.paramX2.setUIEnabled(enable);
            }
            if (e.getSource().equals(this.fixSceneHeightCheck)) {
                this.imageCanvas.setImageHeightFixed(this.fixSceneHeightCheck.isSelected());
                enable = !this.fixSceneHeightCheck.isSelected();
                this.paramY1.setUIEnabled(enable);
                this.paramY2.setUIEnabled(enable);
            }
            if (e.getSource().equals(this.setToVisibleButton)) {
                this.imageCanvas.setSliderBoxBounds(this.imageScrollPane.getViewport().getViewRect(), true);
            }
        }

        public void parameterValueChanged(ParamChangeEvent event) {
            this.updateUIState(event);
        }

        private void initParameters() {
            ParamGroup pg = new ParamGroup();
            this.addPixelParameter(pg);
            this.addGeoParameter(pg);
            pg.addParamChangeListener((ParamChangeListener)this);
        }

        private void addGeoParameter(ParamGroup pg) {
            this.paramNorthLat1 = new Parameter("geo_lat1", (Object)90.0);
            this.paramNorthLat1.getProperties().setDescription("North bound latitude");
            this.paramNorthLat1.getProperties().setPhysicalUnit("\u00b0");
            this.paramNorthLat1.getProperties().setMinValue((Number)-90.0);
            this.paramNorthLat1.getProperties().setMaxValue((Number)90.0);
            pg.addParameter(this.paramNorthLat1);
            this.paramWestLon1 = new Parameter("geo_lon1", (Object)-180.0);
            this.paramWestLon1.getProperties().setDescription("West bound longitude");
            this.paramWestLon1.getProperties().setPhysicalUnit("\u00b0");
            this.paramWestLon1.getProperties().setMinValue((Number)-180.0);
            this.paramWestLon1.getProperties().setMaxValue((Number)180.0);
            pg.addParameter(this.paramWestLon1);
            this.paramSouthLat2 = new Parameter("geo_lat2", (Object)-90.0);
            this.paramSouthLat2.getProperties().setDescription("South bound latitude");
            this.paramSouthLat2.getProperties().setPhysicalUnit("\u00b0");
            this.paramSouthLat2.getProperties().setMinValue((Number)-90.0);
            this.paramSouthLat2.getProperties().setMaxValue((Number)90.0);
            pg.addParameter(this.paramSouthLat2);
            this.paramEastLon2 = new Parameter("geo_lon2", (Object)180.0);
            this.paramEastLon2.getProperties().setDescription("East bound longitude");
            this.paramEastLon2.getProperties().setPhysicalUnit("\u00b0");
            this.paramEastLon2.getProperties().setMinValue((Number)-180.0);
            this.paramEastLon2.getProperties().setMaxValue((Number)180.0);
            pg.addParameter(this.paramEastLon2);
            boolean canUseGeocoding = ProductSubsetDialog.this.product.isMultiSize() ? this.canUseGeoCoordinates((RasterDataNode)ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem())) : this.canUseGeoCoordinates(ProductSubsetDialog.this.product);
            if (canUseGeocoding) {
                this.syncLatLonWithXYParams();
            }
        }

        private void addPixelParameter(ParamGroup pg) {
            int h;
            int w;
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                w = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth();
                h = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight();
            } else {
                w = ProductSubsetDialog.this.product.getSceneRasterWidth();
                h = ProductSubsetDialog.this.product.getSceneRasterHeight();
            }
            int x1 = 0;
            int y1 = 0;
            int x2 = w - 1;
            int y2 = h - 1;
            int sx = 1;
            int sy = 1;
            if (ProductSubsetDialog.this.givenProductSubsetDef != null) {
                Rectangle region = ProductSubsetDialog.this.product.isMultiSize() && ProductSubsetDialog.this.givenProductSubsetDef.getRegionMap() != null ? (Rectangle)ProductSubsetDialog.this.givenProductSubsetDef.getRegionMap().get((String)this.referenceCombo.getSelectedItem()) : ProductSubsetDialog.this.givenProductSubsetDef.getRegion();
                if (region != null) {
                    int preY2;
                    x1 = region.x;
                    y1 = region.y;
                    int preX2 = x1 + region.width - 1;
                    if (preX2 < x2) {
                        x2 = preX2;
                    }
                    if ((preY2 = y1 + region.height - 1) < y2) {
                        y2 = preY2;
                    }
                }
                sx = ProductSubsetDialog.this.givenProductSubsetDef.getSubSamplingX();
                sy = ProductSubsetDialog.this.givenProductSubsetDef.getSubSamplingY();
            }
            boolean wMin = true;
            boolean hMin = true;
            this.paramX1 = new Parameter("source_x1", (Object)x1);
            this.paramX1.getProperties().setDescription("Start X co-ordinate given in pixels");
            this.paramX1.getProperties().setMinValue((Number)0);
            this.paramX1.getProperties().setMaxValue((Number)(w - 1 - 1 > 0 ? w - 1 - 1 : 0));
            this.paramY1 = new Parameter("source_y1", (Object)y1);
            this.paramY1.getProperties().setDescription("Start Y co-ordinate given in pixels");
            this.paramY1.getProperties().setMinValue((Number)0);
            this.paramY1.getProperties().setMaxValue((Number)(h - 1 - 1 > 0 ? h - 1 - 1 : 0));
            this.paramX2 = new Parameter("source_x2", (Object)x2);
            this.paramX2.getProperties().setDescription("End X co-ordinate given in pixels");
            this.paramX2.getProperties().setMinValue((Number)0);
            Integer maxValue = w - 1;
            this.paramX2.getProperties().setMaxValue((Number)maxValue);
            this.paramY2 = new Parameter("source_y2", (Object)y2);
            this.paramY2.getProperties().setDescription("End Y co-ordinate given in pixels");
            this.paramY2.getProperties().setMinValue((Number)0);
            this.paramY2.getProperties().setMaxValue((Number)(h - 1));
            this.paramSX = new Parameter("source_sx", (Object)sx);
            this.paramSX.getProperties().setDescription("Sub-sampling in X-direction given in pixels");
            this.paramSX.getProperties().setMinValue((Number)1);
            this.paramSX.getProperties().setMaxValue((Number)(w / 1 + 1));
            this.paramSY = new Parameter("source_sy", (Object)sy);
            this.paramSY.getProperties().setDescription("Sub-sampling in Y-direction given in pixels");
            this.paramSY.getProperties().setMinValue((Number)1);
            this.paramSY.getProperties().setMaxValue((Number)(h / 1 + 1));
            pg.addParameter(this.paramX1);
            pg.addParameter(this.paramY1);
            pg.addParameter(this.paramX2);
            pg.addParameter(this.paramY2);
            pg.addParameter(this.paramSX);
            pg.addParameter(this.paramSY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateUIState(ParamChangeEvent event) {
            if (ProductSubsetDialog.this.updatingUI.compareAndSet(false, true)) {
                try {
                    int sceneHeight;
                    int sceneWidth;
                    boolean canUseGeocoding = ProductSubsetDialog.this.product.isMultiSize() ? this.canUseGeoCoordinates((RasterDataNode)ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem())) : this.canUseGeoCoordinates(ProductSubsetDialog.this.product);
                    if (event != null && canUseGeocoding) {
                        String parmName = event.getParameter().getName();
                        if (parmName.startsWith("geo_")) {
                            GeoPos geoPos1 = new GeoPos(((Double)this.paramNorthLat1.getValue()).doubleValue(), ((Double)this.paramWestLon1.getValue()).doubleValue());
                            GeoPos geoPos2 = new GeoPos(((Double)this.paramSouthLat2.getValue()).doubleValue(), ((Double)this.paramEastLon2.getValue()).doubleValue());
                            this.updateXYParams(geoPos1, geoPos2);
                        } else if (parmName.startsWith("source_x") || parmName.startsWith("source_y")) {
                            this.syncLatLonWithXYParams();
                        }
                    }
                    int x1 = ((Number)this.paramX1.getValue()).intValue();
                    int y1 = ((Number)this.paramY1.getValue()).intValue();
                    int x2 = ((Number)this.paramX2.getValue()).intValue();
                    int y2 = ((Number)this.paramY2.getValue()).intValue();
                    int sx = ((Number)this.paramSX.getValue()).intValue();
                    int sy = ((Number)this.paramSY.getValue()).intValue();
                    if (ProductSubsetDialog.this.product.isMultiSize()) {
                        ProductSubsetDialog.this.productSubsetDef.setRegionMap(SubsetOp.computeRegionMap((Rectangle)this.computeROIToPositiveAxis(x1, y1, x2, y2), (String)((String)this.referenceCombo.getSelectedItem()), (Product)ProductSubsetDialog.this.product, null));
                        ProductSubsetDialog.this.productSubsetDef.setSubSampling(sx, sy);
                        ProductSubsetDialog.this.updateMemDisplay();
                    } else {
                        ProductSubsetDialog.this.productSubsetDef.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(this.computeROIToPositiveAxis(x1, y1, x2, y2), 0));
                        ProductSubsetDialog.this.productSubsetDef.setSubSampling(sx, sy);
                        ProductSubsetDialog.this.updateMemDisplay();
                    }
                    Dimension s = ProductSubsetDialog.this.product.isMultiSize() ? ProductSubsetDialog.this.productSubsetDef.getSceneRasterSize(ProductSubsetDialog.this.product.getSceneRasterWidth(), ProductSubsetDialog.this.product.getSceneRasterHeight(), (String)this.referenceCombo.getSelectedItem()) : ProductSubsetDialog.this.productSubsetDef.getSceneRasterSize(ProductSubsetDialog.this.product.getSceneRasterWidth(), ProductSubsetDialog.this.product.getSceneRasterHeight());
                    this.subsetWidthLabel.setText(String.valueOf(s.getWidth()));
                    this.subsetHeightLabel.setText(String.valueOf(s.getHeight()));
                    if (ProductSubsetDialog.this.product.isMultiSize()) {
                        sceneWidth = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth();
                        sceneHeight = ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight();
                    } else {
                        sceneWidth = ProductSubsetDialog.this.product.getSceneRasterWidth();
                        sceneHeight = ProductSubsetDialog.this.product.getSceneRasterHeight();
                    }
                    this.sourceHeightLabel.setText(String.valueOf(sceneHeight));
                    this.sourceWidthLabel.setText(String.valueOf(sceneWidth));
                    this.setThumbnailSubsampling();
                    int sliderBoxX1 = x1 / this.thumbNailSubSampling;
                    int sliderBoxY1 = y1 / this.thumbNailSubSampling;
                    int sliderBoxX2 = x2 / this.thumbNailSubSampling;
                    int sliderBoxY2 = y2 / this.thumbNailSubSampling;
                    int sliderBoxW = sliderBoxX2 - sliderBoxX1 + 1;
                    int sliderBoxH = sliderBoxY2 - sliderBoxY1 + 1;
                    Rectangle box = this.getScaledRectangle(new Rectangle(sliderBoxX1, sliderBoxY1, sliderBoxW, sliderBoxH));
                    this.imageCanvas.setSliderBoxBounds(box);
                }
                finally {
                    ProductSubsetDialog.this.updatingUI.set(false);
                }
            }
        }

        private Rectangle computeROIToPositiveAxis(int x1, int y1, int x2, int y2) {
            int diffX = x2 - x1;
            int diffY = y2 - y1;
            if (diffX < 0) {
                x1 = x1 + diffX - 1;
            }
            if (diffY < 0) {
                y1 = y1 + diffY - 1;
            }
            return new Rectangle(x1, y1, Math.abs(diffX) + 1, Math.abs(diffY) + 1);
        }

        private void syncLatLonWithXYParams() {
            double lon;
            double lat;
            PixelPos pixelPos1 = new PixelPos((double)((Number)this.paramX1.getValue()).intValue(), (double)((Number)this.paramY1.getValue()).intValue());
            PixelPos pixelPos2 = new PixelPos((double)((Number)this.paramX2.getValue()).intValue(), (double)((Number)this.paramY2.getValue()).intValue());
            GeoCoding geoCoding = ProductSubsetDialog.this.product.isMultiSize() ? ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getGeoCoding() : ProductSubsetDialog.this.product.getSceneGeoCoding();
            GeoPos geoPos1 = geoCoding.getGeoPos(pixelPos1, null);
            GeoPos geoPos2 = geoCoding.getGeoPos(pixelPos2, null);
            if (geoPos1.isValid()) {
                lat = geoPos1.getLat();
                lat = MathUtils.crop((double)lat, (double)-90.0, (double)90.0);
                this.paramNorthLat1.setValue((Object)lat, ex -> true);
                lon = geoPos1.getLon();
                lon = MathUtils.crop((double)lon, (double)-180.0, (double)180.0);
                this.paramWestLon1.setValue((Object)lon, ex -> true);
            }
            if (geoPos2.isValid()) {
                lat = geoPos2.getLat();
                lat = MathUtils.crop((double)lat, (double)-90.0, (double)90.0);
                this.paramSouthLat2.setValue((Object)lat, ex -> true);
                lon = geoPos2.getLon();
                lon = MathUtils.crop((double)lon, (double)-180.0, (double)180.0);
                this.paramEastLon2.setValue((Object)lon, ex -> true);
            }
        }

        private void updateXYParams(GeoPos geoPos1, GeoPos geoPos2) {
            PixelPos pixelPos2;
            GeoCoding geoCoding = ProductSubsetDialog.this.product.isMultiSize() ? ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getGeoCoding() : ProductSubsetDialog.this.product.getSceneGeoCoding();
            PixelPos pixelPos1 = geoCoding.getPixelPos(geoPos1, null);
            if (!pixelPos1.isValid()) {
                pixelPos1.setLocation(0.0, 0.0);
            }
            if (!(pixelPos2 = geoCoding.getPixelPos(geoPos2, null)).isValid()) {
                if (ProductSubsetDialog.this.product.isMultiSize()) {
                    pixelPos2.setLocation((double)ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth(), (double)ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight());
                } else {
                    pixelPos2.setLocation((double)ProductSubsetDialog.this.product.getSceneRasterWidth(), (double)ProductSubsetDialog.this.product.getSceneRasterHeight());
                }
            }
            Rectangle2D.Float region = new Rectangle2D.Float();
            region.setFrameFromDiagonal(pixelPos1.x, pixelPos1.y, pixelPos2.x, pixelPos2.y);
            Rectangle2D.Float productBounds = ProductSubsetDialog.this.product.isMultiSize() ? new Rectangle2D.Float(0.0f, 0.0f, ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth(), ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight()) : new Rectangle2D.Float(0.0f, 0.0f, ProductSubsetDialog.this.product.getSceneRasterWidth(), ProductSubsetDialog.this.product.getSceneRasterHeight());
            Rectangle2D finalRegion = productBounds.createIntersection(region);
            this.paramX1.setValue((Object)((int)finalRegion.getMinX()), ex -> true);
            this.paramY1.setValue((Object)((int)finalRegion.getMinY()), ex -> true);
            this.paramX2.setValue((Object)((int)finalRegion.getMaxX() - 1), ex -> true);
            this.paramY2.setValue((Object)((int)finalRegion.getMaxY() - 1), ex -> true);
        }

        private Dimension getScaledImageSize() {
            int h;
            int w;
            if (ProductSubsetDialog.this.product.isMultiSize()) {
                w = (ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterWidth() - 1) / this.thumbNailSubSampling + 1;
                h = (ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getRasterHeight() - 1) / this.thumbNailSubSampling + 1;
            } else {
                w = (ProductSubsetDialog.this.product.getSceneRasterWidth() - 1) / this.thumbNailSubSampling + 1;
                h = (ProductSubsetDialog.this.product.getSceneRasterHeight() - 1) / this.thumbNailSubSampling + 1;
            }
            Rectangle rectangle = new Rectangle(w, h);
            return this.getScaledRectangle(rectangle).getSize();
        }

        private Rectangle getScaledRectangle(Rectangle rectangle) {
            AffineTransform i2mTransform = ProductSubsetDialog.this.product.isMultiSize() ? Product.findImageToModelTransform((GeoCoding)ProductSubsetDialog.this.product.getBand((String)this.referenceCombo.getSelectedItem()).getGeoCoding()) : Product.findImageToModelTransform((GeoCoding)ProductSubsetDialog.this.product.getSceneGeoCoding());
            double scaleX = i2mTransform.getScaleX();
            double scaleY = i2mTransform.getScaleY();
            double scaleFactorY = Math.abs(scaleY / scaleX);
            AffineTransform scaleTransform = AffineTransform.getScaleInstance(1.0, scaleFactorY);
            return scaleTransform.createTransformedShape(rectangle).getBounds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage createThumbNailImage(Dimension imgSize, ProgressMonitor pm) {
            Assert.notNull((Object)pm, (String)"pm");
            String thumbNailBandName = this.getThumbnailBandName();
            Band thumbNailBand = ProductSubsetDialog.this.product.getBand(thumbNailBandName);
            Debug.trace((String)("ProductSubsetDialog: Reading thumbnail data for band '" + thumbNailBandName + "'..."));
            pm.beginTask("Creating thumbnail image", 5);
            BufferedImage image = null;
            try {
                ColoredBandImageMultiLevelSource multiLevelSource = ColoredBandImageMultiLevelSource.create((RasterDataNode)thumbNailBand, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                ImageLayer imageLayer = new ImageLayer((MultiLevelSource)multiLevelSource);
                int imageWidth = imgSize.width;
                int imageHeight = imgSize.height;
                int imageType = 5;
                image = new BufferedImage(imageWidth, imageHeight, 5);
                DefaultViewport snapshotVp = new DefaultViewport(this.isModelYAxisDown(imageLayer));
                BufferedImageRendering imageRendering = new BufferedImageRendering(image, (Viewport)snapshotVp);
                Graphics2D graphics = imageRendering.getGraphics();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, imageWidth, imageHeight);
                snapshotVp.zoom(imageLayer.getModelBounds());
                snapshotVp.moveViewDelta((double)snapshotVp.getViewBounds().x, (double)snapshotVp.getViewBounds().y);
                imageLayer.render((Rendering)imageRendering);
                pm.worked(4);
            }
            finally {
                pm.done();
            }
            return image;
        }

        private boolean isModelYAxisDown(ImageLayer baseImageLayer) {
            return baseImageLayer.getImageToModelTransform().getDeterminant() > 0.0;
        }

        private String getThumbnailBandName() {
            return ProductUtils.findSuitableQuicklookBandName((Product)ProductSubsetDialog.this.product);
        }
    }
}

