/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import org.esa.snap.core.datamodel.GcpDescriptor;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.image.ColoredBandImageMultiLevelSource;
import org.esa.snap.core.layer.GraticuleLayer;
import org.esa.snap.core.layer.GraticuleLayerType;
import org.esa.snap.core.layer.MaskCollectionLayerType;
import org.esa.snap.core.layer.MaskLayerType;
import org.esa.snap.core.layer.NoDataLayerType;
import org.esa.snap.core.layer.ProductLayerContext;
import org.esa.snap.core.layer.RasterImageLayerType;
import org.esa.snap.core.layer.RgbImageLayerType;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataCollectionLayerType;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.esa.snap.ui.product.VectorDataLayerType;

public class ProductSceneImage
implements ProductLayerContext {
    private static final ImageLayerFilter IMAGE_LAYER_FILTER = new ImageLayerFilter();
    private final String name;
    private final PropertyMap configuration;
    private RasterDataNode[] rasters;
    private Layer rootLayer;
    private ColoredBandImageMultiLevelSource coloredBandImageMultiLevelSource;

    public ProductSceneImage(RasterDataNode raster, PropertyMap configuration, ProgressMonitor pm) {
        this(raster.getDisplayName(), new RasterDataNode[]{raster}, configuration);
        this.coloredBandImageMultiLevelSource = ColoredBandImageMultiLevelSource.create((RasterDataNode)raster, (ProgressMonitor)pm);
        this.initRootLayer();
    }

    public ProductSceneImage(RasterDataNode raster, ProductSceneView view) {
        this(raster.getDisplayName(), new RasterDataNode[]{raster}, view.getSceneImage().getConfiguration());
        this.coloredBandImageMultiLevelSource = view.getSceneImage().getColoredBandImageMultiLevelSource();
        this.initRootLayer();
    }

    public ProductSceneImage(String name, RasterDataNode redRaster, RasterDataNode greenRaster, RasterDataNode blueRaster, PropertyMap configuration, ProgressMonitor pm) {
        this(name, new RasterDataNode[]{redRaster, greenRaster, blueRaster}, configuration);
        this.coloredBandImageMultiLevelSource = ColoredBandImageMultiLevelSource.create((RasterDataNode[])this.rasters, (ProgressMonitor)pm);
        this.initRootLayer();
    }

    private ProductSceneImage(String name, RasterDataNode[] rasters, PropertyMap configuration) {
        this.name = name;
        this.rasters = rasters;
        this.configuration = configuration;
    }

    public PropertyMap getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public ImageInfo getImageInfo() {
        return this.coloredBandImageMultiLevelSource.getImageInfo();
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.coloredBandImageMultiLevelSource.setImageInfo(imageInfo);
    }

    public RasterDataNode[] getRasters() {
        return this.rasters;
    }

    public void setRasters(RasterDataNode[] rasters) {
        this.rasters = rasters;
    }

    public Object getCoordinateReferenceSystem() {
        return this.getProduct().getSceneCRS();
    }

    public Layer getRootLayer() {
        return this.rootLayer;
    }

    Layer getLayer(String id) {
        return LayerUtils.getChildLayerById((Layer)this.getRootLayer(), (String)id);
    }

    void addLayer(int index, Layer layer) {
        this.rootLayer.getChildren().add(index, layer);
    }

    int getFirstImageLayerIndex() {
        return LayerUtils.getChildLayerIndex((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (int)0, (LayerFilter)IMAGE_LAYER_FILTER);
    }

    ImageLayer getBaseImageLayer() {
        return (ImageLayer)this.getLayer("org.esa.snap.layers.baseImage");
    }

    Layer getNoDataLayer(boolean create) {
        Layer layer = this.getLayer("org.esa.snap.layers.noData");
        if (layer == null && create) {
            layer = this.createNoDataLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    Layer getVectorDataCollectionLayer(boolean create) {
        Layer layer = this.getLayer(ProductSceneView.VECTOR_DATA_LAYER_ID);
        if (layer == null && create) {
            layer = this.createVectorDataCollectionLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    Layer getMaskCollectionLayer(boolean create) {
        Layer layer = this.getLayer(ProductSceneView.MASKS_LAYER_ID);
        if (layer == null && create) {
            layer = this.createMaskCollectionLayer();
            this.addLayer(this.getFirstImageLayerIndex(), layer);
        }
        return layer;
    }

    GraticuleLayer getGraticuleLayer(boolean create) {
        GraticuleLayer layer = (GraticuleLayer)this.getLayer("org.esa.snap.layers.graticule");
        if (layer == null && create) {
            layer = this.createGraticuleLayer(this.getImageToModelTransform());
            this.addLayer(0, (Layer)layer);
        }
        return layer;
    }

    Layer getGcpLayer(boolean create) {
        Product product = this.getProduct();
        if (product != null) {
            VectorDataNode vectorDataNode = product.getGcpGroup().getVectorDataNode();
            Layer vectorDataCollectionLayer = this.getVectorDataCollectionLayer(create);
            if (vectorDataCollectionLayer != null) {
                return LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode));
            }
        }
        return null;
    }

    Layer getPinLayer(boolean create) {
        Product product = this.getProduct();
        if (product != null) {
            VectorDataNode vectorDataNode = product.getPinGroup().getVectorDataNode();
            Layer vectorDataCollectionLayer = this.getVectorDataCollectionLayer(create);
            if (vectorDataCollectionLayer != null) {
                return LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode));
            }
        }
        return null;
    }

    private RasterDataNode getRaster() {
        return this.rasters[0];
    }

    private void initRootLayer() {
        this.rootLayer = new CollectionLayer();
        this.addLayer(0, this.createBaseImageLayer());
    }

    public void initVectorDataCollectionLayer() {
        if (this.mustEnableVectorDataCollectionLayer()) {
            this.getVectorDataCollectionLayer(true);
        }
    }

    public void initMaskCollectionLayer() {
        if (this.mustEnableMaskCollectionLayer()) {
            this.getMaskCollectionLayer(true);
        }
    }

    private boolean mustEnableVectorDataCollectionLayer() {
        return this.getRaster().getProduct().getVectorDataGroup().getNodeCount() > 0;
    }

    private boolean mustEnableMaskCollectionLayer() {
        return this.getRaster().getOverlayMaskGroup().getNodeCount() > 0;
    }

    private AffineTransform getImageToModelTransform() {
        return this.coloredBandImageMultiLevelSource.getModel().getImageToModelTransform(0);
    }

    private Layer createBaseImageLayer() {
        Layer layer;
        if (this.getRasters().length == 1) {
            RasterImageLayerType type = (RasterImageLayerType)LayerTypeRegistry.getLayerType(RasterImageLayerType.class);
            layer = type.createLayer(this.getRaster(), (MultiLevelSource)this.coloredBandImageMultiLevelSource);
        } else {
            RgbImageLayerType type = (RgbImageLayerType)LayerTypeRegistry.getLayerType(RgbImageLayerType.class);
            layer = type.createLayer(this.getRasters(), this.coloredBandImageMultiLevelSource);
        }
        layer.setName(this.getName());
        layer.setVisible(true);
        layer.setId("org.esa.snap.layers.baseImage");
        ProductSceneImage.applyBaseImageLayerStyle(this.configuration, layer);
        return layer;
    }

    static void applyBaseImageLayerStyle(PropertyMap configuration, Layer layer) {
        boolean borderShown = configuration.getPropertyBool("image.border.shown", Boolean.valueOf(false));
        double borderWidth = configuration.getPropertyDouble("image.border.size", Double.valueOf(1.0));
        Color borderColor = configuration.getPropertyColor("image.border.color", ImageLayer.DEFAULT_BORDER_COLOR);
        boolean pixelBorderShown = configuration.getPropertyBool("pixel.border.shown", ImageLayer.DEFAULT_PIXEL_BORDER_SHOWN);
        double pixelBorderWidth = configuration.getPropertyDouble("pixel.border.size", Double.valueOf(0.0));
        Color pixelBorderColor = configuration.getPropertyColor("pixel.border.color", ImageLayer.DEFAULT_PIXEL_BORDER_COLOR);
        PropertySet layerConfiguration = layer.getConfiguration();
        layerConfiguration.setValue("borderShown", (Object)borderShown);
        layerConfiguration.setValue("borderWidth", (Object)borderWidth);
        layerConfiguration.setValue("borderColor", (Object)borderColor);
        layerConfiguration.setValue("pixelBorderShown", (Object)pixelBorderShown);
        layerConfiguration.setValue("pixelBorderWidth", (Object)pixelBorderWidth);
        layerConfiguration.setValue("pixelBorderColor", (Object)pixelBorderColor);
    }

    private Layer createNoDataLayer() {
        LayerType noDataType = LayerTypeRegistry.getLayerType(NoDataLayerType.class);
        PropertySet configTemplate = noDataType.createLayerConfig(null);
        Color color = this.configuration.getPropertyColor("noDataOverlay.color", Color.ORANGE);
        configTemplate.setValue("color", (Object)color);
        configTemplate.setValue("raster", (Object)this.getRaster());
        Layer layer = noDataType.createLayer((LayerContext)this, configTemplate);
        double transparency = this.configuration.getPropertyDouble("noDataOverlay.transparency", Double.valueOf(0.3));
        layer.setTransparency(transparency);
        return layer;
    }

    private synchronized Layer createVectorDataCollectionLayer() {
        VectorDataNode[] vectorDataNodes;
        LayerType collectionLayerType = LayerTypeRegistry.getLayerType(VectorDataCollectionLayerType.class);
        Layer collectionLayer = collectionLayerType.createLayer((LayerContext)this, collectionLayerType.createLayerConfig((LayerContext)this));
        ProductNodeGroup vectorDataGroup = this.getRaster().getProduct().getVectorDataGroup();
        for (VectorDataNode vectorDataNode : vectorDataNodes = (VectorDataNode[])vectorDataGroup.toArray((ProductNode[])new VectorDataNode[vectorDataGroup.getNodeCount()])) {
            VectorDataLayer layer = VectorDataLayerType.createLayer((LayerContext)this, vectorDataNode);
            layer.setVisible(vectorDataNode.getPlacemarkDescriptor() instanceof PinDescriptor || vectorDataNode.getPlacemarkDescriptor() instanceof GcpDescriptor);
            collectionLayer.getChildren().add(layer);
        }
        return collectionLayer;
    }

    private synchronized Layer createMaskCollectionLayer() {
        LayerType maskCollectionType = LayerTypeRegistry.getLayerType(MaskCollectionLayerType.class);
        PropertySet layerConfig = maskCollectionType.createLayerConfig(null);
        layerConfig.setValue("raster", (Object)this.getRaster());
        Layer maskCollectionLayer = maskCollectionType.createLayer((LayerContext)this, layerConfig);
        ProductNodeGroup productNodeGroup = this.getRaster().getProduct().getMaskGroup();
        RasterDataNode raster = this.getRaster();
        for (int i = 0; i < productNodeGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)productNodeGroup.get(i);
            if (!raster.getRasterSize().equals(mask.getRasterSize())) continue;
            Layer layer = MaskLayerType.createLayer((RasterDataNode)raster, (Mask)mask);
            maskCollectionLayer.getChildren().add(layer);
        }
        return maskCollectionLayer;
    }

    static void applyNoDataLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
        Color color = configuration.getPropertyColor("noDataOverlay.color", NoDataLayerType.DEFAULT_COLOR);
        layerConfiguration.setValue("color", (Object)color);
        double transparency = configuration.getPropertyDouble("noDataOverlay.transparency", Double.valueOf(0.3));
        layer.setTransparency(transparency);
    }

    static void applyFigureLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
    }

    private GraticuleLayer createGraticuleLayer(AffineTransform i2mTransform) {
        LayerType layerType = LayerTypeRegistry.getLayerType(GraticuleLayerType.class);
        PropertySet template = layerType.createLayerConfig(null);
        template.setValue("raster", (Object)this.getRaster());
        GraticuleLayer graticuleLayer = (GraticuleLayer)layerType.createLayer(null, template);
        graticuleLayer.setId("org.esa.snap.layers.graticule");
        graticuleLayer.setVisible(false);
        graticuleLayer.setName("Graticule");
        ProductSceneImage.applyGraticuleLayerStyle(this.configuration, (Layer)graticuleLayer);
        return graticuleLayer;
    }

    static void applyGraticuleLayerStyle(PropertyMap configuration, Layer layer) {
        PropertySet layerConfiguration = layer.getConfiguration();
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.num.grid.lines", 4, GraticuleLayerType.PROPERTY_NUM_GRID_LINES_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.grid.spacing.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.spacing.lat", 0.0, GraticuleLayerType.PROPERTY_GRID_SPACING_LAT_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.spacing.lon", 0.0, GraticuleLayerType.PROPERTY_GRID_SPACING_LON_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.labels.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.north", true, GraticuleLayerType.PROPERTY_LABELS_NORTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.south", true, GraticuleLayerType.PROPERTY_LABELS_SOUTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.west", true, GraticuleLayerType.PROPERTY_LABELS_WEST_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.east", true, GraticuleLayerType.PROPERTY_LABELS_EAST_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.suffix.nswe", true, GraticuleLayerType.PROPERTY_LABELS_SUFFIX_NSWE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.decimal.value", false, GraticuleLayerType.PROPERTY_LABELS_DECIMAL_VALUE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.inside", false, GraticuleLayerType.PROPERTY_LABELS_INSIDE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.font.italic", false, GraticuleLayerType.PROPERTY_LABELS_ITALIC_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.font.bold", false, GraticuleLayerType.PROPERTY_LABELS_BOLD_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.font.name", "SanSerif", GraticuleLayerType.PROPERTY_LABELS_FONT_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.rotation.lon", 45.0, GraticuleLayerType.PROPERTY_LABELS_ROTATION_LON_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.rotation.lat", 0.0, GraticuleLayerType.PROPERTY_LABELS_ROTATION_LAT_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.size", 12, GraticuleLayerType.PROPERTY_LABELS_SIZE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.labels.color", GraticuleLayerType.PROPERTY_LABELS_COLOR_DEFAULT, GraticuleLayerType.PROPERTY_LABELS_COLOR_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.show", true, GraticuleLayerType.PROPERTY_GRIDLINES_SHOW_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.width", 0.8, GraticuleLayerType.PROPERTY_GRIDLINES_WIDTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.dashed.phase", 3.0, GraticuleLayerType.PROPERTY_GRIDLINES_DASHED_PHASE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.transparency", 0.6, GraticuleLayerType.PROPERTY_GRIDLINES_TRANSPARENCY_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.gridlines.color", GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_DEFAULT, GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.border.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.border.show", true, GraticuleLayerType.PROPERTY_BORDER_SHOW_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.border.width", 1.2, GraticuleLayerType.PROPERTY_BORDER_WIDTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.border.color", GraticuleLayerType.PROPERTY_BORDER_COLOR_DEFAULT, GraticuleLayerType.PROPERTY_BORDER_COLOR_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.tickmarks.show");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.tickmarks.show", true, GraticuleLayerType.PROPERTY_TICKMARKS_SHOW_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.tickmarks.inside", false, GraticuleLayerType.PROPERTY_TICKMARKS_INSIDE_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.tickmarks.length", 3.0, GraticuleLayerType.PROPERTY_TICKMARKS_LENGTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.tickmarks.color", GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_DEFAULT, GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.corner.labels.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.corner.labels.north", false, GraticuleLayerType.PROPERTY_CORNER_LABELS_NORTH_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.corner.labels.west", false, GraticuleLayerType.PROPERTY_CORNER_LABELS_WEST_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.corner.labels.east", false, GraticuleLayerType.PROPERTY_CORNER_LABELS_EAST_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.corner.labels.south", false, GraticuleLayerType.PROPERTY_CORNER_LABELS_SOUTH_TYPE);
        ProductSceneImage.addSectionPropertyToLayerConfiguration(configuration, layer, "graticule.labels.backdrop.section");
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.text.bg.transparency", 0.3, GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_TRANSPARENCY_TYPE);
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, "graticule.text.bg.color", GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_DEFAULT, GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_TYPE);
    }

    private static void addPropertyToLayerConfiguration(PropertyMap configuration, Layer layer, String propertyName, Object propertyDefault, Class type) {
        PropertySet layerConfiguration = layer.getConfiguration();
        if (type == Boolean.class) {
            layerConfiguration.setValue(propertyName, (Object)configuration.getPropertyBool(propertyName, (Boolean)propertyDefault));
        } else if (type == Double.class) {
            layerConfiguration.setValue(propertyName, (Object)configuration.getPropertyDouble(propertyName, (Double)propertyDefault));
        } else if (type == Color.class) {
            layerConfiguration.setValue(propertyName, (Object)configuration.getPropertyColor(propertyName, (Color)propertyDefault));
        } else if (type == Integer.class) {
            layerConfiguration.setValue(propertyName, (Object)configuration.getPropertyInt(propertyName, (Integer)propertyDefault));
        } else if (type == String.class) {
            layerConfiguration.setValue(propertyName, (Object)configuration.getPropertyString(propertyName, (String)propertyDefault));
        }
    }

    private static void addSectionPropertyToLayerConfiguration(PropertyMap configuration, Layer layer, String propertyName) {
        ProductSceneImage.addPropertyToLayerConfiguration(configuration, layer, propertyName, true, Boolean.class);
    }

    private ColoredBandImageMultiLevelSource getColoredBandImageMultiLevelSource() {
        return this.coloredBandImageMultiLevelSource;
    }

    public Product getProduct() {
        return this.getRaster().getProduct();
    }

    public ProductNode getProductNode() {
        return this.getRaster();
    }

    private static class ImageLayerFilter
    implements LayerFilter {
        private ImageLayerFilter() {
        }

        public boolean accept(Layer layer) {
            return layer instanceof ImageLayer;
        }
    }
}

