/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.ui.BasicView;
import org.esa.snap.ui.PopupMenuHandler;
import org.esa.snap.ui.io.TableModelCsvEncoder;
import org.esa.snap.ui.product.ProductNodeView;
import org.openide.util.Utilities;

public class ProductPlacemarkView
extends BasicView
implements ProductNodeView {
    private VectorDataNode vectorDataNode;
    private final PlacemarkTableModel tableModel;

    public ProductPlacemarkView(VectorDataNode vectorDataNode) {
        this.vectorDataNode = vectorDataNode;
        this.vectorDataNode.getProduct().addProductNodeListener((ProductNodeListener)new PNL());
        this.tableModel = new PlacemarkTableModel();
        JTable placemarkTable = new JTable();
        placemarkTable.setRowSorter(new TableRowSorter<PlacemarkTableModel>(this.tableModel));
        placemarkTable.addMouseListener(new PopupMenuHandler(this));
        placemarkTable.setAutoResizeMode(0);
        placemarkTable.setModel(this.tableModel);
        TableCellRenderer renderer = placemarkTable.getTableHeader().getDefaultRenderer();
        int margin = placemarkTable.getTableHeader().getColumnModel().getColumnMargin();
        Enumeration<TableColumn> columns = placemarkTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            int width = this.getColumnMinWith(tableColumn, renderer, margin);
            tableColumn.setMinWidth(width);
        }
        JScrollPane scrollPane = new JScrollPane(placemarkTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorDataNode;
    }

    @Override
    public ProductNode getVisibleProductNode() {
        return this.vectorDataNode;
    }

    @Override
    public JPopupMenu createPopupMenu(Component component) {
        JPopupMenu popupMenu = new JPopupMenu();
        List viewActions = Utilities.actionsForPath((String)"Context/ProductPlacemarkView");
        for (Action action : viewActions) {
            popupMenu.add(action);
        }
        popupMenu.add(new CopyToClipboardAction());
        return popupMenu;
    }

    @Override
    public JPopupMenu createPopupMenu(MouseEvent event) {
        return null;
    }

    private int getColumnMinWith(TableColumn column, TableCellRenderer renderer, int margin) {
        Object headerValue = column.getHeaderValue();
        JLabel label = (JLabel)renderer.getTableCellRendererComponent(null, headerValue, false, false, 0, 0);
        return label.getPreferredSize().width + margin;
    }

    private void onNodeChange(ProductNodeEvent event) {
        ProductNode sourceNode = event.getSourceNode();
        if (sourceNode == this.vectorDataNode) {
            this.updateTable();
        } else if (sourceNode.getOwner() == this.vectorDataNode.getPlacemarkGroup()) {
            this.updateTable();
        }
    }

    private void updateTable() {
        this.tableModel.fireTableDataChanged();
    }

    private void copyTextDataToClipboard() {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String dataAsText = this.getDataAsText();
            if (dataAsText != null) {
                SystemUtils.copyToClipboard((String)dataAsText);
            }
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    private String getDataAsText() {
        StringWriter writer = new StringWriter();
        try {
            new TableModelCsvEncoder(this.tableModel).encodeCsv(writer);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        public CopyToClipboardAction() {
            super("Copy to clipboard");
            this.putValue("ShortDescription", "The entire table content will be copied to the clipboard.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductPlacemarkView.this.copyTextDataToClipboard();
        }
    }

    private class PNL
    implements ProductNodeListener {
        private PNL() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            ProductPlacemarkView.this.onNodeChange(event);
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            ProductPlacemarkView.this.onNodeChange(event);
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductPlacemarkView.this.onNodeChange(event);
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductPlacemarkView.this.onNodeChange(event);
        }
    }

    private class PlacemarkTableModel
    extends AbstractTableModel {
        private PlacemarkTableModel() {
        }

        @Override
        public int getRowCount() {
            return ProductPlacemarkView.this.vectorDataNode.getPlacemarkGroup().getNodeCount();
        }

        @Override
        public int getColumnCount() {
            return ProductPlacemarkView.this.vectorDataNode.getFeatureType().getAttributeCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return ProductPlacemarkView.this.vectorDataNode.getFeatureType().getDescriptor(columnIndex).getLocalName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ProductPlacemarkView.this.vectorDataNode.getFeatureType().getDescriptor(columnIndex).getType().getBinding();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Placemark)ProductPlacemarkView.this.vectorDataNode.getPlacemarkGroup().get(rowIndex)).getFeature().getAttribute(columnIndex);
        }
    }
}

