/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;
import org.esa.snap.core.util.converters.GeneralExpressionConverter;
import org.esa.snap.ui.product.ProductExpressionPane;

public abstract class ExpressionEditor
extends PropertyEditor {
    private Product currentProduct;

    public JComponent createEditorComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JTextField textField = new JTextField();
        textField.setPreferredSize(new Dimension(100, textField.getPreferredSize().height));
        TextComponentAdapter adapter = new TextComponentAdapter((JTextComponent)textField);
        final Binding binding = bindingContext.bind(propertyDescriptor.getName(), (ComponentAdapter)adapter);
        JPanel subPanel = new JPanel(new BorderLayout(2, 2));
        subPanel.add((Component)textField, "Center");
        final JButton etcButton = new JButton("...");
        etcButton.setEnabled(false);
        etcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductExpressionPane expressionPane = ExpressionEditor.this.getProductExpressionPane(ExpressionEditor.this.currentProduct);
                expressionPane.setCode((String)binding.getPropertyValue());
                if (expressionPane.showModalDialog(null, "Expression Editor") == 1) {
                    binding.setPropertyValue((Object)expressionPane.getCode());
                }
            }
        });
        Property property = Property.create((String)"SOURCE_PRODUCT", Product.class, null, (boolean)false);
        property.getDescriptor().setTransient(true);
        bindingContext.getPropertySet().addProperty(property);
        bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SOURCE_PRODUCT")) {
                    ExpressionEditor.this.currentProduct = (Product)evt.getNewValue();
                    etcButton.setEnabled(ExpressionEditor.this.currentProduct != null);
                }
            }
        });
        subPanel.add((Component)etcButton, "East");
        return subPanel;
    }

    abstract ProductExpressionPane getProductExpressionPane(Product var1);

    public static class BooleanExpressionEditor
    extends ExpressionEditor {
        public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
            return propertyDescriptor.getConverter() instanceof BooleanExpressionConverter;
        }

        @Override
        ProductExpressionPane getProductExpressionPane(Product currentProduct) {
            return ProductExpressionPane.createBooleanExpressionPane(new Product[]{currentProduct}, currentProduct, null);
        }
    }

    public static class GeneralExpressionEditor
    extends ExpressionEditor {
        public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
            return propertyDescriptor.getConverter() instanceof GeneralExpressionConverter;
        }

        @Override
        ProductExpressionPane getProductExpressionPane(Product currentProduct) {
            return ProductExpressionPane.createGeneralExpressionPane(new Product[]{currentProduct}, currentProduct, null);
        }
    }
}

