/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.product.BandChoosingStrategy;
import org.esa.snap.ui.product.BandSorter;

public class DefaultBandChoosingStrategy
implements BandChoosingStrategy {
    private static final Font SMALL_PLAIN_FONT = new Font("SansSerif", 0, 10);
    private static final Font SMALL_ITALIC_FONT = SMALL_PLAIN_FONT.deriveFont(2);
    private Band[] allBands;
    private Band[] selectedBands;
    private TiePointGrid[] allTiePointGrids;
    private TiePointGrid[] selectedTiePointGrids;
    private boolean multipleProducts;
    private int numSelected;
    private JCheckBox[] checkBoxes;
    private JCheckBox selectAllCheckBox;
    private JCheckBox selectNoneCheckBox;

    public DefaultBandChoosingStrategy(Band[] allBands, Band[] selectedBands, TiePointGrid[] allTiePointGrids, TiePointGrid[] selectedTiePointGrids, boolean multipleProducts) {
        this.allBands = allBands;
        this.selectedBands = selectedBands;
        this.allTiePointGrids = allTiePointGrids;
        this.selectedTiePointGrids = selectedTiePointGrids;
        if (this.allBands == null) {
            this.allBands = new Band[0];
        }
        if (this.selectedBands == null) {
            this.selectedBands = new Band[0];
        }
        if (this.allTiePointGrids == null) {
            this.allTiePointGrids = new TiePointGrid[0];
        }
        if (this.selectedTiePointGrids == null) {
            this.selectedTiePointGrids = new TiePointGrid[0];
        }
        BandSorter.sort(allBands);
        this.multipleProducts = multipleProducts;
    }

    @Override
    public Band[] getSelectedBands() {
        this.checkSelectedBandsAndGrids();
        return this.selectedBands;
    }

    @Override
    public TiePointGrid[] getSelectedTiePointGrids() {
        this.checkSelectedBandsAndGrids();
        return this.selectedTiePointGrids;
    }

    @Override
    public JPanel createCheckersPane() {
        int length = 0;
        if (this.allBands != null) {
            length += this.allBands.length;
        }
        if (this.allTiePointGrids != null) {
            length += this.allTiePointGrids.length;
        }
        this.checkBoxes = new JCheckBox[length];
        JPanel checkersPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints("insets.left=4,anchor=NORTHWEST,fill=HORIZONTAL");
        ActionListener checkListener = this.createActionListener();
        this.addBandCheckers(new StringBuffer(), checkersPane, gbc, checkListener);
        this.addTiePointCheckers(new StringBuffer(), checkersPane, gbc, checkListener);
        GridBagUtils.addVerticalFiller(checkersPane, gbc);
        return checkersPane;
    }

    private void addBandCheckers(StringBuffer description, JPanel checkersPane, GridBagConstraints gbc, ActionListener checkListener) {
        for (int i = 0; i < this.allBands.length; ++i) {
            Band band = this.allBands[i];
            boolean checked = false;
            for (Band selectedBand : this.selectedBands) {
                if (band != selectedBand) continue;
                checked = true;
                ++this.numSelected;
                break;
            }
            description.setLength(0);
            description.append(band.getDescription() == null ? "" : band.getDescription());
            if ((double)band.getSpectralWavelength() > 0.0) {
                description.append(" (");
                description.append(band.getSpectralWavelength());
                description.append(" nm)");
            }
            JCheckBox check = new JCheckBox(this.getRasterDisplayName((RasterDataNode)band), checked);
            check.setFont(SMALL_PLAIN_FONT);
            check.addActionListener(checkListener);
            JLabel label = new JLabel(description.toString());
            label.setFont(SMALL_ITALIC_FONT);
            ++gbc.gridy;
            GridBagUtils.addToPanel(checkersPane, check, gbc, "weightx=0,gridx=0");
            GridBagUtils.addToPanel(checkersPane, label, gbc, "weightx=1,gridx=1");
            this.checkBoxes[i] = check;
        }
    }

    private void addTiePointCheckers(StringBuffer description, JPanel checkersPane, GridBagConstraints gbc, ActionListener checkListener) {
        for (int i = 0; i < this.allTiePointGrids.length; ++i) {
            TiePointGrid grid = this.allTiePointGrids[i];
            boolean checked = false;
            for (TiePointGrid selectedGrid : this.selectedTiePointGrids) {
                if (grid != selectedGrid) continue;
                checked = true;
                ++this.numSelected;
                break;
            }
            description.setLength(0);
            description.append(grid.getDescription() == null ? "" : grid.getDescription());
            JCheckBox check = new JCheckBox(this.getRasterDisplayName((RasterDataNode)grid), checked);
            check.setFont(SMALL_PLAIN_FONT);
            check.addActionListener(checkListener);
            JLabel label = new JLabel(description.toString());
            label.setFont(SMALL_ITALIC_FONT);
            ++gbc.gridy;
            GridBagUtils.addToPanel(checkersPane, check, gbc, "weightx=0,gridx=0");
            GridBagUtils.addToPanel(checkersPane, label, gbc, "weightx=1,gridx=1");
            this.checkBoxes[i + this.allBands.length] = check;
        }
    }

    private String getRasterDisplayName(RasterDataNode rasterDataNode) {
        return this.multipleProducts ? rasterDataNode.getDisplayName() : rasterDataNode.getName();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox check = (JCheckBox)e.getSource();
                DefaultBandChoosingStrategy.this.numSelected = check.isSelected() ? ++DefaultBandChoosingStrategy.this.numSelected : --DefaultBandChoosingStrategy.this.numSelected;
                DefaultBandChoosingStrategy.this.updateCheckBoxStates();
            }
        };
    }

    @Override
    public void updateCheckBoxStates() {
        this.selectAllCheckBox.setSelected(this.numSelected == this.checkBoxes.length);
        this.selectAllCheckBox.setEnabled(this.numSelected < this.checkBoxes.length);
        this.selectAllCheckBox.updateUI();
        this.selectNoneCheckBox.setSelected(this.numSelected == 0);
        this.selectNoneCheckBox.setEnabled(this.numSelected > 0);
        this.selectNoneCheckBox.updateUI();
    }

    @Override
    public void setCheckBoxes(JCheckBox selectAllCheckBox, JCheckBox selectNoneCheckBox) {
        this.selectAllCheckBox = selectAllCheckBox;
        this.selectNoneCheckBox = selectNoneCheckBox;
        this.updateCheckBoxStates();
    }

    @Override
    public void selectAll() {
        this.select(true);
    }

    @Override
    public void selectNone() {
        this.select(false);
    }

    @Override
    public boolean atLeastOneBandSelected() {
        this.checkSelectedBandsAndGrids();
        return this.selectedBands.length > 0;
    }

    @Override
    public void selectRasterDataNodes(String[] nodeNames) {
        int i;
        block0: for (i = 0; i < this.allBands.length; ++i) {
            Band band = this.allBands[i];
            for (String nodeName : nodeNames) {
                if (!nodeName.equals(band.getName())) continue;
                this.checkBoxes[i].setSelected(true);
                ++this.numSelected;
                continue block0;
            }
        }
        block2: for (i = 0; i < this.allTiePointGrids.length; ++i) {
            TiePointGrid grid = this.allTiePointGrids[i];
            for (String nodeName : nodeNames) {
                if (!nodeName.equals(grid.getName())) continue;
                this.checkBoxes[this.allBands.length + i].setSelected(true);
                ++this.numSelected;
                continue block2;
            }
        }
        this.updateCheckBoxStates();
    }

    private void checkSelectedBandsAndGrids() {
        ArrayList<Band> bands = new ArrayList<Band>();
        ArrayList<TiePointGrid> grids = new ArrayList<TiePointGrid>();
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            JCheckBox checkBox = this.checkBoxes[i];
            if (!checkBox.isSelected()) continue;
            if (this.allBands.length > i) {
                bands.add(this.allBands[i]);
                continue;
            }
            grids.add(this.allTiePointGrids[i - this.allBands.length]);
        }
        this.selectedBands = bands.toArray(new Band[bands.size()]);
        this.selectedTiePointGrids = grids.toArray(new TiePointGrid[grids.size()]);
    }

    private void select(boolean b) {
        for (JCheckBox checkBox : this.checkBoxes) {
            if (b && !checkBox.isSelected()) {
                ++this.numSelected;
            }
            if (!b && checkBox.isSelected()) {
                --this.numSelected;
            }
            checkBox.setSelected(b);
        }
        this.updateCheckBoxStates();
    }
}

