/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class VerticalScrollablePanel
extends JPanel
implements Scrollable {
    private final int maximumUnitIncrement;

    public VerticalScrollablePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.maximumUnitIncrement = 10;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maximumUnitIncrement * this.maximumUnitIncrement;
            return newPosition == 0 ? this.maximumUnitIncrement : newPosition;
        }
        return (currentPosition / this.maximumUnitIncrement + 1) * this.maximumUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maximumUnitIncrement;
        }
        return visibleRect.height - this.maximumUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

