/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.esa.snap.ui.loading.CustomComboBox;
import org.esa.snap.ui.loading.ItemRenderer;

public class SwingUtils {
    public static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
    public static final LineBorder LINE_BORDER = new LineBorder(Color.GRAY, 1);
    public static final EmptyBorder EDIT_TEXT_BORDER = new EmptyBorder(0, 2, 0, 0);

    private SwingUtils() {
    }

    public static ImageIcon loadImage(String resourceImagePath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL imageURL = classLoader.getResource(resourceImagePath);
        if (imageURL == null) {
            throw new NullPointerException("The image '" + resourceImagePath + "' does not exist into the sources.");
        }
        return new ImageIcon(imageURL);
    }

    public static ImageIcon loadImage(String resourceImagePath, Dimension buttonSize, Integer scaledImagePadding) {
        ImageIcon icon = SwingUtils.loadImage(resourceImagePath);
        if (scaledImagePadding != null && scaledImagePadding >= 0) {
            Image scaledImage = SwingUtils.getScaledImage(icon.getImage(), buttonSize.width, buttonSize.height, scaledImagePadding);
            icon = new ImageIcon(scaledImage);
        }
        return icon;
    }

    public static JButton buildButton(String resourceImagePath, ActionListener buttonListener, Dimension buttonSize, Integer scaledImagePadding) {
        ImageIcon icon = SwingUtils.loadImage(resourceImagePath, buttonSize, scaledImagePadding);
        JButton button = new JButton(icon);
        button.setFocusable(false);
        button.addActionListener(buttonListener);
        button.setPreferredSize(buttonSize);
        button.setMinimumSize(buttonSize);
        button.setMaximumSize(buttonSize);
        return button;
    }

    private static Image getScaledImage(Image srcImg, int destinationImageWidth, int destinationImageHeight, int padding) {
        BufferedImage resizedImg = new BufferedImage(destinationImageWidth, destinationImageHeight, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, padding, padding, destinationImageWidth - padding, destinationImageHeight - padding, 0, 0, srcImg.getWidth(null), srcImg.getHeight(null), null);
        g2.dispose();
        return resizedImg;
    }

    public static JComboBox<String> buildComboBox(String[] values, String valueToSelect, int textFieldPreferredHeight, boolean isEditable) {
        int i;
        ItemRenderer<String> itemRenderer = new ItemRenderer<String>(){

            @Override
            public String getItemDisplayText(String item) {
                return item == null ? " " : item;
            }
        };
        CustomComboBox<String> comboBox = new CustomComboBox<String>(itemRenderer, textFieldPreferredHeight, isEditable);
        if (values != null) {
            for (i = 0; i < values.length; ++i) {
                comboBox.addItem(values[i]);
            }
        }
        if (valueToSelect != null) {
            for (i = 0; i < values.length; ++i) {
                if (!valueToSelect.equals(values[i])) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
        return comboBox;
    }

    public static JButton buildBrowseButton(ActionListener actionListener, int textFieldPreferredHeight) {
        JButton browseButton = new JButton("...");
        browseButton.setFocusable(false);
        browseButton.addActionListener(actionListener);
        Dimension preferredSize = new Dimension(textFieldPreferredHeight, textFieldPreferredHeight);
        browseButton.setPreferredSize(preferredSize);
        browseButton.setMinimumSize(preferredSize);
        browseButton.setMaximumSize(preferredSize);
        return browseButton;
    }

    public static GridBagConstraints buildConstraints(int columnIndex, int rowIndex, int fillType, int anchorType, int columnSpan, int rowSpan, Insets aMargins) {
        GridBagConstraints constraints = SwingUtils.buildConstraints(columnIndex, rowIndex, fillType, anchorType, columnSpan, rowSpan);
        constraints.insets.top = aMargins.top;
        constraints.insets.left = aMargins.left;
        constraints.insets.bottom = aMargins.bottom;
        constraints.insets.right = aMargins.right;
        return constraints;
    }

    public static GridBagConstraints buildConstraints(int columnIndex, int rowIndex, int fillType, int anchorType, int columnSpan, int rowSpan, int topMargin, int leftMargin) {
        GridBagConstraints constraints = SwingUtils.buildConstraints(columnIndex, rowIndex, fillType, anchorType, columnSpan, rowSpan);
        constraints.insets.top = topMargin;
        constraints.insets.left = leftMargin;
        constraints.insets.bottom = 0;
        constraints.insets.right = 0;
        return constraints;
    }

    public static GridBagConstraints buildConstraints(int columnIndex, int rowIndex, int fillType, int anchorType, int columnSpan, int rowSpan) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = columnIndex;
        constraints.gridy = rowIndex;
        constraints.gridwidth = columnSpan;
        constraints.gridheight = rowSpan;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        if (fillType == 2) {
            constraints.weightx = 1.0;
        } else if (fillType == 3) {
            constraints.weighty = 1.0;
        } else if (fillType == 1) {
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
        }
        constraints.fill = fillType;
        constraints.anchor = anchorType;
        return constraints;
    }
}

