/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.esa.snap.ui.loading.CircularProgressIndicatorLabel;
import org.esa.snap.ui.loading.ComponentsEnabled;
import org.esa.snap.ui.loading.LoadingIndicator;
import org.esa.snap.ui.loading.SwingUtils;

public class LoadingIndicatorPanel
extends JPanel
implements LoadingIndicator {
    private final Object lockObject;
    private final ComponentsEnabled componentsEnabled;
    private final CircularProgressIndicatorLabel circularProgressLabel;
    private final JLabel messageLabel;
    private boolean isRunning;
    private int currentThreadId;

    public LoadingIndicatorPanel() {
        this((ComponentsEnabled)null);
    }

    public LoadingIndicatorPanel(ComponentsEnabled componentsEnabled) {
        super(new GridBagLayout());
        this.componentsEnabled = componentsEnabled;
        this.circularProgressLabel = new CircularProgressIndicatorLabel();
        GridBagConstraints c = SwingUtils.buildConstraints(0, 0, 0, 10, 1, 1, new Insets(1, 1, 1, 1));
        this.add((Component)this.circularProgressLabel, c);
        this.messageLabel = new JLabel();
        c = SwingUtils.buildConstraints(0, 1, 0, 10, 1, 1, new Insets(1, 3, 1, 3));
        this.add((Component)this.messageLabel, c);
        super.setBorder(new LineBorder(Color.gray, 1, false));
        super.setOpaque(true);
        this.stopAndHide();
        this.isRunning = false;
        this.lockObject = new Object();
        this.currentThreadId = 0;
    }

    @Override
    public final void setOpaque(boolean aIsOpaque) {
    }

    @Override
    public final void setBorder(Border aBorder) {
    }

    @Override
    public final void removeNotify() {
        this.setRunningAndIncreaseThreadId(false);
        super.removeNotify();
    }

    @Override
    public final Color getBackground() {
        return Color.white;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isRunning(int threadId) {
        Object object = this.lockObject;
        synchronized (object) {
            return this.isRunning && this.currentThreadId == threadId;
        }
    }

    @Override
    public final boolean onDisplay(int threadId, String messageToDisplay) {
        if (this.isRunning(threadId)) {
            try {
                this.setEnabledControls(false);
            }
            finally {
                this.showAndStart(threadId, messageToDisplay);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onHide(int threadId) {
        if (this.isRunning(threadId)) {
            this.stopRunningAndHide();
            return true;
        }
        return false;
    }

    public final int getNewCurrentThreadId() {
        return this.setRunningAndIncreaseThreadId(true);
    }

    public void stopRunningAndHide() {
        this.setRunningAndIncreaseThreadId(false);
        try {
            this.setEnabledControls(true);
        }
        finally {
            this.stopAndHide();
        }
    }

    private void showAndStart(int threadId, String messageToDisplay) {
        boolean visibleMessage = messageToDisplay != null && messageToDisplay.trim().length() > 0;
        this.messageLabel.setText(messageToDisplay);
        this.messageLabel.setVisible(visibleMessage);
        IntRunnable action = new IntRunnable(threadId){

            @Override
            protected void run(int inputThreadId) {
                if (LoadingIndicatorPanel.this.isRunning(inputThreadId)) {
                    LoadingIndicatorPanel.this.circularProgressLabel.setRunning(true);
                    LoadingIndicatorPanel.this.setVisible(true);
                }
            }
        };
        SwingUtilities.invokeLater(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setRunningAndIncreaseThreadId(boolean value) {
        Object object = this.lockObject;
        synchronized (object) {
            this.isRunning = value;
            return ++this.currentThreadId;
        }
    }

    private void stopAndHide() {
        this.circularProgressLabel.setRunning(false);
        this.setVisible(false);
    }

    private void setEnabledControls(boolean enabled) {
        if (this.componentsEnabled != null) {
            this.componentsEnabled.setComponentsEnabled(enabled);
        }
    }

    private static abstract class IntRunnable
    implements Runnable {
        private final int value;

        IntRunnable(int value) {
            this.value = value;
        }

        protected abstract void run(int var1);

        @Override
        public void run() {
            this.run(this.value);
        }
    }
}

