/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.esa.snap.ui.loading.ItemRenderer;

public class LabelListCellRenderer<ItemType>
extends JLabel
implements ListCellRenderer<ItemType> {
    private final ItemRenderer<ItemType> itemRenderer;

    public LabelListCellRenderer(Insets margins) {
        this(margins, null);
    }

    public LabelListCellRenderer(Insets margins, ItemRenderer<ItemType> itemRenderer) {
        this.itemRenderer = itemRenderer;
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(margins));
    }

    public LabelListCellRenderer(int itemHeight) {
        this(itemHeight, null);
    }

    public LabelListCellRenderer(int itemHeight, ItemRenderer<ItemType> itemRenderer) {
        this.itemRenderer = itemRenderer;
        this.setOpaque(true);
        Dimension rendererSize = this.getPreferredSize();
        rendererSize.height = itemHeight;
        this.setPreferredSize(rendererSize);
    }

    public JLabel getListCellRendererComponent(JList<? extends ItemType> list, ItemType value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foregroundColor;
        Color backgroundColor;
        if (isSelected) {
            backgroundColor = list.getSelectionBackground();
            foregroundColor = list.getSelectionForeground();
        } else {
            backgroundColor = list.getBackground();
            foregroundColor = list.getForeground();
        }
        this.setBackground(backgroundColor);
        this.setForeground(foregroundColor);
        String itemDisplayName = this.getItemDisplayText(value);
        this.setText(itemDisplayName);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        return this;
    }

    protected String getItemDisplayText(ItemType item) {
        if (this.itemRenderer == null) {
            return item == null ? null : item.toString();
        }
        return this.itemRenderer.getItemDisplayText(item);
    }
}

