/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class CustomSplitPane
extends JSplitPane {
    private final int visibleDividerSize;
    private final int dividerMargins;
    private final Color dividerColor;
    private float initialDividerLocationPercent;

    public CustomSplitPane(int newOrientation, int visibleDividerSize, int dividerMargins, float initialDividerLocationPercent) {
        this(newOrientation, visibleDividerSize, dividerMargins, initialDividerLocationPercent, UIManager.getColor("controlShadow"));
    }

    public CustomSplitPane(int newOrientation, int visibleDividerSize, int dividerMargins, float initialDividerLocationPercent, Color dividerColor) {
        super(newOrientation);
        if (visibleDividerSize < 0) {
            throw new IllegalArgumentException("The visible divider size " + visibleDividerSize + " must be >= 0.");
        }
        if (dividerMargins < 0) {
            throw new IllegalArgumentException("The divider margins " + dividerMargins + " must be >= 0.");
        }
        if (initialDividerLocationPercent < 0.0f || initialDividerLocationPercent > 1.0f) {
            throw new IllegalArgumentException("The initial divider location percent " + initialDividerLocationPercent + " must be between 0.0 and 1.0.");
        }
        this.visibleDividerSize = visibleDividerSize;
        this.dividerMargins = dividerMargins;
        this.dividerColor = dividerColor;
        this.initialDividerLocationPercent = initialDividerLocationPercent;
        super.setDividerSize(2 * this.dividerMargins + this.visibleDividerSize);
        this.setContinuousLayout(true);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void setDividerSize(int newSize) {
    }

    @Override
    public void updateUI() {
        this.setUI(new CustomSplitPaneDividerUI());
        this.revalidate();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int availableWidth = this.getSize().width;
        if (availableWidth > 0 && this.initialDividerLocationPercent > 0.0f) {
            int dividerLocation = (int)(this.initialDividerLocationPercent * (float)availableWidth);
            this.setDividerLocation(dividerLocation);
            this.initialDividerLocationPercent = 0.0f;
        }
    }

    private class CustomSplitPaneDivider
    extends BasicSplitPaneDivider {
        private CustomSplitPaneDivider(BasicSplitPaneUI ui) {
            super(ui);
            super.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(CustomSplitPane.this.dividerColor);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            if (this.orientation == 1) {
                graphics.fillRect(CustomSplitPane.this.dividerMargins, 0, CustomSplitPane.this.visibleDividerSize, this.getHeight());
            } else {
                graphics.fillRect(0, CustomSplitPane.this.dividerMargins, this.getWidth(), CustomSplitPane.this.visibleDividerSize);
            }
        }
    }

    private class CustomSplitPaneDividerUI
    extends BasicSplitPaneUI {
        private CustomSplitPaneDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new CustomSplitPaneDivider(this);
        }
    }
}

